/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.mapper;

import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ExternalAppId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.mybatis.typehandler.ExternalAppSettingsClientTypeHandler;
import java.util.Set;
import kotlin.Metadata;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mapper
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH'J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\fH'J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u000b\u001a\u00020\fH'J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH'J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;", "", "upsert", "", "externalAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "findExternalAppSettings", "id", "Lde/justsoftware/admin/id/ExternalAppId;", "getAllByTenantId", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "getIconIds", "Lde/justsoftware/admin/id/DocumentId;", "deleteById", "deleteByTenant", "admin-service"})
public interface ExternalAppSettingsMapper {
    @Insert(value={"\n        <script>\n            <if test=\"_databaseId == 'POSTGRES'\">\n                INSERT INTO external_app_settings (id, name, url, home_screen_app_color, tenant_id, open_url_in, active, icon_id, clients)\n                    VALUES (#{id}, #{name}, #{url}, #{homeScreenAppColor}, #{tenantId}, #{openUrlIn}, #{active}, #{iconId}, #{clients})\n                ON CONFLICT(id) DO UPDATE SET\n                    name = #{name},\n                    url = #{url},\n                    home_screen_app_color = #{homeScreenAppColor},\n                    open_url_in = #{openUrlIn},\n                    active = #{active},\n                    icon_id = #{iconId},\n                    clients = #{clients}\n            </if>\n\n            <if test=\"_databaseId == 'ORACLE'\">\n                MERGE INTO external_app_settings settings\n                    USING (SELECT #{id} as id from dual) a\n                        ON (a.id = settings.id)\n                        WHEN MATCHED THEN UPDATE SET\n                            name = #{name},\n                            url = #{url},\n                            home_screen_app_color = #{homeScreenAppColor},\n                            open_url_in = #{openUrlIn},\n                            active = #{active},\n                            icon_id = #{iconId},\n                            clients = #{clients}\n                        WHEN NOT MATCHED THEN\n                            INSERT (id, name, url, home_screen_app_color, tenant_id, open_url_in, active, icon_id, clients)\n                            VALUES (#{id}, #{name}, #{url}, #{homeScreenAppColor}, #{tenantId}, #{openUrlIn}, #{active}, #{iconId}, #{clients})\n            </if>\n        </script>\n        "})
    public void upsert(@NotNull ExternalAppSettings var1);

    @Results(id="ExternalAppSettingsResult")
    @ConstructorArgs(value={@Arg(id=true, column="id", javaType=ExternalAppId.class), @Arg(column="active", javaType=boolean.class), @Arg(column="icon_id", javaType=DocumentId.class), @Arg(column="name", javaType=String.class), @Arg(column="open_url_in", javaType=ExternalAppSettings.OpenUrlIn.class), @Arg(column="url", javaType=String.class), @Arg(column="home_screen_app_color", javaType=HexColor.class), @Arg(column="position", javaType=int.class), @Arg(column="tenant_id", javaType=TenantId.class), @Arg(column="clients", javaType=Set.class, typeHandler=ExternalAppSettingsClientTypeHandler.class)})
    @Select(value={"\n        SELECT app_settings.*,\n            app_home_screen_position.position\n            FROM external_app_settings app_settings\n        INNER JOIN app_home_screen_position on app_settings.id = app_home_screen_position.app_id\n        WHERE id = #{id}\n        "})
    @Nullable
    public ExternalAppSettings findExternalAppSettings(@NotNull ExternalAppId var1);

    @ResultMap(value={"ExternalAppSettingsResult"})
    @Select(value={"\n        SELECT app_settings.*, \n            app_home_screen_position.position\n            FROM external_app_settings app_settings\n        INNER JOIN app_home_screen_position on app_settings.id = app_home_screen_position.app_id\n        WHERE app_settings.tenant_id = #{tenantId}\n        "})
    @NotNull
    public Set<ExternalAppSettings> getAllByTenantId(@NotNull TenantId var1);

    @Select(value={"SELECT icon_id FROM external_app_settings WHERE tenant_id = #{tenantId} AND icon_id IS NOT NULL"})
    @NotNull
    public Set<DocumentId> getIconIds(@NotNull TenantId var1);

    @Delete(value={"DELETE FROM external_app_settings WHERE id = #{id}"})
    public void deleteById(@NotNull ExternalAppId var1);

    @Delete(value={"DELETE FROM external_app_settings WHERE tenant_id = #{tenantId}"})
    public void deleteByTenant(@NotNull TenantId var1);
}

