/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsTypeResolver;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.UserApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.graphql.dataFetchers.GranteeDataLoader;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.AppPermission;
import de.justsoftware.admin.graphql.generated.types.AppPlacement;
import de.justsoftware.admin.graphql.generated.types.Grantee;
import de.justsoftware.admin.graphql.generated.types.Profile;
import de.justsoftware.admin.graphql.generated.types.ProfileInput;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.graphql.generated.types.TenantPermission;
import de.justsoftware.admin.graphql.generated.types.UserGroup;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0017J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\b\u001a\u00020\tH\u0017J\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\b\u001a\u00020\tH\u0017J\u001c\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000f2\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/UserFetcher;", "", "applicationService", "Lde/justsoftware/admin/application/web/UserApplicationService;", "<init>", "(Lde/justsoftware/admin/application/web/UserApplicationService;)V", "createProfile", "Lde/justsoftware/admin/id/ProfileId;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "input", "Lde/justsoftware/admin/graphql/generated/types/ProfileInput;", "allTenantUsersGroup", "Lde/justsoftware/admin/graphql/generated/types/UserGroup;", "granteeForAppPermission", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/admin/graphql/generated/types/Grantee;", "granteeForTenantPermission", "granteeForAppPlacement", "resolveGrantee", "", "grantee", "admin-service"})
public class UserFetcher {
    @NotNull
    private final UserApplicationService applicationService;

    public UserFetcher(@NotNull UserApplicationService applicationService) {
        Intrinsics.checkNotNullParameter((Object)applicationService, (String)"applicationService");
        this.applicationService = applicationService;
    }

    @DgsMutation(field="createProfile")
    @NotNull
    public ProfileId createProfile(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull ProfileInput input) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.applicationService.createProfile(ModelConverterKt.toDomain$default((ProfileInput)input, (boolean)false, (int)1, null), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsData(parentType="Tenant", field="allTenantUsersGroup")
    @NotNull
    public UserGroup allTenantUsersGroup(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        TenantId tenantId = ((Tenant)dfe.getSourceOrThrow()).getId();
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.user.model.UserGroup)this.applicationService.getAllTenantUsersGroup(tenantId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsData(parentType="AppPermission", field="grantee")
    @NotNull
    public CompletableFuture<List<Grantee>> granteeForAppPermission(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(GranteeDataLoader.class);
        UserId granteeId = UserId.Companion.fromString(((AppPermission)dfe.getSourceOrThrow()).getGranteeId());
        CompletableFuture completableFuture = dataLoader.load((Object)granteeId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="TenantPermission", field="grantee")
    @NotNull
    public CompletableFuture<List<Grantee>> granteeForTenantPermission(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(GranteeDataLoader.class);
        UserId granteeId = UserId.Companion.fromString(((TenantPermission)dfe.getSourceOrThrow()).getGranteeId());
        CompletableFuture completableFuture = dataLoader.load((Object)granteeId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="AppPlacement", field="user")
    @NotNull
    public CompletableFuture<List<Grantee>> granteeForAppPlacement(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(GranteeDataLoader.class);
        UserId granteeId = UserId.Companion.fromString(((AppPlacement)dfe.getSourceOrThrow()).getUserId());
        CompletableFuture completableFuture = dataLoader.load((Object)granteeId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsTypeResolver(name="Grantee")
    @NotNull
    public String resolveGrantee(@NotNull Grantee grantee) {
        String string;
        Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
        Grantee grantee2 = grantee;
        if (grantee2 instanceof Profile) {
            string = "Profile";
        } else if (grantee2 instanceof UserGroup) {
            string = "UserGroup";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

