/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.TenantApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.graphql.dataFetchers.util.FetcherUtilsKt;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.graphql.generated.types.TenantPermission;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.model.HexColor;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\tH\u0017J\u001a\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J2\u0010\u0010\u001a\u00020\u00072\b\b\u0001\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\tH\u0017J\u001a\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/TenantFetcher;", "", "applicationService", "Lde/justsoftware/admin/application/web/TenantApplicationService;", "<init>", "(Lde/justsoftware/admin/application/web/TenantApplicationService;)V", "tenant", "Lde/justsoftware/admin/graphql/generated/types/Tenant;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "tenantInPermission", "tenants", "", "createTenant", "name", "", "updateTenant", "id", "Lde/justsoftware/admin/id/TenantId;", "color", "Lde/justsoftware/admin/model/HexColor;", "deleteTenant", "", "admin-service"})
@SourceDebugExtension(value={"SMAP\nTenantFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/TenantFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1557#2:94\n1628#2,3:95\n*S KotlinDebug\n*F\n+ 1 TenantFetcher.kt\nde/justsoftware/admin/graphql/dataFetchers/TenantFetcher\n*L\n59#1:94\n59#1:95,3\n*E\n"})
public class TenantFetcher {
    @NotNull
    private final TenantApplicationService applicationService;

    public TenantFetcher(@NotNull TenantApplicationService applicationService) {
        Intrinsics.checkNotNullParameter((Object)applicationService, (String)"applicationService");
        this.applicationService = applicationService;
    }

    @DgsQuery(field="tenant")
    @NotNull
    public Tenant tenant(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        TenantId tenantId = authContext.getNonNullTenantId();
        return FetcherUtilsKt.isIdOnlyQuery((DataFetchingEnvironment)((DataFetchingEnvironment)dfe)) ? new Tenant.Builder().withId(tenantId).build() : ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.getOne(authContext));
    }

    @DgsData(parentType="TenantPermission", field="tenant")
    @NotNull
    public Tenant tenantInPermission(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        TenantId tenantId = ((TenantPermission)dfe.getSourceOrThrow()).getTenantId();
        return FetcherUtilsKt.isIdOnlyQuery((DataFetchingEnvironment)((DataFetchingEnvironment)dfe)) ? new Tenant.Builder().withId(tenantId).build() : ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.getOne(tenantId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="tenants")
    @NotNull
    public List<Tenant> tenants(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Iterable $this$map$iv = this.applicationService.getAllTenants((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            de.justsoftware.admin.domain.tenant.model.Tenant tenant = (de.justsoftware.admin.domain.tenant.model.Tenant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)it));
        }
        return (List)destination$iv$iv;
    }

    @DgsMutation(field="createTenant")
    @NotNull
    public Tenant createTenant(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.createTenant(name, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="updateTenant")
    @NotNull
    public Tenant updateTenant(@InputArgument @NotNull TenantId id, @InputArgument @Nullable String name, @InputArgument @Nullable HexColor color, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.tenant.model.Tenant)this.applicationService.updateTenant(id, name, color, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="deleteTenant")
    public boolean deleteTenant(@InputArgument @NotNull TenantId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        this.applicationService.deleteTenant(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return true;
    }
}

