/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.appsettings;

import de.justsoftware.admin.config.ZookeeperConfig;
import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import de.justsoftware.admin.domain.appsettings.model.AppHomeScreenPosition;
import de.justsoftware.admin.domain.appsettings.model.AppPlacement;
import de.justsoftware.admin.domain.appsettings.model.AppPlacementType;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.CoreAppPlacement;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.domain.appsettings.model.ExternalAppSettings;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.id.AppId;
import de.justsoftware.admin.id.CoreAppId;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ExternalAppId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.id.UserId;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.mybatis.mapper.AppHomeScreenPositionMapper;
import de.justsoftware.admin.mybatis.mapper.AppPlacementMapper;
import de.justsoftware.admin.mybatis.mapper.CoreAppSettingsMapper;
import de.justsoftware.admin.mybatis.mapper.ExternalAppSettingsMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00132\u0006\u0010!\u001a\u00020\"H\u0016J}\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010*2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010(2\u0010\b\u0002\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0010\b\u0002\u00100\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u00101J\u0093\u0001\u00102\u001a\u00020\u001a2\u0006\u0010%\u001a\u0002032\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010(2\u000e\u00104\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010\u001c2\b\u0010+\u001a\u0004\u0018\u00010*2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010(2\b\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u0001072\b\u00109\u001a\u0004\u0018\u00010:2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010;J\u001e\u0010<\u001a\u00020\u00182\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010?\u001a\u00020 2\u0006\u0010%\u001a\u00020>H\u0016J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020$0A2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010D\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\u0006\u0010B\u001a\u00020CH\u0016J\u0010\u0010E\u001a\u00020\u001a2\u0006\u0010%\u001a\u000203H\u0016J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020 0\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\"\u0010G\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140A0H2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020$0\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00140A2\u0006\u0010L\u001a\u00020>H\u0016J\u0010\u0010M\u001a\u00020N2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010O\u001a\u00020\u00182\u0006\u0010B\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010P\u001a\u00020\u00182\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u00182\u0006\u0010B\u001a\u00020 H\u0012J1\u0010T\u001a\u00020\u00182\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010(2\u0006\u0010U\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012\u00a2\u0006\u0002\u0010VR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "", "coreAppRepo", "Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;", "appHomeScreenPositionRepo", "Lde/justsoftware/admin/mybatis/mapper/AppHomeScreenPositionMapper;", "appPlacementRepo", "Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "externalAppSettingsRepo", "Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;", "zookeeperConfig", "Lde/justsoftware/admin/config/ZookeeperConfig;", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "<init>", "(Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;Lde/justsoftware/admin/mybatis/mapper/AppHomeScreenPositionMapper;Lde/justsoftware/admin/mybatis/mapper/AppPlacementMapper;Lde/justsoftware/admin/connector/drive/DriveApiConnector;Lde/justsoftware/admin/mybatis/mapper/ExternalAppSettingsMapper;Lde/justsoftware/admin/config/ZookeeperConfig;Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;)V", "createDefaultAppPlacements", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPlacement;", "userGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "createExternalApp", "", "externalAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "placements", "", "profileId", "Lde/justsoftware/admin/id/ProfileId;", "createInitialApps", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "updateCoreApp", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "id", "Lde/justsoftware/admin/id/CoreAppId;", "active", "", "appColor", "Lde/justsoftware/admin/model/HexColor;", "homeScreenAppColor", "iconId", "Lde/justsoftware/admin/id/DocumentId;", "removeIcon", "placementAdds", "placementRemoves", "(Lde/justsoftware/admin/id/CoreAppId;Lde/justsoftware/admin/id/ProfileId;Ljava/lang/Boolean;Lde/justsoftware/admin/model/HexColor;Lde/justsoftware/admin/model/HexColor;Lde/justsoftware/admin/id/DocumentId;Ljava/lang/Boolean;Ljava/util/List;Ljava/util/List;)Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "updateExternalApp", "Lde/justsoftware/admin/id/ExternalAppId;", "clients", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$Client;", "name", "", "url", "openUrlIn", "Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$OpenUrlIn;", "(Lde/justsoftware/admin/id/ExternalAppId;Lde/justsoftware/admin/id/ProfileId;Ljava/lang/Boolean;Ljava/util/Collection;Lde/justsoftware/admin/model/HexColor;Lde/justsoftware/admin/id/DocumentId;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings$OpenUrlIn;Ljava/util/List;Ljava/util/List;)Lde/justsoftware/admin/domain/appsettings/model/ExternalAppSettings;", "saveAppPositions", "appIds", "Lde/justsoftware/admin/id/AppId;", "getApp", "getCoreAppsByApp", "", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "getCoreApp", "getExternalApp", "getAppsByTenant", "getAppsWithPlacements", "", "getCoreAppsByTenant", "getExternalApps", "getPlacements", "appId", "getLastPosition", "", "deleteExternalApp", "deleteAppPlacements", "userId", "Lde/justsoftware/admin/id/UserId;", "upsertAppPosition", "syncIconChangesWithDrive", "origin", "(Lde/justsoftware/admin/id/DocumentId;Ljava/lang/Boolean;Lde/justsoftware/admin/domain/appsettings/model/AppSettings;Lde/justsoftware/admin/id/ProfileId;)V", "admin-service"})
@SourceDebugExtension(value={"SMAP\nAppSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppSettingsService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1557#2:322\n1628#2,3:323\n1557#2:326\n1628#2,3:327\n1863#2,2:330\n1863#2,2:332\n1557#2:334\n1628#2,3:335\n1557#2:338\n1628#2,3:339\n1557#2:342\n1628#2,3:343\n1863#2,2:346\n1863#2,2:348\n1863#2,2:350\n1863#2,2:352\n1053#2:354\n1557#2:355\n1628#2,3:356\n1567#2:359\n1598#2,4:360\n1863#2,2:364\n1053#2:366\n1279#2,2:367\n1293#2,4:369\n1053#2:373\n1053#2:374\n1#3:375\n*S KotlinDebug\n*F\n+ 1 AppSettingsService.kt\nde/justsoftware/admin/domain/appsettings/AppSettingsService\n*L\n54#1:322\n54#1:323,3\n64#1:326\n64#1:327,3\n74#1:330,2\n91#1:332,2\n109#1:334\n109#1:335,3\n110#1:338\n110#1:339,3\n121#1:342\n121#1:343,3\n155#1:346,2\n156#1:348,2\n196#1:350,2\n197#1:352,2\n217#1:354\n218#1:355\n218#1:356,3\n227#1:359\n227#1:360,4\n228#1:364,2\n257#1:366\n260#1:367,2\n260#1:369,4\n267#1:373\n275#1:374\n*E\n"})
public class AppSettingsService {
    @NotNull
    private final CoreAppSettingsMapper coreAppRepo;
    @NotNull
    private final AppHomeScreenPositionMapper appHomeScreenPositionRepo;
    @NotNull
    private final AppPlacementMapper appPlacementRepo;
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final ExternalAppSettingsMapper externalAppSettingsRepo;
    @NotNull
    private final ZookeeperConfig zookeeperConfig;
    @NotNull
    private final SuperopertyConnector superopertyConnector;

    public AppSettingsService(@NotNull CoreAppSettingsMapper coreAppRepo, @NotNull AppHomeScreenPositionMapper appHomeScreenPositionRepo, @NotNull AppPlacementMapper appPlacementRepo, @NotNull DriveApiConnector driveApiConnector, @NotNull ExternalAppSettingsMapper externalAppSettingsRepo, @NotNull ZookeeperConfig zookeeperConfig, @NotNull SuperopertyConnector superopertyConnector) {
        Intrinsics.checkNotNullParameter((Object)coreAppRepo, (String)"coreAppRepo");
        Intrinsics.checkNotNullParameter((Object)appHomeScreenPositionRepo, (String)"appHomeScreenPositionRepo");
        Intrinsics.checkNotNullParameter((Object)appPlacementRepo, (String)"appPlacementRepo");
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)externalAppSettingsRepo, (String)"externalAppSettingsRepo");
        Intrinsics.checkNotNullParameter((Object)zookeeperConfig, (String)"zookeeperConfig");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        this.coreAppRepo = coreAppRepo;
        this.appHomeScreenPositionRepo = appHomeScreenPositionRepo;
        this.appPlacementRepo = appPlacementRepo;
        this.driveApiConnector = driveApiConnector;
        this.externalAppSettingsRepo = externalAppSettingsRepo;
        this.zookeeperConfig = zookeeperConfig;
        this.superopertyConnector = superopertyConnector;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppPlacement> createDefaultAppPlacements(@NotNull UserGroup userGroup) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        AppPlacementType appPlacementType;
        UserGroupId userGroupId;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        TenantId tenantId = userGroup.getTenantId();
        Iterable iterable = CoreAppPlacement.Companion.getAppsWithDefaultPlacements();
        boolean $i$f$map22 = false;
        void var6_6 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            CoreApp coreApp = (CoreApp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CoreAppId coreAppId = CoreAppId.Companion.fromAppAndTenantId((CoreApp)it, tenantId);
            userGroupId = userGroup.getId();
            appPlacementType = AppPlacementType.MANDATORY;
            collection.add(new CoreAppPlacement(coreAppId, (UserId)userGroupId, appPlacementType, tenantId));
        }
        List coreAppPlacements = (List)destination$iv$iv;
        Iterable $i$f$map22 = this.externalAppSettingsRepo.getAllByTenantId(tenantId);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExternalAppSettings bl = (ExternalAppSettings)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            userGroupId = it.getId();
            appPlacementType = userGroup.getId();
            AppPlacementType appPlacementType2 = AppPlacementType.RECOMMENDED;
            collection.add(new AppPlacement((AppId)userGroupId, (UserId)appPlacementType, appPlacementType2, tenantId));
        }
        List externalAppPlacements = (List)destination$iv$iv2;
        List placements = CollectionsKt.plus((Collection)coreAppPlacements, (Iterable)externalAppPlacements);
        Iterable $this$forEach$iv = placements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppPlacement it = (AppPlacement)element$iv;
            boolean bl = false;
            this.appPlacementRepo.upsert(it);
        }
        return placements;
    }

    public void createExternalApp(@NotNull ExternalAppSettings externalAppSettings, @NotNull Collection<? extends AppPlacement> placements, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)externalAppSettings, (String)"externalAppSettings");
        Intrinsics.checkNotNullParameter(placements, (String)"placements");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.appHomeScreenPositionRepo.upsert(new AppHomeScreenPosition((AppId)externalAppSettings.getId(), externalAppSettings.getPosition(), externalAppSettings.getTenantId()));
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)placements);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppPlacement it = (AppPlacement)element$iv;
            boolean bl = false;
            this.appPlacementRepo.upsert(it);
        }
        DocumentId documentId = externalAppSettings.getIconId();
        if (documentId != null) {
            DocumentId it = documentId;
            boolean bl = false;
            this.driveApiConnector.addFile(it, externalAppSettings.getTenantId(), profileId);
        }
        this.externalAppSettingsRepo.upsert(externalAppSettings);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AppSettings> createInitialApps(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CoreAppSettings it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$map$iv2 = (Iterable)CoreApp.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            CoreApp coreApp = (CoreApp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CoreAppSettings.Companion.withDefaults$default((CoreAppSettings.Companion)CoreAppSettings.Companion, (TenantId)tenantId, (CoreApp)it, (boolean)false, null, null, null, null, null, (int)0, (int)508, null));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (CoreAppSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            this.coreAppRepo.upsertCoreApp(it);
            this.upsertAppPosition((AppSettings)it);
            collection.add(it);
        }
        List coreApps = (List)destination$iv$iv;
        Object $i$f$map2 = new ExternalAppSettings[]{ExternalAppSettings.Companion.withDefaultsForMeetApp$default((ExternalAppSettings.Companion)ExternalAppSettings.Companion, (TenantId)tenantId, (String)this.zookeeperConfig.getHost(), (boolean)false, (int)0, (int)12, null), ExternalAppSettings.Companion.withDefaultsForSupportApp(tenantId), ExternalAppSettings.Companion.withDefaultsForWebsiteApp(tenantId)};
        $i$f$map2 = CollectionsKt.listOf((Object[])$i$f$map2);
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ExternalAppSettings bl = (ExternalAppSettings)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            this.externalAppSettingsRepo.upsert((ExternalAppSettings)it2);
            this.upsertAppPosition((AppSettings)it2);
            collection.add(it2);
        }
        List externalApps = (List)destination$iv$iv2;
        return CollectionsKt.plus((Collection)coreApps, (Iterable)externalApps);
    }

    @NotNull
    public CoreAppSettings updateCoreApp(@NotNull CoreAppId id, @NotNull ProfileId profileId, @Nullable Boolean active, @Nullable HexColor appColor, @Nullable HexColor homeScreenAppColor, @Nullable DocumentId iconId, @Nullable Boolean removeIcon, @Nullable List<? extends AppPlacement> placementAdds, @Nullable List<? extends AppPlacement> placementRemoves) {
        AppPlacement it;
        Object object;
        Object object2;
        Object object3;
        HexColor hexColor;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        CoreAppSettings origin = this.getCoreApp(id);
        Boolean bl = active;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getActive();
        HexColor hexColor2 = appColor;
        if (hexColor2 == null) {
            hexColor2 = hexColor = origin.getAppColor();
        }
        if ((object3 = homeScreenAppColor) == null) {
            object3 = object2 = origin.getHomeScreenAppColor();
        }
        if ((object = iconId) == null) {
            object = Intrinsics.areEqual((Object)removeIcon, (Object)true) ? null : origin.getIconId();
        }
        DocumentId documentId = object;
        CoreAppSettings updated = CoreAppSettings.copy$default((CoreAppSettings)origin, null, (boolean)bl2, (DocumentId)documentId, null, null, null, (HexColor)hexColor, (HexColor)object2, (int)0, (int)313, null);
        List<? extends AppPlacement> list = placementRemoves;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl3 = false;
                this.appPlacementRepo.delete(it);
            }
        }
        List<? extends AppPlacement> list2 = placementAdds;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl4 = false;
                this.appPlacementRepo.upsert(it);
            }
        }
        this.syncIconChangesWithDrive(iconId, removeIcon, (AppSettings)origin, profileId);
        this.coreAppRepo.upsertCoreApp(updated);
        return this.getCoreApp(updated.getId());
    }

    public static /* synthetic */ CoreAppSettings updateCoreApp$default(AppSettingsService appSettingsService, CoreAppId coreAppId, ProfileId profileId, Boolean bl, HexColor hexColor, HexColor hexColor2, DocumentId documentId, Boolean bl2, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateCoreApp");
        }
        if ((n & 4) != 0) {
            bl = null;
        }
        if ((n & 8) != 0) {
            hexColor = null;
        }
        if ((n & 0x10) != 0) {
            hexColor2 = null;
        }
        if ((n & 0x20) != 0) {
            documentId = null;
        }
        if ((n & 0x40) != 0) {
            bl2 = null;
        }
        if ((n & 0x80) != 0) {
            list = null;
        }
        if ((n & 0x100) != 0) {
            list2 = null;
        }
        return appSettingsService.updateCoreApp(coreAppId, profileId, bl, hexColor, hexColor2, documentId, bl2, list, list2);
    }

    @NotNull
    public ExternalAppSettings updateExternalApp(@NotNull ExternalAppId id, @NotNull ProfileId profileId, @Nullable Boolean active, @Nullable Collection<? extends ExternalAppSettings.Client> clients, @Nullable HexColor homeScreenAppColor, @Nullable DocumentId iconId, @Nullable Boolean removeIcon, @Nullable String name, @Nullable String url, @Nullable ExternalAppSettings.OpenUrlIn openUrlIn, @Nullable List<? extends AppPlacement> placementAdds, @Nullable List<? extends AppPlacement> placementRemoves) {
        AppPlacement it;
        String string;
        DocumentId documentId;
        Object object;
        Object object2;
        Object object3;
        Set set;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ExternalAppSettings origin = this.getExternalApp(id);
        Boolean bl = active;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getActive();
        Set set2 = clients;
        if (set2 == null || (set2 = CollectionsKt.toSet((Iterable)set2)) == null) {
            set2 = set = origin.getClients();
        }
        if ((object3 = homeScreenAppColor) == null) {
            object3 = object2 = origin.getHomeScreenAppColor();
        }
        if ((object = iconId) == null) {
            object = documentId = Intrinsics.areEqual((Object)removeIcon, (Object)true) ? null : origin.getIconId();
        }
        if ((string = name) == null) {
            string = origin.getName();
        }
        String string2 = string;
        String string3 = url;
        String string4 = string3 != null ? ExternalAppSettings.Companion.validateUrl(string3) : origin.getUrl();
        ExternalAppSettings.OpenUrlIn openUrlIn2 = openUrlIn;
        if (openUrlIn2 == null) {
            openUrlIn2 = origin.getOpenUrlIn();
        }
        ExternalAppSettings.OpenUrlIn openUrlIn3 = openUrlIn2;
        ExternalAppSettings updated = ExternalAppSettings.copy$default((ExternalAppSettings)origin, null, (boolean)bl2, (DocumentId)documentId, (String)string2, (ExternalAppSettings.OpenUrlIn)openUrlIn3, (String)string4, (HexColor)object2, (int)0, null, (Set)set, (int)385, null);
        List<? extends AppPlacement> list = placementRemoves;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl3 = false;
                this.appPlacementRepo.delete(it);
            }
        }
        List<? extends AppPlacement> list2 = placementAdds;
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AppPlacement)element$iv;
                boolean bl4 = false;
                this.appPlacementRepo.upsert(it);
            }
        }
        this.syncIconChangesWithDrive(iconId, removeIcon, (AppSettings)origin, profileId);
        this.externalAppSettingsRepo.upsert(updated);
        return this.getExternalApp(id);
    }

    /*
     * WARNING - void declaration
     */
    public void saveAppPositions(@NotNull List<? extends AppId> appIds, @NotNull TenantId tenantId) {
        void $this$forEach$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Set coreApps = this.coreAppRepo.getCoreAppsByTenantId(tenantId);
        Set externalApps = this.externalAppSettingsRepo.getAllByTenantId(tenantId);
        Iterable iterable = SetsKt.plus((Set)coreApps, (Iterable)externalApps);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$map22 = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppSettings appSettings = (AppSettings)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List originAppIds = (List)destination$iv$iv;
        List allAppIds = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)appIds, (Iterable)originAppIds));
        this.appHomeScreenPositionRepo.deleteAllByTenantId(tenantId);
        Iterable $i$f$map22 = allAppIds;
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void appId;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AppId appId2 = (AppId)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new AppHomeScreenPosition((AppId)appId, (int)index, tenantId));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AppHomeScreenPosition it = (AppHomeScreenPosition)element$iv;
            boolean bl = false;
            this.appHomeScreenPositionRepo.upsert(it);
        }
    }

    @NotNull
    public AppSettings getApp(@NotNull AppId id) {
        AppSettings appSettings;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        AppId appId = id;
        if (appId instanceof CoreAppId) {
            appSettings = (AppSettings)this.getCoreApp((CoreAppId)id);
        } else if (appId instanceof ExternalAppId) {
            appSettings = (AppSettings)this.getExternalApp((ExternalAppId)id);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return appSettings;
    }

    @NotNull
    public Set<CoreAppSettings> getCoreAppsByApp(@NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        return this.coreAppRepo.getCoreAppsByApp(app);
    }

    @NotNull
    public CoreAppSettings getCoreApp(@NotNull CoreAppId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CoreAppSettings coreAppSettings = this.coreAppRepo.findCoreApp(id);
        if (coreAppSettings == null) {
            throw new NotFoundException("No CoreAppSettings with id: '" + id + "' found.");
        }
        return coreAppSettings;
    }

    @NotNull
    public CoreAppSettings getCoreApp(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        CoreAppId id = CoreAppId.Companion.fromAppAndTenantId(app, tenantId);
        return this.getCoreApp(id);
    }

    @NotNull
    public ExternalAppSettings getExternalApp(@NotNull ExternalAppId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ExternalAppSettings externalAppSettings = this.externalAppSettingsRepo.findExternalAppSettings(id);
        if (externalAppSettings == null) {
            throw new NotFoundException("No ExternalAppSettings with id: '" + id + "' found.");
        }
        return externalAppSettings;
    }

    @NotNull
    public List<AppSettings> getAppsByTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)this.getCoreAppsByTenant(tenantId), (Iterable)this.getExternalApps(tenantId));
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<AppSettings, Set<AppPlacement>> getAppsWithPlacements(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$associateWith$iv = this.getAppsByTenant(tenantId);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            AppSettings appSettings = (AppSettings)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Set set = this.getPlacements(it.getId());
            map.put(t, set);
        }
        return result$iv;
    }

    @NotNull
    public List<CoreAppSettings> getCoreAppsByTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$sortedBy$iv = this.coreAppRepo.getCoreAppsByTenantId(tenantId);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public List<ExternalAppSettings> getExternalApps(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$sortedBy$iv = this.externalAppSettingsRepo.getAllByTenantId(tenantId);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Set<AppPlacement> getPlacements(@NotNull AppId appId) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        return this.appPlacementRepo.getByAppId(appId);
    }

    public int getLastPosition(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.appHomeScreenPositionRepo.getLastPosition(tenantId);
    }

    public void deleteExternalApp(@NotNull ExternalAppSettings app, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.appPlacementRepo.deleteByAppId((AppId)app.getId());
        this.externalAppSettingsRepo.deleteById(app.getId());
        this.driveApiConnector.deleteFile(app.getIconId(), profileId);
        this.saveAppPositions(CollectionsKt.emptyList(), app.getTenantId());
    }

    public void deleteAppPlacements(@NotNull UserId userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        this.appPlacementRepo.deleteByUserId(userId);
    }

    private void upsertAppPosition(AppSettings app) {
        AppHomeScreenPosition it = new AppHomeScreenPosition(app.getId(), app.getPosition(), app.getTenantId());
        boolean bl = false;
        this.appHomeScreenPositionRepo.upsert(it);
    }

    private void syncIconChangesWithDrive(DocumentId iconId, Boolean removeIcon, AppSettings origin, ProfileId profileId) {
        if (iconId != null && !Intrinsics.areEqual((Object)iconId, (Object)origin.getIconId())) {
            this.driveApiConnector.replaceFile(origin.getIconId(), iconId, origin.getTenantId(), profileId);
        } else if (Intrinsics.areEqual((Object)removeIcon, (Object)true)) {
            this.driveApiConnector.deleteFile(origin.getIconId(), profileId);
        }
    }
}

