/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.authorization;

import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.connector.permission.PermissionConnector;
import de.justsoftware.admin.id.ItemId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0010J\u0014\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u001c\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0003J\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u001cR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/admin/authorization/AuthorizationContext;", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "profileId", "Lde/justsoftware/admin/id/ProfileId;", "permissionConnector", "Lde/justsoftware/admin/connector/permission/PermissionConnector;", "<init>", "(Lde/justsoftware/admin/id/TenantId;Lde/justsoftware/admin/id/ProfileId;Lde/justsoftware/admin/connector/permission/PermissionConnector;)V", "getTenantId", "()Lde/justsoftware/admin/id/TenantId;", "getProfileId", "()Lde/justsoftware/admin/id/ProfileId;", "getNonNullTenantId", "checkRead", "", "itemId", "Lde/justsoftware/admin/id/ItemId;", "checkSuperAdmin", "checkTenantManager", "checkAllTenantReader", "granteeIds", "", "Lde/justsoftware/admin/id/UserId;", "otherTenantId", "mayRead", "", "", "isTenantManager", "isSuperAdmin", "admin-service"})
public final class AuthorizationContext {
    @Nullable
    private final TenantId tenantId;
    @NotNull
    private final ProfileId profileId;
    @NotNull
    private final PermissionConnector permissionConnector;

    public AuthorizationContext(@Nullable TenantId tenantId, @NotNull ProfileId profileId, @NotNull PermissionConnector permissionConnector) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)permissionConnector, (String)"permissionConnector");
        this.tenantId = tenantId;
        this.profileId = profileId;
        this.permissionConnector = permissionConnector;
    }

    @Nullable
    public final TenantId getTenantId() {
        return this.tenantId;
    }

    @NotNull
    public final ProfileId getProfileId() {
        return this.profileId;
    }

    @NotNull
    public final TenantId getNonNullTenantId() {
        TenantId tenantId = this.tenantId;
        if (tenantId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return tenantId;
    }

    public final void checkRead(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        this.permissionConnector.checkRead(itemId, (UserId)this.profileId);
    }

    public final void checkSuperAdmin() {
        if (!this.isSuperAdmin()) {
            throw new NotAllowedException("'" + this.profileId + "' does not have the required role for this operation!");
        }
    }

    public final void checkTenantManager() {
        if (!this.isSuperAdmin() && !this.isTenantManager()) {
            throw new NotAllowedException("'" + this.profileId + "' does not have the required role for this operation!");
        }
    }

    public final void checkAllTenantReader(@NotNull Collection<? extends UserId> granteeIds) {
        Intrinsics.checkNotNullParameter(granteeIds, (String)"granteeIds");
        if (this.tenantId == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.checkAllTenantReader(granteeIds, this.tenantId);
    }

    public final void checkAllTenantReader(@NotNull Collection<? extends UserId> granteeIds, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter(granteeIds, (String)"granteeIds");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.permissionConnector.checkAllReaders((ItemId)tenantId, granteeIds);
    }

    public final void checkTenantManager(@NotNull TenantId otherTenantId) {
        Intrinsics.checkNotNullParameter((Object)otherTenantId, (String)"otherTenantId");
        if (!this.isSuperAdmin() && !this.isTenantManager(otherTenantId)) {
            throw new NotAllowedException("'" + this.profileId + "' does not have the required role for this operation!");
        }
    }

    @NotNull
    public final Map<ItemId, Boolean> mayRead(@NotNull ItemId itemId) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return this.permissionConnector.mayRead((Collection)SetsKt.setOf((Object)itemId), (UserId)this.profileId);
    }

    public final boolean isTenantManager() {
        return this.tenantId != null && this.permissionConnector.mayManage((ItemId)this.tenantId, (UserId)this.profileId);
    }

    public final boolean isTenantManager(@NotNull TenantId otherTenantId) {
        Intrinsics.checkNotNullParameter((Object)otherTenantId, (String)"otherTenantId");
        return this.permissionConnector.mayManage((ItemId)otherTenantId, (UserId)this.profileId);
    }

    public final boolean isSuperAdmin() {
        return this.permissionConnector.isSuperAdmin((UserId)this.profileId);
    }
}

