/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.web.auth;

import de.justsoftware.admin.application.web.auth.AuthSettings;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.authorization.exceptions.NotAllowedException;
import de.justsoftware.admin.connector.auth.AuthConnector;
import de.justsoftware.admin.connector.superoperty.SuperopertyConnector;
import de.justsoftware.admin.graphql.generated.types.AuthSettingsInput;
import de.justsoftware.admin.id.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/admin/application/web/auth/AuthSettingsApplicationService;", "", "authConnector", "Lde/justsoftware/admin/connector/auth/AuthConnector;", "superopertyConnector", "Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;", "<init>", "(Lde/justsoftware/admin/connector/auth/AuthConnector;Lde/justsoftware/admin/connector/superoperty/SuperopertyConnector;)V", "getAuthSettings", "Lde/justsoftware/admin/application/web/auth/AuthSettings;", "authContext", "Lde/justsoftware/admin/authorization/AuthorizationContext;", "updateAuthSettings", "", "authSettingsInput", "Lde/justsoftware/admin/graphql/generated/types/AuthSettingsInput;", "admin-service"})
public class AuthSettingsApplicationService {
    @NotNull
    private final AuthConnector authConnector;
    @NotNull
    private final SuperopertyConnector superopertyConnector;

    public AuthSettingsApplicationService(@NotNull AuthConnector authConnector, @NotNull SuperopertyConnector superopertyConnector) {
        Intrinsics.checkNotNullParameter((Object)authConnector, (String)"authConnector");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        this.authConnector = authConnector;
        this.superopertyConnector = superopertyConnector;
    }

    @NotNull
    public AuthSettings getAuthSettings(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!this.superopertyConnector.isMFAEnabled()) {
            throw new NotAllowedException("MFA is not enabled");
        }
        TenantId tenantId = authContext.getNonNullTenantId();
        authContext.checkTenantManager(tenantId);
        return new AuthSettings(tenantId, this.authConnector.getMFAMandatory(tenantId));
    }

    public void updateAuthSettings(@NotNull AuthorizationContext authContext, @NotNull AuthSettingsInput authSettingsInput) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)authSettingsInput, (String)"authSettingsInput");
        if (!this.superopertyConnector.isMFAEnabled()) {
            throw new NotAllowedException("MFA is not enabled");
        }
        TenantId tenantId = authContext.getNonNullTenantId();
        authContext.checkTenantManager(tenantId);
        if (authSettingsInput.getMfaMandatory() != null) {
            this.authConnector.setMFAMandatory(tenantId, authSettingsInput.getMfaMandatory().booleanValue());
        }
    }
}

