/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.application.internal.controller;

import de.justsoftware.admin.application.internal.controller.InternalController;
import de.justsoftware.admin.domain.republish.RepublishService;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0011\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0013J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\b\b\u0001\u0010\f\u001a\u00020\rH\u0013J\b\u0010\u0010\u001a\u00020\u0011H\u0013J\b\u0010\u0012\u001a\u00020\u0011H\u0013J\b\u0010\u0013\u001a\u00020\u0011H\u0013J\u0014\u0010\u0014\u001a\u00020\r2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/admin/application/internal/controller/InternalController;", "", "republishService", "Lde/justsoftware/admin/domain/republish/RepublishService;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "<init>", "(Lde/justsoftware/admin/domain/republish/RepublishService;Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;)V", "getTenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenantId", "", "getTenantManagers", "", "postRepublishApps", "", "postRepublishIdpConfigs", "postRepublishTenants", "handleBadRequest", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "admin-service"})
@SourceDebugExtension(value={"SMAP\nInternalController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalController.kt\nde/justsoftware/admin/application/internal/controller/InternalController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1557#2:63\n1628#2,3:64\n*S KotlinDebug\n*F\n+ 1 InternalController.kt\nde/justsoftware/admin/application/internal/controller/InternalController\n*L\n41#1:63\n41#1:64,3\n*E\n"})
public class InternalController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RepublishService republishService;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private static final Logger log;

    public InternalController(@NotNull RepublishService republishService, @NotNull TenantService tenantService, @NotNull TenantPermissionService tenantPermissionService) {
        Intrinsics.checkNotNullParameter((Object)republishService, (String)"republishService");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        this.republishService = republishService;
        this.tenantService = tenantService;
        this.tenantPermissionService = tenantPermissionService;
    }

    @GetMapping(value={"/tenant/{tenantId}"})
    private TenantSettings getTenantSettings(@PathVariable String tenantId) {
        return this.tenantService.getSettings(TenantId.Companion.fromString(tenantId));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/tenant/manager/{tenantId}"})
    private List<String> getTenantManagers(@PathVariable String tenantId) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tenantPermissionService.findTenantManagers(TenantId.Companion.fromString(tenantId));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserId userId = (UserId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        return (List)destination$iv$iv;
    }

    @PostMapping(value={"/republish/apps"})
    @ResponseStatus(value=HttpStatus.OK)
    private void postRepublishApps() {
        this.republishService.republishAllAppConfigs();
    }

    @PostMapping(value={"/republish/idp-configs"})
    @ResponseStatus(value=HttpStatus.OK)
    private void postRepublishIdpConfigs() {
        this.republishService.republishAllIdpConfigs();
    }

    @PostMapping(value={"/republish-tenants"})
    @ResponseStatus(value=HttpStatus.OK)
    private void postRepublishTenants() {
        this.republishService.republishAllTenants();
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    private String handleBadRequest(Exception ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        String string = ex.getMessage();
        if (string == null) {
            string = "BAD REQUEST";
        }
        return string;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    static {
        Logger logger = LoggerFactory.getLogger(InternalController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

