/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.harisekhon;

import com.linkedin.harisekhon.QuitException;
import com.linkedin.harisekhon.UnsupportedOSException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class Utils {
    private static final String utils_version = "1.17.1";
    public static String msg = "";
    public static final String nagios_plugins_support_msg = "Please try latest version from https://github.com/harisekhon/nagios-plugins, re-run on command line with -vvv and if problem persists paste full output from -vvv mode in to a ticket requesting a fix/update at https://github.com/harisekhon/nagios-plugins/issues/new";
    public static final String option_format_calling_method = "%-50s %-25s %s";
    public static final String option_format = "%-25s %s";
    public static final String nagios_plugins_support_msg_api = "API may have changed. Please try latest version from https://github.com/harisekhon/nagios-plugins, re-run on command line with -vvv and if problem persists paste full output from -vvv mode in to a ticket requesting a fix/update at https://github.com/harisekhon/nagios-plugins/issues/new";
    private static final HashMap<String, Integer> exit_codes = new HashMap();
    private static String status = "UNKNOWN";
    private static final ArrayList<String> valid_units = new ArrayList<String>(Arrays.asList("%", "s", "ms", "us", "b", "kb", "mb", "gb", "tb", "c"));
    public static final Logger log = Logger.getLogger(Utils.class.getName());
    public static final String aws_access_key_regex = "(?<![A-Z0-9])[A-Z0-9]{20}(?![A-Z0-9])";
    public static final String aws_host_component = "ip-(?:10-\\d+-\\d+-\\d+|172-1[6-9]-\\d+-\\d+|172-2[0-9]-\\d+-\\d+|172-3[0-1]-\\d+-\\d+|192-168-\\d+-\\d+)";
    public static final String aws_secret_key_regex = "(?<![A-Za-z0-9/+=])[A-Za-z0-9/+=]{40}(?![A-Za-z0-9/+=])";
    public static final String ip_prefix_regex = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}";
    public static final String ip_regex = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[1-9][0-9]|[01]?0[1-9]|[12]00|[0-9])\\b";
    public static final String hostname_component_regex = "\\b[A-Za-z0-9](?:[A-Za-z0-9_\\-]{0,61}[a-zA-Z0-9])?\\b";
    public static final String domain_component = "\\b[a-zA-Z0-9](?:[a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\b";
    public static final String domain_regex;
    public static final String domain_regex_strict;
    public static final String hostname_regex;
    public static final String aws_hostname_regex;
    public static final String host_regex;
    public static final String dirname_regex = "[/\\w\\s\\\\.:,*()=%?+-]+";
    public static final String filename_regex = "[/\\w\\s\\\\.:,*()=%?+-]+[^/]";
    public static final String rwxt_regex = "[r-][w-][x-][r-][w-][x-][r-][w-][xt-]";
    public static final String fqdn_regex;
    public static final String aws_fqdn_regex;
    public static final String email_regex;
    public static final String subnet_mask_regex = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[1-9][0-9]|[01]?0[1-9]|[12]00|[0-9])\\b";
    public static final String mac_regex = "\\b[0-9A-F-af]{1,2}[:-](?:[0-9A-Fa-f]{1,2}[:-]){4}[0-9A-Fa-f]{1,2}\\b";
    public static final String process_name_regex = "\\s*[\\w./<>-][\\w\\s./<>-]+";
    public static final String url_path_suffix_regex = "/(?:[\\w.,:/%&?#!=*|\\[\\]~+-]+)?";
    public static final String user_regex = "\\b[A-Za-z][A-Za-z0-9_-]*[A-Za-z0-9]\\b";
    public static final String url_regex;
    public static final String column_regex = "\\b[\\w:]+\\b";
    public static final String ldap_dn_regex = "\\b\\w+=[\\w\\s]+(?:,\\w+=[\\w\\s]+)*\\b";
    public static final String krb5_principal_regex;
    public static final String threshold_range_regex = "^(@)?(-?\\d+(?:\\.\\d+)?)(:)(-?\\d+(?:\\.\\d+)?)?$";
    public static final String threshold_simple_regex = "^(-?\\d+(?:\\.\\d+)?)$";
    public static final String label_regex = "\\s*[\\%\\(\\)\\/\\*\\w-][\\%\\(\\)\\/\\*\\w\\s-]*";
    public static final String version_regex = "\\d(\\.\\d+)*";
    public static final String version_regex_lax = "\\d(\\.\\d+)*-?.*";
    public static HashSet<String> tlds;
    public static final String tld_regex;

    protected static final void loadTlds(String filename) throws IOException {
        int tld_count = 0;
        try {
            String line;
            InputStream resourceAsStream = Utils.class.getResourceAsStream("/" + filename);
            if (resourceAsStream == null) {
                throw new IOException(String.format("file '%s' does not exist under resources!", filename));
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(resourceAsStream));
            while ((line = br.readLine()) != null) {
                line = line.replaceFirst("[#;].*", "");
                if ((line = line.trim()).matches("^\\s*$")) continue;
                if (line.matches("^[A-Za-z0-9-]+$")) {
                    tlds.add(line);
                    ++tld_count;
                    continue;
                }
                log.warn(String.format("TLD: '%s' from tld file '%s' not validated, skipping that TLD", line, filename));
            }
            br.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            throw e;
        }
        log.debug(tld_count + " TLDs loaded from '" + filename + "'");
    }

    public static void checkTldCount() throws IllegalStateException {
        long tld_count = tlds.size();
        log.debug(String.format("%d total unique TLDs loaded from resources", tld_count));
        if (tld_count < 1000L) {
            String err_msg = String.format("%d TLDs loaded, expected >= 1000", tld_count);
            log.fatal(err_msg);
            throw new IllegalStateException(err_msg);
        }
        if (tld_count > 2000L) {
            String err_msg = String.format("%d TLDs loaded, expected <= 2000", tld_count);
            log.fatal(err_msg);
            throw new IllegalStateException(err_msg);
        }
    }

    public static final String getStatus() {
        return status;
    }

    public static final int getStatusCode() {
        return exit_codes.get(status);
    }

    public static final void setStatus(String key) {
        if (!exit_codes.containsKey(key)) {
            throw new IllegalArgumentException("invalid status '" + key + "' passed to setStatus(), must be one of: " + exit_codes.keySet().toString());
        }
        status = key;
    }

    public static final void unknown() {
        if (Utils.getStatus() == null || "OK".equalsIgnoreCase(Utils.getStatus())) {
            Utils.setStatus("UNKNOWN");
        }
    }

    public static final void warning() {
        if (Utils.getStatus() == null || !"CRITICAL".equalsIgnoreCase(Utils.getStatus())) {
            Utils.setStatus("WARNING");
        }
    }

    public static final void critical() {
        Utils.setStatus("CRITICAL");
    }

    public static final Boolean isOk() {
        return "OK".equals(Utils.getStatus());
    }

    public static final Boolean isWarning() {
        return "WARNING".equalsIgnoreCase(Utils.getStatus());
    }

    public static final Boolean isCritical() {
        return "CRITICAL".equalsIgnoreCase(Utils.getStatus());
    }

    public static final Boolean isUnknown() {
        return "UNKNOWN".equalsIgnoreCase(Utils.getStatus());
    }

    public static final int getStatusCode(String key) {
        if (key != null && exit_codes.containsKey(key)) {
            return exit_codes.get(key);
        }
        throw new IllegalArgumentException("invalid status '" + key + "' passed to getStatusCode()");
    }

    public static final void status() {
        Utils.vlog("status: " + Utils.getStatus());
    }

    public static final void status2() {
        Utils.vlog2("status: " + Utils.getStatus());
    }

    public static final void status3() {
        Utils.vlog3("status: " + Utils.getStatus());
    }

    public static final Boolean checkRegex(String string2, String regex) {
        if (string2 == null) {
            return false;
        }
        if (regex == null) {
            throw new IllegalArgumentException("undefined regex passed to checkRegex()");
        }
        if (!Utils.isRegex(regex).booleanValue()) {
            throw new IllegalArgumentException("invalid regex passed to checkRegex()");
        }
        if (string2.matches(regex)) {
            return true;
        }
        return false;
    }

    public static final Boolean checkString(String str, String expected, Boolean no_msg) {
        if (expected == null) {
            throw new IllegalArgumentException("passed null as expected string to checkString()");
        }
        if (str == null) {
            return false;
        }
        if (str.equals(expected)) {
            return true;
        }
        return false;
    }

    public static final Boolean checkString(String str, String expected) {
        return Utils.checkString(str, expected, false);
    }

    public static final double expandUnits(double num, String units, String name) {
        if (units == null) {
            throw new IllegalArgumentException("null passed for units to expandUnits()");
        }
        String name2 = Utils.name(name).trim();
        String units2 = units.trim();
        if (!name2.isEmpty()) {
            name2 = " for " + name2;
        }
        int power = 1;
        if (units2.matches("(?i)^B?$")) {
            return num;
        }
        if (units2.matches("(?i)^KB?$")) {
            power = 1;
        } else if (units2.matches("(?i)^MB?$")) {
            power = 2;
        } else if (units2.matches("(?i)^GB?$")) {
            power = 3;
        } else if (units2.matches("(?i)^TB?$")) {
            power = 4;
        } else if (units2.matches("(?i)^PB?$")) {
            power = 5;
        } else {
            throw new IllegalArgumentException(String.format("unrecognized units '%s' passed to expandUnits()%s", units2, name2));
        }
        return num * Math.pow(1024.0, power);
    }

    public static final double expandUnits(double num, String units) {
        return Utils.expandUnits(num, units, null);
    }

    public static final long expandUnits(long num, String units, String name) {
        return (long)Utils.expandUnits((double)num, units, name);
    }

    public static final long expandUnits(long num, String units) {
        return Utils.expandUnits(num, units, null);
    }

    public static final void hr() {
        log.info("# " + StringUtils.repeat("=", 76) + " #");
    }

    public static final String humanUnits(double num, String units, Boolean terse) {
        String units2 = units == null ? "" : units.trim();
        double num2 = !units2.isEmpty() ? Utils.expandUnits(num, units2, "humanUnits") : num;
        if (num2 >= Math.pow(1024.0, 7.0)) {
            throw new IllegalArgumentException(String.format("determined suspicious units for number '%s', larger than Exabytes?!!", num2));
        }
        if (num2 >= Math.pow(1024.0, 6.0)) {
            num2 /= Math.pow(1024.0, 6.0);
            units2 = "EB";
        } else if (num2 >= Math.pow(1024.0, 5.0)) {
            num2 /= Math.pow(1024.0, 5.0);
            units2 = "PB";
        } else if (num2 >= Math.pow(1024.0, 4.0)) {
            num2 /= Math.pow(1024.0, 4.0);
            units2 = "TB";
        } else if (num2 >= Math.pow(1024.0, 3.0)) {
            num2 /= Math.pow(1024.0, 3.0);
            units2 = "GB";
        } else if (num2 >= Math.pow(1024.0, 2.0)) {
            num2 /= Math.pow(1024.0, 2.0);
            units2 = "MB";
        } else if (num2 >= Math.pow(1024.0, 1.0)) {
            num2 /= Math.pow(1024.0, 1.0);
            units2 = "KB";
        } else if (num2 < 1024.0) {
            units2 = terse != false ? "B" : " bytes";
        }
        String num_str = String.format("%.2f", num2).replaceFirst("(\\.\\d+)0$", "$1").replaceFirst("\\.0+$", "");
        return num_str + units2;
    }

    public static final String humanUnits(double num, String units) {
        return Utils.humanUnits(num, units, false);
    }

    public static final String humanUnits(double num) {
        return Utils.humanUnits(num, null, false);
    }

    public static final String stripScheme(String str) {
        if (str.matches("^\\w+://[^/].*")) {
            return str.replaceFirst("^\\w+://", "");
        }
        return str.replaceFirst("^\\w+:/+", "/");
    }

    public static final String stripSchemeHost(String str) {
        if (str.matches("^\\w+:///[^/].*")) {
            return str.replaceFirst("^\\w+:///", "/");
        }
        return str.replaceFirst("^\\w+:(?://" + host_regex + "(?::\\d+)?)?/", "/");
    }

    public static final ArrayList<String> arrayToArraylist(String[] array) {
        return new ArrayList<String>(Arrays.asList(array));
    }

    public static final String[] arraylistToArray(ArrayList<String> arrayList) {
        String[] array = new String[arrayList.size()];
        return arrayList.toArray(array);
    }

    public static final String[] setToArray(Set<String> set) {
        String[] array = set.toArray(new String[set.size()]);
        return array;
    }

    public static final String[] uniqArray(String[] list2) {
        HashSet<String> set = new HashSet<String>();
        for (String item : list2) {
            set.add(item);
        }
        String[] a = new String[]{};
        return set.toArray(a);
    }

    public static final ArrayList<String> uniqArraylist(List<String> list2) {
        HashSet<String> set = new HashSet<String>(list2);
        ArrayList<String> a = new ArrayList<String>();
        a.addAll(set);
        return a;
    }

    public static final String[] uniqArrayOrdered(String[] list2) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String item : list2) {
            set.add(item);
        }
        String[] a = new String[]{};
        return set.toArray(a);
    }

    public static final ArrayList<String> uniqArraylistOrdered(ArrayList<String> list2) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(list2);
        ArrayList<String> a = new ArrayList<String>();
        a.addAll(set);
        return a;
    }

    public static final Boolean isAlNum(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("^[A-za-z0-9]+$");
    }

    public static final Boolean isAwsAccessKey(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("^(?<![A-Z0-9])[A-Z0-9]{20}(?![A-Z0-9])$");
    }

    public static final Boolean isAwsBucket(String arg) {
        return Utils.isDnsShortName(arg);
    }

    public static final Boolean isAwsHostname(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("^" + aws_hostname_regex + "$");
    }

    public static final Boolean isAwsFqdn(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("^" + aws_fqdn_regex + "$");
    }

    public static final Boolean isAwsSecretKey(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("^(?<![A-Za-z0-9/+=])[A-Za-z0-9/+=]{40}(?![A-Za-z0-9/+=])$");
    }

    public static final Boolean isChars(String str, String char_range) {
        if (str == null || char_range == null) {
            return false;
        }
        if (!Utils.isRegex(String.format("[%s]", char_range)).booleanValue()) {
            throw new IllegalArgumentException("invalid regex char range passed to isChars()");
        }
        return str.matches(String.format("^[%s]+$", char_range));
    }

    public static final Boolean isCollection(String collection) {
        if (collection == null || collection.trim().isEmpty()) {
            return false;
        }
        return collection.matches("^(\\w(?:[\\w.]*\\w)?)$");
    }

    public static final Boolean isDatabaseName(String database) {
        if (database == null || database.trim().isEmpty()) {
            return false;
        }
        return database.matches("^\\w+$");
    }

    public static final Boolean isDatabaseColumnName(String column) {
        if (column == null || column.trim().isEmpty()) {
            return false;
        }
        return column.matches("^\\b[\\w:]+\\b$");
    }

    public static final Boolean isDatabaseFieldName(String field2) {
        if (field2 == null || field2.trim().isEmpty()) {
            return false;
        }
        return field2.matches("^(?:\\d+|[\\w()*,._-]+)$");
    }

    public static final Boolean isDatabaseTableName(String table, Boolean allow_qualified) {
        if (table == null || table.trim().isEmpty()) {
            return false;
        }
        if (allow_qualified.booleanValue()) {
            return table.matches("^[A-Za-z0-9][\\w.]*[A-Za-z0-9]$");
        }
        return table.matches("^[A-Za-z0-9]\\w*[A-Za-z0-9]$");
    }

    public static final Boolean isDatabaseTableName(String table) {
        return Utils.isDatabaseTableName(table, false);
    }

    public static final Boolean isDatabaseViewName(String view, Boolean allow_qualified) {
        return Utils.isDatabaseTableName(view, allow_qualified);
    }

    public static final Boolean isDatabaseViewName(String view) {
        return Utils.isDatabaseViewName(view, false);
    }

    public static final Boolean isDirname(String dir) {
        if (dir == null || dir.trim().isEmpty()) {
            return false;
        }
        return dir.matches("^[/\\w\\s\\\\.:,*()=%?+-]+$");
    }

    public static final Boolean isDomain(String domain) {
        if (domain == null || domain.trim().isEmpty()) {
            return false;
        }
        return domain.matches("^" + domain_regex + "$");
    }

    public static final Boolean isDomainStrict(String domain) {
        if (domain == null || domain.trim().isEmpty()) {
            return false;
        }
        return domain.matches("^" + domain_regex_strict + "$");
    }

    public static final Boolean isDnsShortName(String dns) {
        if (dns == null || dns.trim().length() < 3 || dns.length() > 63) {
            return false;
        }
        return dns.matches("^\\b[A-Za-z0-9](?:[A-Za-z0-9_\\-]{0,61}[a-zA-Z0-9])?\\b$");
    }

    public static final Boolean isEmail(String email) {
        if (email == null || email.trim().isEmpty() || email.length() > 256) {
            return false;
        }
        return email.matches("^" + email_regex + "$");
    }

    public static final Boolean isFilename(String filename) {
        if (filename == null || filename.trim().isEmpty()) {
            return false;
        }
        return filename.matches("^[/\\w\\s\\\\.:,*()=%?+-]+[^/]$");
    }

    public static final Boolean isFqdn(String fqdn) {
        if (fqdn == null || fqdn.trim().isEmpty() || fqdn.length() > 255) {
            return false;
        }
        return fqdn.matches("^" + fqdn_regex + "$");
    }

    public static final Boolean isHex(String hex) {
        if (hex != null && hex.matches("^0x[A-Fa-f\\d]+$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isHost(String host) {
        if (host == null || host.trim().isEmpty()) {
            return false;
        }
        if (host.length() > 255) {
            return false;
        }
        if (Utils.isIP(host).booleanValue()) {
            return true;
        }
        if (host.matches("^" + host_regex + "$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isHostname(String hostname) {
        if (hostname != null && hostname.length() < 256 && hostname.matches("^" + hostname_regex + "$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isInterface(String networkInterface) {
        if (networkInterface != null && networkInterface.matches("^(?:em|eth|bond|lo|docker)\\d+|lo|veth[A-Fa-f0-9]+$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isKrb5Princ(String princ) {
        if (princ != null && princ.matches("^" + krb5_principal_regex + "$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isLabel(String label) {
        if (label != null && label.matches("^\\s*[\\%\\(\\)\\/\\*\\w-][\\%\\(\\)\\/\\*\\w\\s-]*$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isLdapDn(String dn) {
        if (dn != null && dn.matches("^\\b\\w+=[\\w\\s]+(?:,\\w+=[\\w\\s]+)*\\b$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isMinVersion(String version, Double min2) {
        String m1;
        double detected_version;
        if (version == null) {
            return false;
        }
        if (min2 == null) {
            return false;
        }
        if (!Utils.isVersionLax(version).booleanValue()) {
            return false;
        }
        Pattern pattern = Pattern.compile("(\\d+(?:\\.\\d+)?)");
        Matcher matcher = pattern.matcher(version);
        if (matcher.find() && (detected_version = Double.parseDouble(m1 = matcher.group(1))) >= min2) {
            return true;
        }
        return false;
    }

    public static final Boolean isNagiosUnit(String unit) {
        if (unit != null && valid_units.contains(unit.toLowerCase())) {
            return true;
        }
        return false;
    }

    public static final Boolean isNoSqlKey(String key) {
        if (key != null && key.matches("^[\\w_,.:+-]+$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isIP(String ip) {
        if (ip == null) {
            return false;
        }
        String[] octets = ip.split("\\.");
        if (octets.length != 4) {
            return false;
        }
        for (String octet : octets) {
            int octet_int;
            try {
                octet_int = Integer.parseInt(octet);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (octet_int >= 0 && octet_int <= 255) continue;
            return false;
        }
        if (ip.matches("^\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[1-9][0-9]|[01]?0[1-9]|[12]00|[0-9])\\b$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isPort(String port) {
        int port_int;
        if (port == null) {
            return false;
        }
        try {
            port_int = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (port.matches("^\\d+$")) {
            return Utils.isPort(port_int);
        }
        return false;
    }

    public static final Boolean isPort(int port_int) {
        if (port_int < 1 || port_int > 65535) {
            return false;
        }
        return true;
    }

    public static final Boolean isProcessName(String proc) {
        if (proc != null && proc.matches("^\\s*[\\w./<>-][\\w\\s./<>-]+$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isRegex(String regex) {
        if (regex == null) {
            return false;
        }
        try {
            "".matches(regex);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public static final Boolean isUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        if (url.matches("^" + url_regex + "$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isUrlPathSuffix(String url) {
        if (url != null && url.matches("^/(?:[\\w.,:/%&?#!=*|\\[\\]~+-]+)?$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isUser(String user) {
        if (user == null) {
            return false;
        }
        if (user.matches("^\\b[A-Za-z][A-Za-z0-9_-]*[A-Za-z0-9]\\b$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isVersion(String version) {
        if (version != null && version.matches("^\\d(\\.\\d+)*$")) {
            return true;
        }
        return false;
    }

    public static final Boolean isVersionLax(String version) {
        if (version != null && version.matches(version_regex_lax)) {
            return true;
        }
        return false;
    }

    public static final String getOS() {
        String os = System.getProperty("os.name");
        if (os == null) {
            throw new IllegalStateException("unknown OS, retrieved null for OS");
        }
        if (os.trim().isEmpty()) {
            throw new IllegalStateException("unknown OS, retrieved blank for OS");
        }
        return os;
    }

    public static final Boolean isOS(String os) {
        if (os != null && os.equals(Utils.getOS())) {
            return true;
        }
        return false;
    }

    public static final Boolean isMac() {
        return Utils.isOS("Mac OS X");
    }

    public static final Boolean isLinux() {
        return Utils.isOS("Linux");
    }

    public static final Boolean isLinuxOrMac() {
        return Utils.isLinux() != false || Utils.isMac() != false;
    }

    public static final void linuxOnly() throws UnsupportedOSException {
        if (!Utils.isLinux().booleanValue()) {
            throw new UnsupportedOSException("Linux");
        }
    }

    public static final void macOnly() throws UnsupportedOSException {
        if (!Utils.isMac().booleanValue()) {
            throw new UnsupportedOSException("Mac OS X");
        }
    }

    public static final void linuxMacOnly() throws UnsupportedOSException {
        if (!Utils.isLinux().booleanValue() && !Utils.isMac().booleanValue()) {
            throw new UnsupportedOSException("Linux or Mac OS X");
        }
    }

    public static final String plural(String arg) {
        if (arg == null) {
            return "";
        }
        try {
            double a = Double.valueOf(arg);
            if (a == 1.0) {
                return "";
            }
            return "s";
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    public static final String plural(double arg) {
        return Utils.plural(Double.toString(arg));
    }

    public static final String resolveIp(String host) throws UnknownHostException {
        if (host == null) {
            throw new IllegalArgumentException("no host passed to resolveIp (null)");
        }
        if (host.trim().isEmpty()) {
            throw new IllegalArgumentException("no host passed to resolveIp (blank)");
        }
        InetAddress address = InetAddress.getByName(host);
        return address.getHostAddress();
    }

    public static final Boolean userExists(String user) throws IOException, UnsupportedOSException {
        int c;
        Utils.linuxMacOnly();
        if (user == null) {
            return false;
        }
        if (user.trim().isEmpty()) {
            return false;
        }
        if (!Utils.isUser(user).booleanValue()) {
            return false;
        }
        StringBuilder id = new StringBuilder();
        Process child = Runtime.getRuntime().exec("id -u " + user);
        InputStream in = child.getInputStream();
        while ((c = in.read()) != -1) {
            id.append((char)c);
        }
        in.close();
        String id2 = id.toString();
        if (id2 != null && !id2.isEmpty()) {
            return true;
        }
        return false;
    }

    public static final void quit(String status, String message) {
        if (exit_codes.containsKey(status)) {
            throw new QuitException(status, message);
        }
        throw new IllegalArgumentException(String.format("specified an invalid exit status '%s' to quit(), message was '%s'", status, message));
    }

    public static final void quit(String message) {
        throw new QuitException("CRITICAL", message);
    }

    public static final void println(String msg) {
        System.out.println(msg);
    }

    public static final void println(double num) {
        Utils.println(String.valueOf(num));
    }

    public static final void println(long num) {
        Utils.println(String.valueOf(num));
    }

    public static final void println(Boolean b) {
        Utils.println(b.toString());
    }

    public static final String repeatString(String chars, int num) {
        StringBuilder string2 = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            string2.append(chars);
        }
        return string2.toString();
    }

    public static final String name(String name) {
        if (name == null) {
            return "";
        }
        String name2 = name.trim();
        if (!name2.isEmpty()) {
            name2 = name2 + " ";
        }
        return name2;
    }

    public static final String requireName(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name arg not defined when calling method");
        }
        return name.trim();
    }

    public static final String validateAlnum(String alnum, String name) {
        String name2 = Utils.requireName(name);
        if (alnum == null) {
            throw new IllegalArgumentException(name2 + "not defined (null)");
        }
        String alnum2 = alnum.trim();
        if (alnum2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "not defined (blank)");
        }
        if (!alnum2.matches("^[A-Za-z0-9]+$")) {
            throw new IllegalArgumentException("invalid " + name2 + " defined: must be alphanumeric");
        }
        Utils.vlogOption(name2, alnum2);
        return alnum2;
    }

    public static final String validateChars(String arg, String name, String chars) {
        String name2 = Utils.requireName(name);
        if (chars == null) {
            throw new IllegalArgumentException("chars field not defined (null) when calling validateChars()");
        }
        String chars2 = chars.trim();
        if (chars2.isEmpty()) {
            throw new IllegalArgumentException("chars field not defined (blank) when calling validateChars()");
        }
        if (arg == null || arg.trim().isEmpty()) {
            throw new IllegalArgumentException(name + "not defined");
        }
        if (!Utils.isChars(arg, chars2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + " defined: must be one of the following chars - " + chars2);
        }
        Utils.vlogOption(name2, arg);
        return arg;
    }

    public static final String validateAwsAccessKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("aws access key not defined (null)");
        }
        String key2 = key.trim();
        if (key2.isEmpty()) {
            throw new IllegalArgumentException("aws access key not defined (blank)");
        }
        if (!Utils.isAwsAccessKey(key2).booleanValue()) {
            throw new IllegalArgumentException("invalid aws access key defined: must be 20 alphanumeric chars");
        }
        Utils.vlogOption("aws access key", Utils.repeatString("X", 18) + key2.substring(18, 20));
        return key2;
    }

    public static final String validateAwsBucket(String bucket) {
        if (bucket == null) {
            throw new IllegalArgumentException("aws bucket not defined (null)");
        }
        String bucket2 = bucket.trim();
        if (bucket2.trim().isEmpty()) {
            throw new IllegalArgumentException("aws bucket not defined (blank)");
        }
        if (Utils.isIP(bucket2).booleanValue()) {
            throw new IllegalArgumentException("invalid aws bucket name defined: may not be formatted as an IP address");
        }
        if (!Utils.isDnsShortName(bucket2).booleanValue()) {
            throw new IllegalArgumentException("invalid aws bucket name defined: must be alphanumeric between 3 and 63 characters long");
        }
        Utils.vlogOption("aws bucket:", bucket2);
        return bucket2;
    }

    public static final String validateAwsHostname(String arg) {
        if (arg == null) {
            throw new IllegalArgumentException("aws hostname not defined (null)");
        }
        String arg2 = arg.trim();
        if (arg2.isEmpty()) {
            throw new IllegalArgumentException("aws hostname not defined (blank)");
        }
        if (Utils.isIP(arg2).booleanValue()) {
            throw new IllegalArgumentException("invalid aws hostname arg name defined: may not be formmatted as an IP address");
        }
        if (!Utils.isAwsHostname(arg2).booleanValue()) {
            throw new IllegalArgumentException("invalid aws hostname name defined: must be alphanumeric between 3 and 63 characters long");
        }
        Utils.vlogOption("aws hostname:", arg2);
        return arg2;
    }

    public static final String validateAwsFqdn(String arg) {
        if (arg == null) {
            throw new IllegalArgumentException("aws fqdn not defined (null)");
        }
        String arg2 = arg.trim();
        if (arg2.isEmpty()) {
            throw new IllegalArgumentException("aws fqdn not defined (blank)");
        }
        if (Utils.isIP(arg2).booleanValue()) {
            throw new IllegalArgumentException("invalid aws fqdn arg name defined: may not be formmatted as an IP address");
        }
        if (!Utils.isAwsFqdn(arg2).booleanValue()) {
            throw new IllegalArgumentException("invalid aws fqdn name defined: must be alphanumeric between 3 and 63 characters long hostname followed by domain");
        }
        Utils.vlogOption("aws fqdn:", arg2);
        return arg2;
    }

    public static final String validateAwsSecretKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("aws secret key not defined (null)");
        }
        String key2 = key.trim();
        if (key2.isEmpty()) {
            throw new IllegalArgumentException("aws secret key not defined (blank)");
        }
        if (!Utils.isAwsSecretKey(key2).booleanValue()) {
            throw new IllegalArgumentException("invalid aws secret key defined: must be 20 alphanumeric chars");
        }
        Utils.vlogOption("aws secret key", Utils.repeatString("X", 38) + key2.substring(38, 40));
        return key2;
    }

    public static final String validateCollection(String collection, String name) {
        String name2 = Utils.name(name);
        if (collection == null) {
            throw new IllegalArgumentException(name + "collection not defined (null)");
        }
        String collection2 = collection.trim();
        if (collection2.isEmpty()) {
            throw new IllegalArgumentException(name + "collection not defined (blank)");
        }
        if (!Utils.isCollection(collection2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "collection defined: must be alphanumeric, with optional periods in the middle");
        }
        Utils.vlogOption(name2 + "collection", collection2);
        return collection2;
    }

    public static final String validateCollection(String collection) {
        return Utils.validateCollection(collection, null);
    }

    public static final String validateDatabase(String database, String name) {
        String name2 = Utils.name(name);
        if (database == null) {
            throw new IllegalArgumentException(name2 + "database not defined (null)");
        }
        String database2 = database.trim();
        if (database2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "database not defined (blank)");
        }
        if (!Utils.isDatabaseName(database2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "database defined: must be alphanumeric");
        }
        Utils.vlogOption(name2 + "database", database2);
        return database2;
    }

    public static final String validateDatabase(String database) {
        return Utils.validateDatabase(database, null);
    }

    public static final String validateDatabaseColumnname(String column) {
        if (column == null) {
            throw new IllegalArgumentException("column not defined (null)");
        }
        String column2 = column.trim();
        if (column2.isEmpty()) {
            throw new IllegalArgumentException("column not defined (blank)");
        }
        if (!Utils.isDatabaseColumnName(column2).booleanValue()) {
            throw new IllegalArgumentException("invalid column defined: must be alphanumeric");
        }
        Utils.vlogOption("column", column2);
        return column2;
    }

    public static final String validateDatabaseFieldname(String field2) {
        if (field2 == null) {
            throw new IllegalArgumentException("field not defined (null)");
        }
        String field22 = field2.trim();
        if (field22.trim().isEmpty()) {
            throw new IllegalArgumentException("field not defined (blank)");
        }
        if (!Utils.isDatabaseFieldName(field22).booleanValue()) {
            throw new IllegalArgumentException("invalid field defined: must be alphanumeric");
        }
        Utils.vlogOption("field", field22);
        return field22;
    }

    public static final String validateDatabaseQuerySelectShow(String query, String name) {
        String name2 = Utils.name(name);
        if (query == null) {
            throw new IllegalArgumentException(name2 + "query not defined (null)");
        }
        String query2 = query.trim();
        if (query2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "query not defined (blank)");
        }
        if (!query2.matches("^(?i)\\s*(?:SHOW|SELECT)\\s+.+$")) {
            throw new IllegalArgumentException("invalid " + name2 + "query defined: may only be a SELECT or SHOW statement");
        }
        if (query2.matches("(?i).*\\b(?:insert|update|delete|create|drop|alter|truncate)\\b.*")) {
            throw new IllegalArgumentException("invalid " + name2 + "query defined: DML statement or suspect chars detected in query");
        }
        Utils.vlogOption(name2 + "query", query2);
        return query2;
    }

    public static final String validateDatabaseQuerySelectShow(String query) {
        return Utils.validateDatabaseQuerySelectShow(query, null);
    }

    public static final String validateDatabaseTablename(String table, String name, Boolean allow_qualified) {
        String name2 = Utils.name(name);
        if (table == null) {
            throw new IllegalArgumentException(name2 + "table not defined (null)");
        }
        String table2 = table.trim();
        if (table2.trim().isEmpty()) {
            throw new IllegalArgumentException(name2 + "table not defined (blank)");
        }
        if (!Utils.isDatabaseTableName(table2, allow_qualified).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "table defined: must be alphanumeric");
        }
        Utils.vlogOption(name2 + "table", table2);
        return table2;
    }

    public static final String validateDatabaseTablename(String table, String name) {
        return Utils.validateDatabaseTablename(table, name, false);
    }

    public static final String validateDatabaseTablename(String table, Boolean allow_qualified) {
        return Utils.validateDatabaseTablename(table, null, allow_qualified);
    }

    public static final String validateDatabaseTablename(String table) {
        return Utils.validateDatabaseTablename(table, null, false);
    }

    public static final String validateDatabaseViewname(String view, String name, Boolean allow_qualified) {
        String name2 = Utils.name(name);
        if (view == null) {
            throw new IllegalArgumentException(name2 + "view not defined (null)");
        }
        String view2 = view.trim();
        if (view2.trim().isEmpty()) {
            throw new IllegalArgumentException(name2 + "view not defined (blank)");
        }
        if (!Utils.isDatabaseViewName(view2, allow_qualified).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "view defined: must be alphanumeric");
        }
        Utils.vlogOption(name2 + "view", view2);
        return view2;
    }

    public static final String validateDatabaseViewname(String view, String name) {
        return Utils.validateDatabaseViewname(view, name, false);
    }

    public static final String validateDatabaseViewname(String view, Boolean allow_qualified) {
        return Utils.validateDatabaseViewname(view, null, allow_qualified);
    }

    public static final String validateDatabaseViewname(String view) {
        return Utils.validateDatabaseViewname(view, null, false);
    }

    public static final String validateDomain(String domain, String name) {
        String name2 = Utils.name(name);
        if (domain == null) {
            throw new IllegalArgumentException(name2 + "domain not defined (null)");
        }
        String domain2 = domain.trim();
        if (domain2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "domain not defined (blank)");
        }
        if (!Utils.isDomain(domain2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "domain name defined ('" + domain2 + "')");
        }
        Utils.vlogOption(name2 + "domain", domain2);
        return domain2;
    }

    public static final String validateDomain(String domain) {
        return Utils.validateDomain(domain, null);
    }

    public static final String validateDomainStrict(String domain, String name) {
        String name2 = Utils.name(name);
        if (domain == null) {
            throw new IllegalArgumentException(name2 + "domain not defined (null)");
        }
        String domain2 = domain.trim();
        if (domain2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "domain not defined (blank)");
        }
        if (!Utils.isDomainStrict(domain2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "domain name defined ('" + domain + "')");
        }
        Utils.vlogOption(name2 + "domain", domain2);
        return domain2;
    }

    public static final String validateDomainStrict(String domain) {
        return Utils.validateDomainStrict(domain, null);
    }

    public static final String validateDirname(String dir, String name, Boolean novlog) {
        String name2 = Utils.name(name);
        if (dir == null) {
            throw new IllegalArgumentException(name2 + "directory not defined (null)");
        }
        String dir2 = dir.trim();
        if (dir2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "directory not defined (blank)");
        }
        if (!Utils.isDirname(dir2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "directory (does not match regex criteria): '" + dir2 + "'");
        }
        if (!novlog.booleanValue()) {
            Utils.vlogOption(name2 + "directory", dir2);
        }
        return dir2;
    }

    public static final String validateDirname(String dir, String name) {
        return Utils.validateDirname(dir, name, false);
    }

    public static final String validateDirname(String dir) {
        return Utils.validateDirname(dir, null, false);
    }

    public static final String validateDirectory(String dir, String name, Boolean novlog) {
        String name2 = Utils.name(name);
        if (dir == null) {
            throw new IllegalArgumentException(name2 + "directory not defined (null)");
        }
        String dir2 = dir.trim();
        if (dir2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "directory not defined (blank)");
        }
        String dir3 = Utils.validateDirname(dir2, name2, novlog);
        File d = new File(dir3);
        if (!d.isDirectory()) {
            throw new IllegalArgumentException(String.format("directory '%s' does not exist", dir3));
        }
        return dir3;
    }

    public static final String validateDirectory(String dir, String name) {
        return Utils.validateDirectory(dir, name, false);
    }

    public static final String validateDirectory(String dir) {
        return Utils.validateDirectory(dir, null, false);
    }

    public static final String validateDir(String dir, String name, Boolean novlog) {
        return Utils.validateDirectory(dir, name, novlog);
    }

    public static final String validateDir(String dir, String name) {
        return Utils.validateDirectory(dir, name, false);
    }

    public static final String validateDir(String dir) {
        return Utils.validateDirectory(dir, null, false);
    }

    public static final String validateEmail(String email) {
        if (email == null) {
            throw new IllegalArgumentException("email not defined (null)");
        }
        String email2 = email.trim();
        if (email2.isEmpty()) {
            throw new IllegalArgumentException("email not defined (blank)");
        }
        if (!Utils.isEmail(email2).booleanValue()) {
            throw new IllegalArgumentException("invalid email address defined: failed regex validation");
        }
        Utils.vlogOption("email", email2);
        return email2;
    }

    public static final String validateFile(String filename, String name, Boolean novlog) {
        String name2 = Utils.name(name);
        Utils.validateFilename(filename, name2, novlog);
        File f = new File(filename);
        if (!f.exists() || f.isDirectory()) {
            throw new IllegalArgumentException(name2 + "file not found: " + filename);
        }
        return filename;
    }

    public static final String validateFile(String filename, String name) {
        return Utils.validateFile(filename, name, false);
    }

    public static final String validateFile(String filename) {
        return Utils.validateFile(filename, null, false);
    }

    public static final String validateFilename(String filename, String name, Boolean novlog) {
        String name2 = Utils.name(name);
        if (name2.isEmpty()) {
            name2 = "filename ";
        }
        if (filename == null) {
            throw new IllegalArgumentException(name2 + "not defined (null)");
        }
        String filename2 = filename.trim();
        if (filename2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "not defined (blank)");
        }
        if (!Utils.isFilename(filename2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "(does not match regex criteria): '" + filename2 + "'");
        }
        if (!novlog.booleanValue()) {
            Utils.vlogOption(name2.trim(), filename2);
        }
        return filename2;
    }

    public static final String validateFilename(String filename, String name) {
        return Utils.validateFilename(filename, name, false);
    }

    public static final String validateFilename(String filename) {
        return Utils.validateFilename(filename, null, false);
    }

    public static final String validateFqdn(String fqdn, String name) {
        String name2 = Utils.name(name);
        if (fqdn == null) {
            throw new IllegalArgumentException(name2 + "FQDN not defined (null)");
        }
        String fqdn2 = fqdn.trim();
        if (fqdn2.trim().isEmpty()) {
            throw new IllegalArgumentException(name2 + "FQDN not defined (blank)");
        }
        if (!Utils.isFqdn(fqdn2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "FQDN defined");
        }
        Utils.vlogOption(name2 + "fqdn", fqdn2);
        return fqdn2;
    }

    public static final String validateFqdn(String fqdn) {
        return Utils.validateFqdn(fqdn, null);
    }

    public static final String validateHost(String host, String name) {
        String name2 = Utils.name(name);
        if (host == null) {
            throw new IllegalArgumentException(name2 + "host not defined (null)");
        }
        String host2 = host.trim();
        if (host2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "host not defined (blank)");
        }
        if (!Utils.isHost(host2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "host defined: not a valid hostname or IP address");
        }
        Utils.vlogOption(name2 + "host", host2);
        return host2;
    }

    public static final String validateHost(String host) {
        return Utils.validateHost(host, null);
    }

    public static final int parsePort(String port) {
        int port_int = -1;
        try {
            port_int = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid port defined, not an integer");
        }
        if (!Utils.isPort(port).booleanValue()) {
            throw new IllegalArgumentException("invalid port defined for hosts, must be between 1 and 65535");
        }
        return port_int;
    }

    public static final String[] validateHosts(String[] hosts, int port) {
        if (!Utils.isPort(port).booleanValue()) {
            throw new IllegalArgumentException("invalid port defined, integer must be between 1 and 65535");
        }
        String[] hosts2 = Utils.uniqArrayOrdered(hosts);
        if (hosts.length < 1) {
            throw new IllegalArgumentException("hosts not defined");
        }
        Pattern p = Pattern.compile(":(\\d+)$");
        for (int i = 0; i < hosts2.length; ++i) {
            String node_port = null;
            Matcher m = p.matcher(hosts2[i]);
            if (m.find()) {
                node_port = m.group(1);
                if (!Utils.isPort(node_port).booleanValue()) {
                    throw new IllegalArgumentException("invalid port given for host " + Integer.toString(i + 1));
                }
                hosts2[i] = hosts2[i].replaceAll(":\\d+$", "");
            }
            hosts2[i] = Utils.validateHost(hosts2[i]);
            if (node_port == null) {
                node_port = Integer.toString(port);
            }
            hosts2[i] = hosts2[i] + ":" + node_port;
            Utils.vlogOption("port", node_port);
        }
        return hosts2;
    }

    public static final String[] validateHosts(String[] hosts, String port) {
        return Utils.validateHosts(hosts, Utils.parsePort(port));
    }

    public static final ArrayList<String> validateHosts(ArrayList<String> hosts, int port) {
        return Utils.arrayToArraylist(Utils.validateHosts(Utils.arraylistToArray(hosts), port));
    }

    public static final ArrayList<String> validateHosts(ArrayList<String> hosts, String port) {
        return Utils.validateHosts(hosts, Utils.parsePort(port));
    }

    public static final String validateHosts(String hosts, int port) {
        if (hosts == null) {
            throw new IllegalArgumentException("hosts not defined (null)");
        }
        if (hosts.trim().isEmpty()) {
            throw new IllegalArgumentException("hosts not defined (blank)");
        }
        Object[] hosts2 = Utils.validateHosts(hosts.split("[,\\s]+"), port);
        String final_hosts = StringUtils.join(hosts2, ",");
        return final_hosts;
    }

    public static final String validateHosts(String hosts, String port) {
        return Utils.validateHosts(hosts, Utils.parsePort(port));
    }

    public static final String validateHostPort(String hostport, String name, Boolean port_required, Boolean novlog) {
        String name2 = Utils.name(name);
        if (hostport == null) {
            throw new IllegalArgumentException(name2 + "host:port not defined (null)");
        }
        String hostport2 = hostport.trim();
        if (hostport2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "host:port not defined (blank)");
        }
        String[] host_port = hostport2.split(":");
        if (host_port.length > 2) {
            throw new IllegalArgumentException("invalid " + name2 + "host:port supplied (too many colon separated components)");
        }
        if (!Utils.isHost(host_port[0]).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "host:port '" + hostport2 + "' defined: host portion '" + host_port[0] + "' is not a valid hostname or IP address");
        }
        if (host_port.length > 1) {
            if (!Utils.isPort(host_port[1]).booleanValue()) {
                throw new IllegalArgumentException(String.format("invalid port '%s' defined for " + name2 + "host:port: must be a positive integer", host_port[1]));
            }
        } else if (port_required.booleanValue()) {
            throw new IllegalArgumentException("port is required");
        }
        if (!novlog.booleanValue()) {
            Utils.vlogOption(name2 + "hostport", hostport2);
        }
        return hostport2;
    }

    public static final String validateHostPort(String host, String name, Boolean port_required) {
        return Utils.validateHostPort(host, name, port_required, false);
    }

    public static final String validateHostPort(String host, String name) {
        return Utils.validateHostPort(host, name, false, false);
    }

    public static final String validateHostPort(String host) {
        return Utils.validateHostPort(host, null, false, false);
    }

    public static final String validateHostname(String hostname, String name) {
        String name2 = Utils.name(name);
        if (hostname == null) {
            throw new IllegalArgumentException("hostname not defined (null)");
        }
        String hostname2 = hostname.trim();
        if (hostname2.isEmpty()) {
            throw new IllegalArgumentException("hostname not defined (blank)");
        }
        if (!Utils.isHostname(hostname2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "hostname '" + hostname2 + "' defined");
        }
        Utils.vlogOption(name2 + "hostname", hostname2);
        return hostname2;
    }

    public static final String validateHostname(String hostname) {
        return Utils.validateHostname(hostname, null);
    }

    public static final double validateDouble(double d, String name, double minVal, double maxVal) {
        String name2 = Utils.requireName(name);
        if (minVal > maxVal) {
            throw new IllegalArgumentException("minVal cannot be > maxVal");
        }
        if (d < minVal) {
            throw new IllegalArgumentException("invalid " + name2 + " defined: cannot be lower than " + minVal);
        }
        if (d > maxVal) {
            throw new IllegalArgumentException("invalid " + name2 + " defined: cannot be greater than " + maxVal);
        }
        Utils.vlogOption(name2, String.valueOf(d));
        return d;
    }

    public static final long validateLong(long l, String name, long minVal, long maxVal) {
        Utils.validateDouble(l, name, (double)minVal, (double)maxVal);
        return l;
    }

    public static final int validateInt(int i, String name, int minVal, int maxVal) {
        Utils.validateDouble(i, name, (double)minVal, (double)maxVal);
        return i;
    }

    public static final float validateFloat(float f, String name, float minVal, float maxVal) {
        Utils.validateDouble(f, name, (double)minVal, (double)maxVal);
        return f;
    }

    public static final double validateDouble(String d, String name, double minVal, double maxVal) {
        String name2 = Utils.requireName(name);
        double d_double = -1.0;
        try {
            d_double = Double.parseDouble(d);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid " + name2 + " defined: must be numeric (double)");
        }
        Utils.validateDouble(d_double, name2, minVal, maxVal);
        return d_double;
    }

    public static final long validateLong(String l, String name, long minVal, long maxVal) {
        String name2 = Utils.requireName(name);
        long l_long = -1L;
        try {
            l_long = Long.parseLong(l);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid " + name2 + " defined: must be numeric (long)");
        }
        Utils.validateDouble(l_long, name2, (double)minVal, (double)maxVal);
        return l_long;
    }

    public static final int validateInt(String i, String name, int minVal, int maxVal) {
        String name2 = Utils.requireName(name);
        int i_int = -1;
        try {
            i_int = Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid " + name2 + " defined: must be numeric (int)");
        }
        Utils.validateDouble(i_int, name2, (double)minVal, (double)maxVal);
        return i_int;
    }

    public static final float validateFloat(String f, String name, float minVal, float maxVal) {
        String name2 = Utils.requireName(name);
        float f_float = -1.0f;
        try {
            f_float = Float.parseFloat(f);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid " + name2 + " defined: must be numeric (float)");
        }
        Utils.validateDouble(f_float, name2, (double)minVal, (double)maxVal);
        return f_float;
    }

    public static final String validateInterface(String networkInterface) {
        if (networkInterface == null) {
            throw new IllegalArgumentException("network interface not defined (null)");
        }
        String networkInterface2 = networkInterface.trim();
        if (networkInterface2.isEmpty()) {
            throw new IllegalArgumentException("network interface not defined (blank)");
        }
        if (!Utils.isInterface(networkInterface2).booleanValue()) {
            throw new IllegalArgumentException("invalid network interface defined: must be either eth<N>, bond<N> or lo<N>");
        }
        Utils.vlogOption("interface", networkInterface2);
        return networkInterface2;
    }

    public static final String validateIP(String ip, String name) {
        String name2 = Utils.name(name);
        if (ip == null) {
            throw new IllegalArgumentException(name2 + "IP not defined (null)");
        }
        String ip2 = ip.trim();
        if (ip2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "IP not defined (blank)");
        }
        if (!Utils.isIP(ip2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "IP defined");
        }
        Utils.vlogOption(name2 + "ip", ip2);
        return ip2;
    }

    public static final String validateIP(String ip) {
        return Utils.validateIP(ip, null);
    }

    public static final String validateKrb5Princ(String princ, String name) {
        String name2 = Utils.name(name);
        if (princ == null) {
            throw new IllegalArgumentException(name2 + "krb5 principal not defined (null)");
        }
        String princ2 = princ.trim();
        if (princ2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "krb5 principal not defined (blank)");
        }
        if (!Utils.isKrb5Princ(princ2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "krb5 principal defined");
        }
        Utils.vlogOption(name2 + "krb5 principal", princ2);
        return princ2;
    }

    public static final String validateKrb5Princ(String princ) {
        return Utils.validateKrb5Princ(princ, null);
    }

    public static final String validateKrb5Realm(String realm, String name) {
        String name2 = Utils.name(name);
        if (realm == null) {
            throw new IllegalArgumentException(name2 + "realm not defined (null)");
        }
        String realm2 = realm.trim();
        if (realm2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "realm not defined (blank)");
        }
        if (!Utils.isDomain(realm2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "realm defined");
        }
        Utils.vlogOption(name2 + "realm", realm2);
        return realm2;
    }

    public static final String validateKrb5Realm(String realm) {
        return Utils.validateKrb5Realm(realm, null);
    }

    public static final String validateLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label not defined (null)");
        }
        String label2 = label.trim();
        if (label2.isEmpty()) {
            throw new IllegalArgumentException("label not defined (blank)");
        }
        if (!Utils.isLabel(label2).booleanValue()) {
            throw new IllegalArgumentException("invalid label defined: must be an alphanumeric identifier");
        }
        Utils.vlogOption("label", label2);
        return label2;
    }

    public static final String validateLdapDn(String dn, String name) {
        String name2 = Utils.name(name);
        if (dn == null) {
            throw new IllegalArgumentException("ldap " + name2 + "dn not defined (null)");
        }
        String dn2 = dn.trim();
        if (dn2.isEmpty()) {
            throw new IllegalArgumentException("ldap " + name2 + "dn not defined (blank)");
        }
        if (!Utils.isLdapDn(dn2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "ldap dn defined");
        }
        Utils.vlogOption("ldap " + name2 + "dn", dn2);
        return dn2;
    }

    public static final String validateLdapDn(String dn) {
        return Utils.validateLdapDn(dn, null);
    }

    public static final ArrayList<String> validateNodeList(ArrayList<String> nodes) {
        ArrayList<String> final_nodes = new ArrayList<String>();
        ArrayList<String> nodes2 = Utils.uniqArraylistOrdered(nodes);
        if (nodes2.size() < 1) {
            throw new IllegalArgumentException("node(s) not defined");
        }
        for (String node : nodes2) {
            for (String node2 : node.split("[,\\s]+")) {
                if (!Utils.isHost(node2 = node2.trim()).booleanValue()) {
                    throw new IllegalArgumentException("invalid node name '" + node2 + "': must be hostname/FQDN or IP address");
                }
                final_nodes.add(node2);
            }
        }
        if (final_nodes.size() < 1) {
            throw new IllegalArgumentException("node(s) not defined (empty nodes given)");
        }
        Utils.vlogOption("node list", final_nodes.toString());
        return final_nodes;
    }

    public static final String[] validateNodeList(String[] nodes) {
        return Utils.arraylistToArray(Utils.validateNodeList(Utils.arrayToArraylist(nodes)));
    }

    public static final String validateNodeList(String nodelist) {
        if (nodelist == null) {
            throw new IllegalArgumentException("node(s) not defined (null)");
        }
        if (nodelist.trim().isEmpty()) {
            throw new IllegalArgumentException("node(s) not defined (blank)");
        }
        Object[] nodelist2 = Utils.validateNodeList(nodelist.split("[,\\s]+"));
        String final_nodes = StringUtils.join(nodelist2, ",");
        return final_nodes;
    }

    public static final ArrayList<String> validateNodePortList(ArrayList<String> nodes, String name) {
        String name2 = "";
        if (name != null) {
            name2 = name + " ";
        }
        ArrayList<String> final_nodes = new ArrayList<String>();
        ArrayList<String> nodes2 = Utils.uniqArraylistOrdered(nodes);
        if (nodes2.size() < 1) {
            throw new IllegalArgumentException(String.format("%snode(s) not defined", name2));
        }
        for (String node : nodes2) {
            for (String node2 : node.split("[,\\s]+")) {
                final_nodes.add(Utils.validateHostPort(node2));
            }
        }
        Utils.vlogOption(String.format("%snodeport list", name2), final_nodes.toString());
        return final_nodes;
    }

    public static final ArrayList<String> validateNodePortList(ArrayList<String> nodes) {
        return Utils.validateNodePortList(nodes, null);
    }

    public static final String[] validateNodePortList(String[] nodes, String name) {
        return Utils.arraylistToArray(Utils.validateNodePortList(Utils.arrayToArraylist(nodes), name));
    }

    public static final String[] validateNodePortList(String[] nodes) {
        return Utils.validateNodePortList(nodes, null);
    }

    public static final String validateNodePortList(String nodelist, String name) {
        String name2 = "";
        if (name == null) {
            name2 = name + " ";
        }
        if (nodelist == null) {
            throw new IllegalArgumentException(String.format("%snode(s) not defined (null)", name2));
        }
        if (nodelist.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("%snode(s) not defined (blank)", name2));
        }
        Object[] nodelist2 = Utils.validateNodePortList(nodelist.split("[,\\s]+"));
        String final_nodes = StringUtils.join(nodelist2, ",");
        return final_nodes;
    }

    public static final String validateNodePortList(String nodelist) {
        return Utils.validateNodePortList(nodelist, null);
    }

    public static final String validateNoSqlKey(String key, String name) {
        String name2 = Utils.name(name);
        if (key == null) {
            throw new IllegalArgumentException(name2 + "key not defined (null)");
        }
        if (key.trim().isEmpty()) {
            throw new IllegalArgumentException(name2 + "key not defined (blank)");
        }
        String key2 = key.trim();
        if (!Utils.isNoSqlKey(key2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "key defined: may only contain characters: alphanumeric, commas, colons, underscores, pluses and dashes");
        }
        Utils.vlogOption(name2 + "key", key2);
        return key2;
    }

    public static final String validateNoSqlKey(String key) {
        return Utils.validateNoSqlKey(key, null);
    }

    public static final int validatePort(int port, String name) {
        String name2 = Utils.name(name);
        if (!Utils.isPort(port).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "port defined");
        }
        Utils.vlogOption(name2 + "port", String.valueOf(port));
        return port;
    }

    public static final String validatePort(String port, String name) {
        String name2 = Utils.name(name);
        int port_int = -1;
        try {
            port_int = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid " + name2 + "port specified: must be numeric");
        }
        return String.valueOf(Utils.validatePort(port_int, name2));
    }

    public static final int validatePort(int port) {
        return Utils.validatePort(port, null);
    }

    public static final String validatePort(String port) {
        return Utils.validatePort(port, null);
    }

    public static final String validateProcessName(String process2, String name) {
        String name2 = Utils.name(name);
        if (process2 == null) {
            throw new IllegalArgumentException(name2 + "process name not defined (null)");
        }
        String process22 = process2.trim();
        if (process22.isEmpty()) {
            throw new IllegalArgumentException(name2 + "process name not defined (blank)");
        }
        if (!Utils.isProcessName(process22).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "process name defined:");
        }
        return process22;
    }

    public static final String validateProcessName(String process2) {
        return Utils.validateProcessName(process2, null);
    }

    public static final String validateProgramPath(String path, String name, String regex) {
        String regex2;
        String name2 = Utils.requireName(name).trim();
        if (path == null) {
            throw new IllegalArgumentException(name2 + " path not defined (null)");
        }
        String path2 = path.trim();
        if (path2.isEmpty()) {
            throw new IllegalArgumentException(name2 + " path not defined (blank)");
        }
        if (!path2.matches("^[./]")) {
            try {
                path2 = Utils.which(path2);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if (Utils.validateRegex(regex2 = regex == null || regex.trim().isEmpty() ? name2 : regex.trim(), "program path regex", true) == null) {
            throw new IllegalArgumentException("invalid regex given to validateProgramPath()");
        }
        Utils.validateFilename(path2, null, true);
        if (!path2.matches("(?:^|.*/)" + regex2 + "$")) {
            throw new IllegalArgumentException("invalid path given for " + name2 + ", is not a path to the " + name2 + " command");
        }
        File f = new File(path2);
        if (!f.exists() || !f.isFile()) {
            throw new IllegalArgumentException(path2 + " not found");
        }
        if (!f.canExecute()) {
            throw new IllegalArgumentException(path2 + " not executable");
        }
        Utils.vlogOption(name2 + " program path", path2);
        return path2;
    }

    public static final String validateProgramPath(String path, String name) {
        return Utils.validateProgramPath(path, name, null);
    }

    public static final String validateRegex(String regex, String name, Boolean posix) {
        String name2 = Utils.name(name);
        if (regex == null) {
            throw new IllegalArgumentException(name2 + "regex not defined (null)");
        }
        if (regex.trim().isEmpty()) {
            throw new IllegalArgumentException(name2 + "regex not defined (blank)");
        }
        if (posix.booleanValue()) {
            if (regex.matches(".*(?:\\$\\(|`).*")) {
                throw new IllegalArgumentException("invalid " + name2 + "posix regex supplied: contains sub shell metachars ( $( / ` ) that would be dangerous to pass to shell");
            }
        } else {
            try {
                "".matches(regex);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("invalid " + name2 + "regex defined");
            }
        }
        Utils.vlogOption(name2 + "regex", regex);
        return regex;
    }

    public static final String validateRegex(String regex, String name) {
        return Utils.validateRegex(regex, name, false);
    }

    public static final String validateUser(String user, String name) {
        String name2 = Utils.name(name);
        if (user == null) {
            throw new IllegalArgumentException(name2 + "user not defined (null)");
        }
        String user2 = user.trim();
        if (user2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "user not defined (blank)");
        }
        if (!Utils.isUser(user2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "username defined: must be alphanumeric");
        }
        Utils.vlogOption(name2 + "user", user2);
        return user2;
    }

    public static final String validateUser(String user) {
        return Utils.validateUser(user, null);
    }

    public static final String validateUserExists(String user, String name) throws IOException, UnsupportedOSException {
        String user2 = Utils.validateUser(user, name);
        String name2 = Utils.name(name);
        if (!Utils.userExists(user2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "user defined, not found on local system");
        }
        return user2;
    }

    public static final String validatePassword(String password, String name, Boolean allow_all) {
        String name2 = Utils.name(name);
        if (password == null) {
            throw new IllegalArgumentException(name2 + "password not defined (null)");
        }
        if (password.trim().isEmpty()) {
            throw new IllegalArgumentException(name2 + "password not defined (blank)");
        }
        if (allow_all.booleanValue()) {
            return password;
        }
        if (password.matches(".*[\"'`].*")) {
            throw new IllegalArgumentException("invalid " + name2 + "password defined: may not contain quotes or backticks");
        }
        if (password.matches(".*\\$\\(.*")) {
            throw new IllegalArgumentException("invalid " + name2 + "password defined: may not contain $( as this is a subshell escape and could be dangerous to pass through to programs, especially on the command line");
        }
        Utils.vlogOption("password", "<omitted>");
        return password;
    }

    public static final String validatePassword(String password, String name) {
        return Utils.validatePassword(password, name, false);
    }

    public static final String validatePassword(String password) {
        return Utils.validatePassword(password, null, false);
    }

    public static final String validateResolvable(String host, String name) throws UnknownHostException {
        String name2 = Utils.name(name);
        if (host == null) {
            throw new IllegalArgumentException(name2 + "host not defined (null)");
        }
        String host2 = host.trim();
        if (host2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "host not defined (blank)");
        }
        String ip = Utils.resolveIp(host2);
        return ip;
    }

    public static final String validateResolvable(String host) throws UnknownHostException {
        return Utils.validateResolvable(host, null);
    }

    public static final String validateUnits(String units, String name) {
        String name2 = Utils.name(name);
        if (units == null) {
            throw new IllegalArgumentException(name2 + "units not defined (null)");
        }
        String units2 = units.trim();
        if (units2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "units not defined (blank)");
        }
        if (!Utils.isNagiosUnit(units2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "units '" + units2 + "' defined, must be one of: " + valid_units.toString());
        }
        Utils.vlogOption(name2 + "units", units2);
        return units2;
    }

    public static final String validateUnits(String units) {
        return Utils.validateUnits(units, null);
    }

    public static final String validateUrl(String url, String name) {
        String name2 = Utils.name(name);
        if (url == null) {
            throw new IllegalArgumentException(name2 + "url not defined (null)");
        }
        String url2 = url.trim();
        if (url2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "url not defined (blank)");
        }
        if (!url2.contains("://")) {
            url2 = "http://" + url2;
        }
        if (!Utils.isUrl(url2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "url defined: '" + url2 + "'");
        }
        Utils.vlogOption(name2 + "url", url2);
        return url2;
    }

    public static final String validateUrl(String url) {
        return Utils.validateUrl(url, null);
    }

    public static final String validateUrlPathSuffix(String url, String name) {
        String name2 = Utils.name(name);
        if (url == null) {
            throw new IllegalArgumentException(name2 + "url not defined (null)");
        }
        String url2 = url.trim();
        if (url2.isEmpty()) {
            throw new IllegalArgumentException(name2 + "url not defined (blank)");
        }
        if (!Utils.isUrlPathSuffix(url2).booleanValue()) {
            throw new IllegalArgumentException("invalid " + name2 + "url defined: '" + url2 + "'");
        }
        return url2;
    }

    public static final String validateUrlPathSuffix(String url) {
        return Utils.validateUrlPathSuffix(url, null);
    }

    public static final String getVersion() {
        return utils_version;
    }

    public static final void version() {
        Utils.println("Hari Sekhon Java Utils version " + Utils.getVersion());
    }

    public static final String which(String bin) throws IOException {
        if (bin == null || bin.trim().isEmpty()) {
            throw new IllegalArgumentException("no bin passed to which()");
        }
        if (bin.matches("^(?:/|\\./).*")) {
            File f = new File(bin);
            if (f.isFile()) {
                if (f.canExecute()) {
                    return bin;
                }
                throw new IOException(String.format("'%s' is not executable!", bin));
            }
            throw new IOException(String.format("couldn't find executable '%s'", bin));
        }
        for (String path : System.getenv("PATH").split(":")) {
            String fullpath = path + "/" + bin;
            File f = new File(fullpath);
            if (!f.isFile() || !f.canExecute()) continue;
            return fullpath;
        }
        throw new IOException(String.format("couldn't find '%s' in PATH (%s)", bin, System.getenv("PATH")));
    }

    public static final String getCallingMethod() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String parent = "Could not find calling method";
        if (stackTraceElements.length > 3) {
            parent = String.valueOf(stackTraceElements[3]);
        }
        return parent.replaceFirst("com.linkedin.harisekhon.Utils.", "");
    }

    public static final void vlog(String msg) {
        log.warn(msg);
    }

    public static final void vlog2(String msg) {
        log.info(msg);
    }

    public static final void vlog3(String msg) {
        log.debug(msg);
    }

    public static final void vlogOption(String name, String value2) {
        Utils.vlog2(String.format(option_format, name + ":", value2));
    }

    public static final void vlogOption(String name, boolean value2) {
        Utils.vlogOption(name, String.valueOf(value2));
    }

    static {
        tlds = new HashSet();
        exit_codes.put("OK", 0);
        exit_codes.put("WARNING", 1);
        exit_codes.put("CRITICAL", 2);
        exit_codes.put("UNKNOWN", 3);
        exit_codes.put("DEPENDENT", 4);
        try {
            Utils.loadTlds("tlds-alpha-by-domain.txt");
            Utils.checkTldCount();
            Utils.loadTlds("custom_tlds.txt");
        }
        catch (IOException e) {
            Utils.quit("UNKNOWN", String.format("unable to load a resource file containing TLDs for generated domain/fqdn regex generation: %s", e.getMessage()));
        }
        tld_regex = "\\b(?i:" + StringUtils.join(tlds.iterator(), "|") + ")\\b";
        domain_regex = "(?:\\b[a-zA-Z0-9](?:[a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\b\\.)*" + tld_regex;
        domain_regex_strict = "(?:\\b[a-zA-Z0-9](?:[a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\b\\.)+" + tld_regex;
        hostname_regex = String.format("%s(?:\\.%s)?", hostname_component_regex, domain_regex);
        aws_hostname_regex = "ip-(?:10-\\d+-\\d+-\\d+|172-1[6-9]-\\d+-\\d+|172-2[0-9]-\\d+-\\d+|172-3[0-1]-\\d+-\\d+|192-168-\\d+-\\d+)(?:\\." + domain_regex + ")?";
        aws_fqdn_regex = "ip-(?:10-\\d+-\\d+-\\d+|172-1[6-9]-\\d+-\\d+|172-2[0-9]-\\d+-\\d+|172-3[0-1]-\\d+-\\d+|192-168-\\d+-\\d+)\\." + domain_regex;
        host_regex = String.format("\\b(?:%s|%s)\\b", hostname_regex, "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[1-9][0-9]|[01]?0[1-9]|[12]00|[0-9])\\b");
        fqdn_regex = "\\b[A-Za-z0-9](?:[A-Za-z0-9_\\-]{0,61}[a-zA-Z0-9])?\\b\\." + domain_regex;
        krb5_principal_regex = String.format("%s(?:/%s)?(?:@%s)?", user_regex, hostname_regex, domain_regex);
        email_regex = "\\b[A-Za-z0-9](?:[A-Za-z0-9\\._\\%\\'\\+-]{0,62}[A-Za-z0-9\\._\\%\\+-])?@" + domain_regex + "\\b";
        url_regex = "\\b(?i:https?://)?" + host_regex + "(?::\\d{1,5})?(?:" + url_path_suffix_regex + ")?";
    }
}

