/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.kafka;

import de.justsoftware.people.kafka.KafkaTopicCleanupService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/people/kafka/KafkaTopicCleanupService;", "Lorg/springframework/beans/factory/InitializingBean;", "bootstrapServers", "", "<init>", "(Ljava/lang/String;)V", "afterPropertiesSet", "", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nKafkaTopicCleanupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaTopicCleanupService.kt\nde/justsoftware/people/kafka/KafkaTopicCleanupService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1557#2:68\n1628#2,3:69\n1557#2:72\n1628#2,3:73\n774#2:76\n865#2:77\n1755#2,3:78\n866#2:81\n1863#2,2:82\n*S KotlinDebug\n*F\n+ 1 KafkaTopicCleanupService.kt\nde/justsoftware/people/kafka/KafkaTopicCleanupService\n*L\n38#1:68\n38#1:69,3\n39#1:72\n39#1:73,3\n40#1:76\n40#1:77\n40#1:78,3\n40#1:81\n43#1:82,2\n*E\n"})
public class KafkaTopicCleanupService
implements InitializingBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    public static final int LISTING_TIMEOUT = 10;
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTopicCleanupService.class);
    @NotNull
    private static final List<String> TOPICS_TO_CLEANUP;

    public KafkaTopicCleanupService(@Value(value="${spring.kafka.bootstrapServers}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    public void afterPropertiesSet() {
        Map config = MapsKt.mapOf((Pair)TuplesKt.to((Object)"bootstrap.servers", (Object)this.bootstrapServers));
        try {
            AutoCloseable autoCloseable = (AutoCloseable)KafkaAdminClient.create((Map)config);
            Throwable throwable = null;
            try {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                String p0;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                AdminClient adminClient = (AdminClient)autoCloseable;
                boolean bl = false;
                ListTopicsResult result = adminClient.listTopics();
                Object object = result.listings().get(10L, TimeUnit.SECONDS);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                Iterable iterable = (Iterable)object;
                boolean $i$f$map = false;
                void var9_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TopicListing topicListing = (TopicListing)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(p0.name());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void s;
                    p0 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)s);
                    void var17_26 = s;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string = var17_26.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    collection.add(string);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl4;
                    block17: {
                        String topic = (String)element$iv$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv = TOPICS_TO_CLEANUP;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String p02 = (String)element$iv;
                                boolean bl6 = false;
                                if (!StringsKt.startsWith$default((String)topic, (String)p02, (boolean)false, (int)2, null)) continue;
                                bl4 = true;
                                break block17;
                            }
                            bl4 = false;
                        }
                    }
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List topicsToDelete = (List)destination$iv$iv;
                if (!((Collection)topicsToDelete).isEmpty()) {
                    void $this$forEach$iv;
                    LOG.info("Will delete the following old topics:");
                    $this$filter$iv = topicsToDelete;
                    Logger logger = LOG;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String p03 = (String)element$iv;
                        boolean bl7 = false;
                        logger.info(p03);
                    }
                    adminClient.deleteTopics((Collection)topicsToDelete);
                    LOG.info("Topics deleted successfully");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error when trying to delete old topics", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("Error when trying to delete old topics", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.error("Error when trying to delete old topics", (Throwable)e);
        }
    }

    static {
        Object[] objectArray = new String[]{"just.people.profileprocessor-", "just.people.groups", "just.people.groups.members"};
        TOPICS_TO_CLEANUP = CollectionsKt.listOf((Object[])objectArray);
    }
}

