/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile;

import de.justsoftware.people.business.event.ProfilesCreatedEvent;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.ProfilesUpdatedEvent;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.KafkaProfileDto;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.model.Absence;
import de.justsoftware.people.model.DynamicProfileFields;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.persistence.AbsenceRepository;
import de.justsoftware.people.persistence.BirthdayReminderRepository;
import de.justsoftware.people.persistence.ProfileAttributeRepository;
import de.justsoftware.people.persistence.ProfileRepository;
import de.justsoftware.people.persistence.model.DbAbsence;
import de.justsoftware.people.persistence.model.DbBirthdayReminder;
import de.justsoftware.people.persistence.model.DbBirthdayReminderId;
import de.justsoftware.people.persistence.model.DbProfile;
import de.justsoftware.people.persistence.model.DbProfileAttribute;
import de.justsoftware.people.persistence.transaction.TransactionSupport;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.people.utils.KafkaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u0000 @2\u00020\u0001:\u0001@B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0016J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%H\u0016J!\u0010&\u001a\u00020\u001a2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020)0(H\u0011\u00a2\u0006\u0002\b*J#\u0010+\u001a\u00020\u001a2\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010,0(H\u0011\u00a2\u0006\u0002\b-J$\u0010.\u001a\u00020\u001a2\u001a\u0010/\u001a\u0016\u0012\u0004\u0012\u00020\u001c\u0012\f\u0012\n\u0012\u0004\u0012\u000200\u0018\u00010\u00170#H\u0012J\u001d\u00101\u001a\n 3*\u0004\u0018\u000102022\u0006\u00104\u001a\u000205H\u0012\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u0002082\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u00109\u001a\u0002082\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u0002082\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>H\u0016J\"\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002080#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lde/justsoftware/people/business/profile/ProfileService;", "", "profileRepository", "Lde/justsoftware/people/persistence/ProfileRepository;", "profileAttributeRepository", "Lde/justsoftware/people/persistence/ProfileAttributeRepository;", "birthdayReminderRepository", "Lde/justsoftware/people/persistence/BirthdayReminderRepository;", "absenceRepository", "Lde/justsoftware/people/persistence/AbsenceRepository;", "transactionSupport", "Lde/justsoftware/people/persistence/transaction/TransactionSupport;", "externalLinkService", "Lde/justsoftware/people/business/externallink/ExternalLinkService;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lde/justsoftware/people/persistence/ProfileRepository;Lde/justsoftware/people/persistence/ProfileAttributeRepository;Lde/justsoftware/people/persistence/BirthdayReminderRepository;Lde/justsoftware/people/persistence/AbsenceRepository;Lde/justsoftware/people/persistence/transaction/TransactionSupport;Lde/justsoftware/people/business/externallink/ExternalLinkService;Lorg/springframework/context/ApplicationEventPublisher;)V", "getProfile", "Lde/justsoftware/people/business/profile/model/Profile;", "profileSearchReadModel", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchReadModel;", "configuredLinks", "", "Lde/justsoftware/people/business/externallink/model/ExternalLinkConfig;", "saveBirthdayReminder", "", "profileId", "Lde/justsoftware/people/model/ProfileId;", "reminderProfileId", "deleteBirthdayReminder", "getBirthdayReminderProfiles", "", "profileIdsToCheck", "findUndeletedProfileByIds", "", "profileIds", "", "onProfileChanged", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/people/business/profile/model/KafkaProfileDto;", "onProfileChanged$people_api", "onProfileAttributesChanged", "Lde/justsoftware/people/model/DynamicProfileFields;", "onProfileAttributesChanged$people_api", "saveProfileAttributes", "profileAttributes", "Lde/justsoftware/people/persistence/model/DbProfileAttribute;", "getAbsenceOrDefault", "Lde/justsoftware/people/persistence/model/DbAbsence;", "kotlin.jvm.PlatformType", "id", "", "(J)Lde/justsoftware/people/persistence/model/DbAbsence;", "getAbsenceInformation", "Lde/justsoftware/people/model/Absence;", "changeAbsenceStatus", "isAbsent", "", "changeAbsenceNote", "absenceNote", "", "getAbsenceInformationForProfiles", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileService.kt\nde/justsoftware/people/business/profile/ProfileService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,225:1\n1557#2:226\n1628#2,3:227\n1368#2:230\n1454#2,5:231\n1557#2:236\n1628#2,3:237\n1368#2:240\n1454#2,2:241\n1628#2,3:244\n1456#2,3:247\n1202#2,2:250\n1230#2,4:252\n1202#2,2:256\n1230#2,4:258\n1557#2:266\n1628#2,3:267\n1557#2:270\n1628#2,3:271\n1863#2:277\n1864#2:281\n1279#2,2:283\n1293#2,2:285\n1296#2:288\n1246#2,4:291\n1202#2,2:295\n1230#2,4:297\n1246#2,4:303\n1368#2:307\n1454#2,2:308\n1557#2:310\n1628#2,3:311\n1456#2,3:314\n1187#2,2:317\n1261#2,4:319\n1279#2,2:323\n1293#2,4:325\n1557#2:329\n1628#2,3:330\n1863#2,2:333\n17#3:243\n7#3,3:274\n10#3,3:278\n13#3:282\n126#4:262\n153#4,3:263\n1#5:287\n477#6:289\n423#6:290\n462#6:301\n412#6:302\n503#6,7:335\n*S KotlinDebug\n*F\n+ 1 ProfileService.kt\nde/justsoftware/people/business/profile/ProfileService\n*L\n86#1:226\n86#1:227,3\n88#1:230\n88#1:231,5\n97#1:236\n97#1:237,3\n99#1:240\n99#1:241,2\n102#1:244,3\n99#1:247,3\n103#1:250,2\n103#1:252,4\n114#1:256,2\n114#1:258,4\n118#1:266\n118#1:267,3\n119#1:270\n119#1:271,3\n124#1:277\n124#1:281\n132#1:283,2\n132#1:285,2\n132#1:288\n136#1:291,4\n157#1:295,2\n157#1:297,4\n158#1:303,4\n208#1:307\n208#1:308,2\n208#1:310\n208#1:311,3\n208#1:314,3\n209#1:317,2\n209#1:319,4\n213#1:323,2\n213#1:325,4\n171#1:329\n171#1:330,3\n173#1:333,2\n102#1:243\n124#1:274,3\n124#1:278,3\n124#1:282\n115#1:262\n115#1:263,3\n136#1:289\n136#1:290\n158#1:301\n158#1:302\n177#1:335,7\n*E\n"})
public class ProfileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileRepository profileRepository;
    @NotNull
    private final ProfileAttributeRepository profileAttributeRepository;
    @NotNull
    private final BirthdayReminderRepository birthdayReminderRepository;
    @NotNull
    private final AbsenceRepository absenceRepository;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ExternalLinkService externalLinkService;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    public static final String PERSON_TOPIC = "just.persons";
    @NotNull
    public static final String PERSON_PROFILE_ATTRIBUTES_TOPIC = "just.persons.profileAttributes";
    @NotNull
    private static final String PROFILE_LISTENER_ID = "profileConsumer";
    @NotNull
    private static final String PROFILE_ATTRIBUTES_LISTENER_ID = "profileAttributesConsumer";
    private static final Logger LOG = LoggerFactory.getLogger(ProfileService.class);

    public ProfileService(@NotNull ProfileRepository profileRepository, @NotNull ProfileAttributeRepository profileAttributeRepository, @NotNull BirthdayReminderRepository birthdayReminderRepository, @NotNull AbsenceRepository absenceRepository, @NotNull TransactionSupport transactionSupport, @NotNull ExternalLinkService externalLinkService, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        Intrinsics.checkNotNullParameter((Object)profileAttributeRepository, (String)"profileAttributeRepository");
        Intrinsics.checkNotNullParameter((Object)birthdayReminderRepository, (String)"birthdayReminderRepository");
        Intrinsics.checkNotNullParameter((Object)absenceRepository, (String)"absenceRepository");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)externalLinkService, (String)"externalLinkService");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.profileRepository = profileRepository;
        this.profileAttributeRepository = profileAttributeRepository;
        this.birthdayReminderRepository = birthdayReminderRepository;
        this.absenceRepository = absenceRepository;
        this.transactionSupport = transactionSupport;
        this.externalLinkService = externalLinkService;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public Profile getProfile(@NotNull ProfileSearchReadModel profileSearchReadModel) {
        Intrinsics.checkNotNullParameter((Object)profileSearchReadModel, (String)"profileSearchReadModel");
        return Profile.Companion.toProfile$default((Profile.Companion)Profile.Companion, (ProfileSearchReadModel)profileSearchReadModel, null, (int)1, null);
    }

    @NotNull
    public Profile getProfile(@NotNull ProfileSearchReadModel profileSearchReadModel, @NotNull List<ExternalLinkConfig> configuredLinks) {
        Intrinsics.checkNotNullParameter((Object)profileSearchReadModel, (String)"profileSearchReadModel");
        Intrinsics.checkNotNullParameter(configuredLinks, (String)"configuredLinks");
        Map fields = profileSearchReadModel.getFields();
        if (fields.isEmpty()) {
            return Profile.Companion.toProfile$default((Profile.Companion)Profile.Companion, (ProfileSearchReadModel)profileSearchReadModel, null, (int)1, null);
        }
        List links = this.externalLinkService.getLinkFromConfigAndData(configuredLinks, fields);
        return Profile.Companion.toProfile(profileSearchReadModel, links);
    }

    public void saveBirthdayReminder(@NotNull ProfileId profileId, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        this.birthdayReminderRepository.save((Object)new DbBirthdayReminder(((Number)profileId.getId()).longValue(), ((Number)reminderProfileId.getId()).longValue()));
    }

    public void deleteBirthdayReminder(@NotNull ProfileId profileId, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        this.birthdayReminderRepository.deleteById((Object)new DbBirthdayReminderId(((Number)profileId.getId()).longValue(), ((Number)reminderProfileId.getId()).longValue()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> getBirthdayReminderProfiles(@NotNull ProfileId profileId, @NotNull Set<ProfileId> profileIdsToCheck) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(profileIdsToCheck, (String)"profileIdsToCheck");
        Iterable iterable = profileIdsToCheck;
        ProfileId.Companion companion = ProfileId.Companion;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.birthdayReminderRepository.getBirthdayReminderProfileIds(((Number)profileId.getId()).longValue(), (Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return companion.toProfileIds((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Profile> findUndeletedProfileByIds(@NotNull Iterable<ProfileId> profileIds) {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable<ProfileId> $this$map$iv = profileIds;
        boolean $i$f$map = false;
        Iterable<ProfileId> iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Number)p0.getId()).longValue());
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            List chunk = (List)element$iv$iv;
            boolean bl = false;
            Map attributes = DbProfileAttribute.Companion.toDynamicProfileFields((Iterable)this.profileAttributeRepository.findAllByProfileIdIn((Iterable)chunk));
            List profiles = this.profileRepository.findAllByDeletedIsFalseAndIdIn((Iterable)chunk);
            Iterable $this$mapToSet$iv = profiles;
            boolean $i$f$mapToSet = false;
            Iterable iterable2 = $this$mapToSet$iv;
            Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbProfile dbProfile = (DbProfile)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Object object2 = (DynamicProfileFields)attributes.get(new ProfileId(it.getId()));
                if (object2 == null || (object2 = object2.getFields()) == null) {
                    object2 = MapsKt.emptyMap();
                }
                collection.add(DbProfile.Companion.toProfile$default((DbProfile.Companion)DbProfile.Companion, (DbProfile)it, (Map)object2, null, (int)2, null));
            }
            Iterable list$iv$iv = (Set)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Profile bl = (Profile)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileConsumer", containerFactory="profileListenerFactory", topics={"just.persons"}, idIsGroup=false)
    public void onProfileChanged$people_api(@NotNull ConsumerRecords<ProfileId, KafkaProfileDto> records) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map $this$associateWith$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<Object> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$mapTo$iv$iv3;
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$map$iv3 = destination$iv$iv;
        boolean $i$f$map22 = false;
        Map capacity$iv22 = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv3.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv3.entrySet()) {
            Object element$iv$iv;
            element$iv$iv = item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            ConsumerRecord record = (ConsumerRecord)element$iv$iv.getValue();
            Object object2 = record.value();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"value(...)");
            object.add(DbProfile.Companion.toDbProfile((KafkaProfileDto)object2));
        }
        List changedProfiles = (List)destination$iv$iv2;
        $this$mapTo$iv$iv3 = changedProfiles;
        object = this.profileRepository;
        boolean $i$f$map32 = false;
        void $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            DbProfile record = (DbProfile)item$iv$iv2;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(p0.getId());
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv3));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $i$f$map22 = list;
        boolean $i$f$map = false;
        void $i$f$map32 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DbProfile item$iv$iv2 = (DbProfile)item$iv$iv;
            object = destination$iv$iv22;
            boolean bl = false;
            object.add(p0.getId());
        }
        Set knownProfiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv22));
        this.profileRepository.saveAll((Iterable)changedProfiles);
        Iterable $this$partition$iv = changedProfiles;
        boolean $i$f$partition = false;
        ArrayList<DbProfile> first$iv = new ArrayList<DbProfile>();
        Iterable second$iv = new ArrayList();
        Iterable $this$forEach$iv$iv = $this$partition$iv;
        boolean $i$f$forEach = false;
        Iterator p0 = $this$forEach$iv$iv.iterator();
        while (p0.hasNext()) {
            void p02;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = p0.next();
            boolean bl = false;
            DbProfile p03 = (DbProfile)element$iv;
            boolean $i$a$-partition-ProfileService$onProfileChanged$32 = false;
            ArrayList<DbProfile> target$iv = p03.getDeleted() ? first$iv : second$iv;
            DbProfile $i$a$-partition-ProfileService$onProfileChanged$32 = (DbProfile)element$iv;
            object = target$iv;
            boolean bl2 = false;
            ((ArrayList)object).add(p02.getId());
        }
        Pair pair = TuplesKt.to(first$iv, second$iv);
        List deletedProfiles = (List)pair.component1();
        List updatedProfiles = (List)pair.component2();
        if (!((Collection)deletedProfiles).isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesDeletedEvent((Object)this, ProfileId.Companion.toProfileIds((Iterable)deletedProfiles)));
            LOG.info("Deleted " + ((Collection)deletedProfiles).size() + " profile(s)");
        }
        second$iv = CollectionsKt.minus((Iterable)updatedProfiles, (Iterable)knownProfiles);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateWith$iv), (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            TenantId tenantId;
            DbProfile profile;
            Object v2;
            block13: {
                long target$iv = ((Number)element$iv$iv).longValue();
                collection = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Iterable iterable2 = changedProfiles;
                for (Object object3 : iterable2) {
                    void id;
                    DbProfile profile2 = (DbProfile)object3;
                    boolean bl3 = false;
                    if (!(profile2.getId() == id)) continue;
                    v2 = object3;
                    break block13;
                }
                v2 = null;
            }
            DbProfile dbProfile = profile = (DbProfile)v2;
            Intrinsics.checkNotNull((Object)dbProfile);
            if (dbProfile.getTenantId() == null) {
                tenantId = null;
            } else {
                UUID uUID = profile.getTenantId();
                Intrinsics.checkNotNull((Object)uUID);
                tenantId = new TenantId(uUID);
            }
            TenantId tenantId2 = tenantId;
            object.put(collection, tenantId2);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void entry;
            Object object3;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv4;
            boolean bl4 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = new ProfileId(((Number)entry.getKey()).longValue());
            Object object4 = object;
            boolean bl5 = false;
            Object v = it$iv$iv.getValue();
            object4.put(object3, v);
        }
        Map newProfilesAndTenant = destination$iv$iv4;
        if (!newProfilesAndTenant.isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesCreatedEvent((Object)this, newProfilesAndTenant));
            LOG.info("Added " + newProfilesAndTenant.size() + " profile(s)");
        }
        if (!((Collection)updatedProfiles).isEmpty()) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesUpdatedEvent((Object)this, ProfileId.Companion.toProfileIds((Iterable)updatedProfiles)));
            LOG.info("Updated " + ((Collection)updatedProfiles).size() + " profile(s)");
        }
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileAttributesConsumer", containerFactory="profileAttributesListenerFactory", topics={"just.persons.profileAttributes"}, idIsGroup=false)
    public void onProfileAttributesChanged$people_api(@NotNull ConsumerRecords<ProfileId, DynamicProfileFields> records) {
        void $this$mapValuesTo$iv$iv;
        Map map;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put((ProfileId)p0.key(), element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        Map capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            List list;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map2;
            boolean bl3 = false;
            ProfileId profileId = (ProfileId)entry.getKey();
            ConsumerRecord records2 = (ConsumerRecord)entry.getValue();
            DynamicProfileFields dynamicProfileFields = (DynamicProfileFields)records2.value();
            if (dynamicProfileFields != null) {
                Intrinsics.checkNotNull((Object)profileId);
                list = DbProfileAttribute.Companion.toDbProfileAttributes(dynamicProfileFields, profileId);
            } else {
                list = null;
            }
            List list2 = list;
            map.put(k, list2);
        }
        Map attributeChanges = destination$iv$iv2;
        this.saveProfileAttributes(attributeChanges);
        LOG.info("Updated profile attributes of " + attributeChanges.size() + " profiles");
    }

    private void saveProfileAttributes(Map<ProfileId, ? extends List<DbProfileAttribute>> profileAttributes) {
        if (profileAttributes.isEmpty()) {
            return;
        }
        this.transactionSupport.doInTransaction(() -> ProfileService.saveProfileAttributes$lambda$19(profileAttributes, this));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ProfilesUpdatedEvent((Object)this, profileAttributes.keySet()));
    }

    private DbAbsence getAbsenceOrDefault(long id) {
        return this.absenceRepository.findAbsenceByProfileId(id).orElse(new DbAbsence(id, true, ""));
    }

    @NotNull
    public Absence getAbsenceInformation(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        DbAbsence dbAbsence = this.getAbsenceOrDefault(((Number)profileId.getId()).longValue());
        Intrinsics.checkNotNullExpressionValue((Object)dbAbsence, (String)"getAbsenceOrDefault(...)");
        return DbAbsence.Companion.toAbsence(dbAbsence);
    }

    @NotNull
    public Absence changeAbsenceStatus(@NotNull ProfileId profileId, boolean isAbsent) {
        DbAbsence dbAbsence;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        DbAbsence $this$changeAbsenceStatus_u24lambda_u2420 = dbAbsence = this.getAbsenceOrDefault(((Number)profileId.getId()).longValue());
        boolean bl = false;
        $this$changeAbsenceStatus_u24lambda_u2420.setAbsent(isAbsent);
        DbAbsence absenceToUpdate = dbAbsence;
        Object object = this.absenceRepository.save((Object)absenceToUpdate);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return DbAbsence.Companion.toAbsence((DbAbsence)object);
    }

    @NotNull
    public Absence changeAbsenceNote(@NotNull ProfileId profileId, @NotNull String absenceNote) {
        DbAbsence dbAbsence;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)absenceNote, (String)"absenceNote");
        DbAbsence $this$changeAbsenceNote_u24lambda_u2421 = dbAbsence = this.getAbsenceOrDefault(((Number)profileId.getId()).longValue());
        boolean bl = false;
        $this$changeAbsenceNote_u24lambda_u2421.setAbsenceNote(((Object)StringsKt.trim((CharSequence)absenceNote)).toString());
        DbAbsence absenceToUpdate = dbAbsence;
        Object object = this.absenceRepository.save((Object)absenceToUpdate);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return DbAbsence.Companion.toAbsence((DbAbsence)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Absence> getAbsenceInformationForProfiles(@NotNull Set<ProfileId> profileIds) {
        void $this$associateWith$iv;
        void $this$associateTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)profileIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = it;
            AbsenceRepository absenceRepository = this.absenceRepository;
            boolean $i$f$map = false;
            void var15_22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                ProfileId profileId = (ProfileId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(((Number)p0.getId()).longValue());
            }
            Iterable list$iv$iv = absenceRepository.findAbsenceByProfileIdIn((Collection)((List)destination$iv$iv2));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv3;
            DbAbsence it = (DbAbsence)element$iv$iv;
            boolean bl3 = false;
            it = TuplesKt.to((Object)new ProfileId(it.getProfileId()), (Object)DbAbsence.Companion.toAbsence(it));
            bl.put(it.getFirst(), it.getSecond());
        }
        Map dbResult = destination$iv$iv3;
        Set missingProfileIds = SetsKt.minus(profileIds, (Iterable)dbResult.keySet());
        Iterable $i$f$associate22 = missingProfileIds;
        Map map = dbResult;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            ProfileId bl = (ProfileId)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl4 = false;
            Absence absence = new Absence(true, "");
            map2.put(t, absence);
        }
        return MapsKt.plus((Map)map, (Map)result$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveProfileAttributes$lambda$19(Map $profileAttributes, ProfileService this$0) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$profileAttributes, (String)"$profileAttributes");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$map$iv = $profileAttributes.keySet();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ProfileAttributeRepository $i$f$map22 = this$0.profileAttributeRepository;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean bl = false;
            $i$f$map22.deleteByProfileIdIn(p0);
        }
        Map $this$filterValues$iv = CollectionUtilsKt.filterNotNullValues((Map)$profileAttributes);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List p0 = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(!((Collection)p0).isEmpty())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        List toSave = CollectionsKt.flatten((Iterable)((Map)result$iv).values());
        if (!((Collection)toSave).isEmpty()) {
            this$0.profileAttributeRepository.saveAll((Iterable)toSave);
        }
    }
}

