/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.people.application.SearchApplicationService;
import de.justsoftware.people.application.model.FacetFilterModel;
import de.justsoftware.people.application.model.ProfileCsvInputStream;
import de.justsoftware.people.application.model.ProfileSearchResult;
import de.justsoftware.people.application.model.SearchFilterModel;
import de.justsoftware.people.application.utils.JustCsvUtils;
import de.justsoftware.people.application.utils.PagedResults;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.authorization.models.StaticAction;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.profile.ProfileAttributeTranslationService;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.BirthdayProfile;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.SearchService;
import de.justsoftware.people.business.search.model.FacetFilter;
import de.justsoftware.people.business.search.model.SearchField;
import de.justsoftware.people.business.search.model.SearchFilter;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.business.search.solr.model.SearchModel;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.UserGroup;
import de.justsoftware.people.exceptions.NotFoundException;
import de.justsoftware.people.model.AbstractId;
import de.justsoftware.people.model.PagedResult;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 B2\u00020\u0001:\u0001BB1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJZ\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J.\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J@\u0010$\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010(\u001a\u00020\u0014H\u0016J\u001e\u0010)\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00142\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0016H\u0012J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u0016H\u0012J(\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u00192\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020201H\u0012J$\u00103\u001a\u0002022\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u000202012\u0006\u00105\u001a\u00020\u0014H\u0012J6\u00106\u001a\b\u0012\u0004\u0012\u0002070\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016JD\u00108\u001a\b\u0012\u0004\u0012\u0002070\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00142\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00140:2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0018\u0010;\u001a\u00020<2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>H\u0016J\u001e\u0010?\u001a\b\u0012\u0004\u0012\u00020@0:2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>H\u0016J\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020+0\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lde/justsoftware/people/application/SearchApplicationService;", "", "searchService", "Lde/justsoftware/people/business/search/SearchService;", "profileService", "Lde/justsoftware/people/business/profile/ProfileService;", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "externalLinkService", "Lde/justsoftware/people/business/externallink/ExternalLinkService;", "profileAttributeTranslationService", "Lde/justsoftware/people/business/profile/ProfileAttributeTranslationService;", "<init>", "(Lde/justsoftware/people/business/search/SearchService;Lde/justsoftware/people/business/profile/ProfileService;Lde/justsoftware/people/business/usergroup/UserGroupService;Lde/justsoftware/people/business/externallink/ExternalLinkService;Lde/justsoftware/people/business/profile/ProfileAttributeTranslationService;)V", "allProfiles", "Lde/justsoftware/people/model/PagedResult;", "Lde/justsoftware/people/application/model/ProfileSearchResult;", "authCtx", "Lde/justsoftware/people/authorization/AuthorizationContext;", "searchString", "", "searchFilterModel", "", "Lde/justsoftware/people/application/model/SearchFilterModel;", "facetFilterModel", "Lde/justsoftware/people/application/model/FacetFilterModel;", "contextGroupId", "Lde/justsoftware/people/model/UserGroupId;", "groupId", "offset", "", "limit", "getBirthdayList", "Lde/justsoftware/people/business/profile/model/BirthdayProfile;", "currentDate", "Ljava/time/LocalDate;", "exportProfiles", "Lde/justsoftware/people/application/model/ProfileCsvInputStream;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "locale", "getTranslatedHeaderRow", "profileAttributeConfigs", "Lde/justsoftware/people/business/profile/model/ProfileAttributeConfig;", "getAttributeConfigList", "getValidFacetContains", "Lde/justsoftware/people/business/search/model/FacetFilter;", "facetFilter", "searchableFields", "", "Lde/justsoftware/people/business/search/model/SearchField;", "getValidSearchableField", "searchFields", "searchFieldId", "allProfilesAndUserGroups", "Lde/justsoftware/people/business/search/solr/model/SearchModel;", "searchInNames", "types", "", "getProfile", "Lde/justsoftware/people/business/profile/model/Profile;", "profileId", "Lde/justsoftware/people/model/ProfileId;", "getProfileGroups", "Lde/justsoftware/people/business/usergroup/model/UserGroup;", "getSearchConfiguration", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nSearchApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchApplicationService.kt\nde/justsoftware/people/application/SearchApplicationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1557#2:347\n1628#2,3:348\n1628#2,3:352\n1557#2:355\n1628#2,3:356\n1557#2:359\n1628#2,3:360\n1557#2:363\n1628#2,3:364\n1557#2:367\n1628#2,3:368\n1863#2,2:371\n774#2:373\n865#2,2:374\n1557#2:376\n1628#2,3:377\n1611#2,9:380\n1863#2:389\n1864#2:391\n1620#2:392\n774#2:393\n865#2,2:394\n17#3:351\n1#4:390\n*S KotlinDebug\n*F\n+ 1 SearchApplicationService.kt\nde/justsoftware/people/application/SearchApplicationService\n*L\n75#1:347\n75#1:348,3\n137#1:352,3\n164#1:355\n164#1:356,3\n203#1:359\n203#1:360,3\n204#1:363\n204#1:364,3\n205#1:367\n205#1:368,3\n205#1:371,2\n217#1:373\n217#1:374,2\n316#1:376\n316#1:377,3\n317#1:380,9\n317#1:389\n317#1:391\n317#1:392\n327#1:393\n327#1:394,2\n137#1:351\n317#1:390\n*E\n"})
public class SearchApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchService searchService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final ExternalLinkService externalLinkService;
    @NotNull
    private final ProfileAttributeTranslationService profileAttributeTranslationService;
    private static final int EXPORT_PAGE_LIMIT = 200;

    @Autowired
    public SearchApplicationService(@NotNull SearchService searchService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull ExternalLinkService externalLinkService, @NotNull ProfileAttributeTranslationService profileAttributeTranslationService) {
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)externalLinkService, (String)"externalLinkService");
        Intrinsics.checkNotNullParameter((Object)profileAttributeTranslationService, (String)"profileAttributeTranslationService");
        this.searchService = searchService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.externalLinkService = externalLinkService;
        this.profileAttributeTranslationService = profileAttributeTranslationService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<ProfileSearchResult> allProfiles(@NotNull AuthorizationContext authCtx, @NotNull String searchString, @NotNull List<? extends SearchFilterModel> searchFilterModel, @Nullable FacetFilterModel facetFilterModel, @Nullable UserGroupId contextGroupId, @Nullable UserGroupId groupId, int offset, int limit) {
        PagedResult pagedResult;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchFilterModel, (String)"searchFilterModel");
        if (groupId != null) {
            authCtx.check(StaticAction.READ, (AbstractId)groupId);
        } else {
            authCtx.check(Role.read((String)authCtx.getTenantId().asString()));
        }
        ImmutableMap immutableMap = Maps.uniqueIndex((Iterable)this.searchService.getSearchableFields(), arg_0 -> SearchApplicationService.allProfiles$lambda$0((Function1)allProfiles.searchableFields.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"uniqueIndex(...)");
        ImmutableMap searchableFields2 = immutableMap;
        Iterable $this$map$iv = searchFilterModel;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void filter;
            SearchFilterModel searchFilterModel2 = (SearchFilterModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map map = (Map)searchableFields2;
            String string = filter.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            collection.add(new SearchFilter(this.getValidSearchableField(map, string), filter.getValues()));
        }
        List searchFilter = (List)destination$iv$iv;
        FacetFilter facetFilter = this.getValidFacetContains(facetFilterModel, (Map)searchableFields2);
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        List configuredLinks = this.externalLinkService.getConfiguredLinks(tenantId);
        if (groupId != null && ((CharSequence)searchString).length() == 0 && searchFilter.isEmpty() && facetFilter == null) {
            pagedResult = this.searchService.profilesInUserGroup(groupId, offset, limit, authCtx.may(Role.manage((String)authCtx.getTenantId().toString())));
        } else {
            TenantId tenantId2 = authCtx.getTenantId();
            ImmutableSet immutableSet = authCtx.searchRoles();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
            pagedResult = this.searchService.allProfiles(tenantId2, searchString, searchFilter, (Set)immutableSet, facetFilter, groupId, offset, limit);
        }
        PagedResult profiles = pagedResult;
        PagedResult pagedResult2 = PagedResults.map((PagedResult)profiles, arg_0 -> SearchApplicationService.allProfiles$lambda$2(this, configuredLinks, contextGroupId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pagedResult2, (String)"map(...)");
        return pagedResult2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PagedResult<BirthdayProfile> getBirthdayList(@NotNull AuthorizationContext authCtx, @NotNull LocalDate currentDate, int offset, int limit) {
        Collection<ProfileId> collection;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        ImmutableSet immutableSet = authCtx.searchRoles();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        PagedResult birthdayList = this.searchService.birthdayList(tenantId, currentDate, (Set)immutableSet, offset, limit);
        ProfileId profileId = authCtx.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        Iterable iterable = birthdayList.getRows();
        ProfileId profileId2 = profileId;
        ProfileService profileService = this.profileService;
        boolean $i$f$mapToSet = false;
        void var9_10 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProfileSearchReadModel profileSearchReadModel = (ProfileSearchReadModel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        collection = (Set)destination$iv$iv;
        Set activeReminderProfileIds = profileService.getBirthdayReminderProfiles(profileId2, (Set)collection);
        return birthdayList.mapNotNull(arg_0 -> SearchApplicationService.getBirthdayList$lambda$4(activeReminderProfileIds, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProfileCsvInputStream exportProfiles(@NotNull AuthorizationContext authCtx, @NotNull TenantId tenantId, @NotNull String searchString, @NotNull List<? extends SearchFilterModel> searchFilterModel, @Nullable UserGroupId groupId, @NotNull String locale) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchFilterModel, (String)"searchFilterModel");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        authCtx.check(Role.exportApp((CoreApp)CoreApp.PEOPLE, (UUID)((UUID)tenantId.getId())));
        List profileAttributeConfigs = this.getAttributeConfigList();
        String translatedHeaderRow = this.getTranslatedHeaderRow(locale, profileAttributeConfigs);
        ImmutableMap immutableMap = Maps.uniqueIndex((Iterable)this.searchService.getSearchableFields(), arg_0 -> SearchApplicationService.exportProfiles$lambda$5((Function1)exportProfiles.searchableFields.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"uniqueIndex(...)");
        ImmutableMap searchableFields2 = immutableMap;
        Iterable $this$map$iv = searchFilterModel;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void filter;
            SearchFilterModel searchFilterModel2 = (SearchFilterModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map map = (Map)searchableFields2;
            String string = filter.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            collection.add(new SearchFilter(this.getValidSearchableField(map, string), filter.getValues()));
        }
        List searchFilter = (List)destination$iv$iv;
        List configuredLinks = this.externalLinkService.getConfiguredLinks(tenantId);
        return new ProfileCsvInputStream(translatedHeaderRow, arg_0 -> SearchApplicationService.exportProfiles$lambda$8(this, tenantId, searchString, searchFilter, authCtx, groupId, configuredLinks, arg_0), profileAttributeConfigs, 200L);
    }

    /*
     * WARNING - void declaration
     */
    private String getTranslatedHeaderRow(String locale, List<? extends ProfileAttributeConfig> profileAttributeConfigs) {
        void $this$forEach$iv;
        String attributeName;
        String obj;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        ImmutableMap immutableMap = this.profileAttributeTranslationService.getTranslatedAttributes(locale);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"getTranslatedAttributes(...)");
        ImmutableMap translatedAttributes = immutableMap;
        List result = new ArrayList();
        Iterable $this$map$iv = profileAttributeConfigs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProfileAttributeConfig profileAttributeConfig = (ProfileAttributeConfig)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            obj = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)translatedAttributes.getOrDefault((Object)attributeName, (Object)attributeName));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void s;
            attributeName = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JustCsvUtils.csvEscape((String)s));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String e = (String)element$iv;
            boolean bl = false;
            result.add(e);
        }
        String string = String.join((CharSequence)";", result);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private List<ProfileAttributeConfig> getAttributeConfigList() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        ArrayList<ProfileAttributeConfig> configList = new ArrayList<ProfileAttributeConfig>();
        configList.add(ProfileAttributeConfig.TITLE);
        configList.add(ProfileAttributeConfig.FIRST_NAME);
        configList.add(ProfileAttributeConfig.LAST_NAME);
        configList.add(ProfileAttributeConfig.ADDITIONAL_TITLE);
        configList.add(ProfileAttributeConfig.ACTIVE);
        Iterable iterable = this.searchService.getSearchConfiguration();
        ArrayList<ProfileAttributeConfig> arrayList = configList;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProfileAttributeConfig attributeConfig = (ProfileAttributeConfig)element$iv$iv;
            boolean bl = false;
            if (!(attributeConfig.isVisibleOnBadge() && configList.stream().noneMatch(arg_0 -> SearchApplicationService.getAttributeConfigList$lambda$15$lambda$14(arg_0 -> SearchApplicationService.getAttributeConfigList$lambda$15$lambda$13(attributeConfig, arg_0), arg_0)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        arrayList.addAll((List)destination$iv$iv);
        return configList;
    }

    private FacetFilter getValidFacetContains(FacetFilterModel facetFilter, Map<String, SearchField> searchableFields2) {
        if (facetFilter == null) {
            return null;
        }
        String string = facetFilter.getSearchFieldId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchFieldId(...)");
        SearchField facetFilterField = this.getValidSearchableField(searchableFields2, string);
        if (!this.searchService.getSearchConfiguration(facetFilterField).filter(arg_0 -> SearchApplicationService.getValidFacetContains$lambda$17(SearchApplicationService::getValidFacetContains$lambda$16, arg_0)).filter(arg_0 -> SearchApplicationService.getValidFacetContains$lambda$19(SearchApplicationService::getValidFacetContains$lambda$18, arg_0)).isPresent()) {
            boolean bl = false;
            String string2 = "Invalid facet filter id " + facetFilter.getSearchFieldId();
            throw new IllegalArgumentException(string2.toString());
        }
        return new FacetFilter(facetFilterField, facetFilter.getValue());
    }

    private SearchField getValidSearchableField(Map<String, SearchField> searchFields, String searchFieldId) {
        SearchField searchField = searchFields.get(searchFieldId);
        if (searchField == null) {
            throw new IllegalArgumentException("Invalid search field id: " + searchFieldId);
        }
        return searchField;
    }

    @NotNull
    public PagedResult<SearchModel> allProfilesAndUserGroups(@NotNull AuthorizationContext authCtx, @NotNull TenantId tenantId, @NotNull String searchString, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        authCtx.check(Role.read((String)tenantId.asString()));
        ImmutableSet immutableSet = authCtx.searchRoles();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        ImmutableSet searchRoles = immutableSet;
        return this.searchService.allProfilesAndUserGroups(tenantId, searchString, (Set)searchRoles, offset, limit);
    }

    @NotNull
    public PagedResult<SearchModel> searchInNames(@NotNull AuthorizationContext authCtx, @NotNull TenantId tenantId, @NotNull String searchString, @NotNull Set<String> types, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        authCtx.check(Role.read((String)tenantId.asString()));
        ImmutableSet immutableSet = authCtx.searchRoles();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        ImmutableSet searchRoles = immutableSet;
        return this.searchService.searchInNames(tenantId, searchString, (Set)searchRoles, types, offset, limit);
    }

    @NotNull
    public Profile getProfile(@NotNull AuthorizationContext authCtx, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ImmutableSet immutableSet = authCtx.searchRoles();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        ProfileSearchReadModel profileSearchReadModel = this.searchService.findProfile(profileId, (Set)immutableSet);
        if (profileSearchReadModel == null) {
            throw new NotFoundException("Profile not found", profileId.asString());
        }
        ProfileSearchReadModel profile = profileSearchReadModel;
        return this.profileService.getProfile(profile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<UserGroup> getProfileGroups(@NotNull AuthorizationContext authCtx, @NotNull ProfileId profileId) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ImmutableSet immutableSet = authCtx.searchRoles();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        ProfileSearchReadModel profileSearchReadModel = this.searchService.findProfile(profileId, (Set)immutableSet);
        if (profileSearchReadModel == null) {
            throw new NotFoundException("Profile not found", profileId.asString());
        }
        ProfileSearchReadModel profile = profileSearchReadModel;
        Iterable $this$map$iv = profile.getUserGroupIds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.read((String)it.asString()));
        }
        List roles = (List)destination$iv$iv;
        ImmutableSet immutableSet2 = authCtx.filterRoles((Iterable)roles);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet2, (String)"filterRoles(...)");
        Iterable $this$mapNotNull$iv = (Iterable)immutableSet2;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            UserGroupId userGroupId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            Role it = (Role)element$iv$iv;
            boolean bl3 = false;
            try {
                String id;
                String role;
                Intrinsics.checkNotNullExpressionValue((Object)it.toString(), (String)"toString(...)");
                Intrinsics.checkNotNullExpressionValue((Object)role.substring(StringsKt.indexOf$default((CharSequence)role, (char)'@', (int)0, (boolean)false, (int)6, null) + 1), (String)"substring(...)");
                userGroupId = UserGroupId.Companion.parse(id);
            }
            catch (IllegalArgumentException ex) {
                userGroupId = null;
            }
            if (userGroupId == null) continue;
            UserGroupId it$iv$iv = userGroupId;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set groups = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        $this$mapNotNull$iv = this.userGroupService.getUserGroups(groups).values();
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UserGroup it = (UserGroup)element$iv$iv;
            boolean bl5 = false;
            if (!(!it.isAllTenantUsers())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    @NotNull
    public List<ProfileAttributeConfig> getSearchConfiguration(@NotNull AuthorizationContext authCtx, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        authCtx.check(Role.read((String)tenantId.asString()));
        return this.searchService.getSearchConfiguration();
    }

    private static final String allProfiles$lambda$0(Function1 $tmp0, Object input) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(input);
    }

    private static final ProfileSearchResult allProfiles$lambda$2(SearchApplicationService this$0, List $configuredLinks, UserGroupId $contextGroupId, ProfileSearchReadModel p) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$configuredLinks, (String)"$configuredLinks");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return new ProfileSearchResult(this$0.profileService.getProfile(p, $configuredLinks), CollectionsKt.contains((Iterable)p.getUserGroupIds(), (Object)$contextGroupId));
    }

    private static final BirthdayProfile getBirthdayList$lambda$4(Set $activeReminderProfileIds, ProfileSearchReadModel it) {
        Intrinsics.checkNotNullParameter((Object)$activeReminderProfileIds, (String)"$activeReminderProfileIds");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BirthdayProfile.Companion.toBirthdayProfile(it, $activeReminderProfileIds);
    }

    private static final String exportProfiles$lambda$5(Function1 $tmp0, Object input) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(input);
    }

    private static final Profile exportProfiles$lambda$8$lambda$7(SearchApplicationService this$0, List $configuredLinks, ProfileSearchReadModel p) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$configuredLinks, (String)"$configuredLinks");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this$0.profileService.getProfile(p, $configuredLinks);
    }

    private static final PagedResult exportProfiles$lambda$8(SearchApplicationService this$0, TenantId $tenantId, String $searchString, List $searchFilter, AuthorizationContext $authCtx, UserGroupId $groupId, List $configuredLinks, int offset) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tenantId, (String)"$tenantId");
        Intrinsics.checkNotNullParameter((Object)$searchString, (String)"$searchString");
        Intrinsics.checkNotNullParameter((Object)$searchFilter, (String)"$searchFilter");
        Intrinsics.checkNotNullParameter((Object)$authCtx, (String)"$authCtx");
        Intrinsics.checkNotNullParameter((Object)$configuredLinks, (String)"$configuredLinks");
        SearchService searchService = this$0.searchService;
        ImmutableSet immutableSet = $authCtx.searchRoles();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"searchRoles(...)");
        return PagedResults.map((PagedResult)searchService.allProfiles($tenantId, $searchString, $searchFilter, (Set)immutableSet, null, $groupId, offset, 200), arg_0 -> SearchApplicationService.exportProfiles$lambda$8$lambda$7(this$0, $configuredLinks, arg_0));
    }

    private static final boolean getAttributeConfigList$lambda$15$lambda$13(ProfileAttributeConfig $attributeConfig, ProfileAttributeConfig config) {
        Intrinsics.checkNotNullParameter((Object)$attributeConfig, (String)"$attributeConfig");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return Intrinsics.areEqual((Object)config.getName(), (Object)$attributeConfig.getName());
    }

    private static final boolean getAttributeConfigList$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getValidFacetContains$lambda$16(ProfileAttributeConfig obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.isFacetable();
    }

    private static final boolean getValidFacetContains$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getValidFacetContains$lambda$18(ProfileAttributeConfig obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.isSearchInFacetsSupported();
    }

    private static final boolean getValidFacetContains$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

