/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.controller;

import de.justsoftware.notificationservice.business.MobilePushNotificationService;
import de.justsoftware.notificationservice.business.NotificationService;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal/notification"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u000e\b\u0001\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/notificationservice/controller/InternalNotificationController;", "", "notificationService", "Lde/justsoftware/notificationservice/business/NotificationService;", "mobilePushNotificationService", "Lde/justsoftware/notificationservice/business/MobilePushNotificationService;", "(Lde/justsoftware/notificationservice/business/NotificationService;Lde/justsoftware/notificationservice/business/MobilePushNotificationService;)V", "getOpenNotificationCounts", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "", "profileIds", "", "sendLogoutPushNotifications", "", "notification-service"})
public class InternalNotificationController {
    @NotNull
    private final NotificationService notificationService;
    @NotNull
    private final MobilePushNotificationService mobilePushNotificationService;

    public InternalNotificationController(@NotNull NotificationService notificationService, @NotNull MobilePushNotificationService mobilePushNotificationService) {
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        Intrinsics.checkNotNullParameter((Object)mobilePushNotificationService, (String)"mobilePushNotificationService");
        this.notificationService = notificationService;
        this.mobilePushNotificationService = mobilePushNotificationService;
    }

    @PostMapping(value={"/open"})
    @NotNull
    public Map<ProfileId, Integer> getOpenNotificationCounts(@RequestBody @NotNull List<? extends ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return this.notificationService.getNotificationCounts((Collection)profileIds, NotificationStatus.OPEN);
    }

    @PostMapping(value={"/mobilepush/send/logout"})
    @NotNull
    public String sendLogoutPushNotifications() {
        int numberOfPushNotifications = this.mobilePushNotificationService.sendLogoutPushNotifications();
        return "Successfully queued " + numberOfPushNotifications + " push notifications.";
    }
}

