/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import de.justsoftware.notificationservice.persistence.UserGroupMemberRepository;
import de.justsoftware.notificationservice.persistence.model.DbUserGroupMember;
import de.justsoftware.notificationservice.util.RepositoryUtilKt;
import jakarta.persistence.EntityManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/notificationservice/business/UserGroupMemberService;", "", "userGroupMemberRepository", "Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;", "entityManager", "Ljakarta/persistence/EntityManager;", "(Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;Ljakarta/persistence/EntityManager;)V", "getUserGroupMembershipChecksum", "", "updateMembers", "", "membersToSave", "", "Lde/justsoftware/notificationservice/persistence/model/DbUserGroupMember;", "membersToDelete", "notification-service"})
public class UserGroupMemberService {
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final EntityManager entityManager;

    public UserGroupMemberService(@NotNull UserGroupMemberRepository userGroupMemberRepository, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.entityManager = entityManager;
    }

    @Transactional
    public void updateMembers(@NotNull List<? extends DbUserGroupMember> membersToSave, @NotNull List<? extends DbUserGroupMember> membersToDelete) {
        Intrinsics.checkNotNullParameter(membersToSave, (String)"membersToSave");
        Intrinsics.checkNotNullParameter(membersToDelete, (String)"membersToDelete");
        this.userGroupMemberRepository.saveAll((Iterable)membersToSave);
        this.userGroupMemberRepository.deleteAll((Iterable)membersToDelete);
    }

    @NotNull
    public String getUserGroupMembershipChecksum() {
        if (RepositoryUtilKt.isPostgres((EntityManager)this.entityManager)) {
            String string = this.userGroupMemberRepository.getUserGroupMembershipChecksumPostgres();
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }
}

