/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.prosemirror;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.justsoftware.wikiservice.business.exceptions.DuplicateArticleHeadingIdException;
import de.justsoftware.wikiservice.business.exceptions.MissingArticleHeadingIdException;
import de.justsoftware.wikiservice.prosemirror.ArticleHeadingInfo;
import de.justsoftware.wikiservice.prosemirror.ProseMirrorContentParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a:\u0010\n\u001a\u00020\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00030\u000f\u001a\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u001c\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u0005\u001a<\u0010\u0016\u001a\u00020\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00030\u000fH\u0002\u001a\\\u0010\u0017\u001a\u00020\u00032\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00030\u000f2\u001e\u0010\u0018\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00110\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "verifyAllHeadingsHaveUniqueIds", "", "articleContent", "", "addIdsToHeadings", "getHeadings", "", "Lde/justsoftware/wikiservice/prosemirror/ArticleHeadingInfo;", "forEachHeading", "json", "", "", "fn", "Lkotlin/Function1;", "isHeadingTag", "", "isMediaTag", "driveMediaIdsFromPMContent", "", "input", "forEachMediaId", "forEachElement", "predicate", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nProseMirrorContentParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProseMirrorContentParser.kt\nde/justsoftware/wikiservice/prosemirror/ProseMirrorContentParserKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1#2:131\n216#3:132\n217#3:135\n1863#4,2:133\n1557#4:136\n1628#4,3:137\n2669#4,7:140\n*S KotlinDebug\n*F\n+ 1 ProseMirrorContentParser.kt\nde/justsoftware/wikiservice/prosemirror/ProseMirrorContentParserKt\n*L\n121#1:132\n121#1:135\n123#1:133,2\n50#1:136\n50#1:137,3\n61#1:140,7\n*E\n"})
public final class ProseMirrorContentParserKt {
    @NotNull
    private static final ObjectMapper mapper;

    public static final void verifyAllHeadingsHaveUniqueIds(@NotNull String articleContent) throws MissingArticleHeadingIdException {
        Intrinsics.checkNotNullParameter((Object)articleContent, (String)"articleContent");
        Object object = mapper.readValue(articleContent, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map json = (Map)object;
        List headingIds = new ArrayList();
        ProseMirrorContentParserKt.forEachHeading((Map)json, arg_0 -> ProseMirrorContentParserKt.verifyAllHeadingsHaveUniqueIds$lambda$1(headingIds, arg_0));
    }

    @NotNull
    public static final String addIdsToHeadings(@NotNull String articleContent) {
        Intrinsics.checkNotNullParameter((Object)articleContent, (String)"articleContent");
        Object object = mapper.readValue(articleContent, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map json = (Map)object;
        ProseMirrorContentParserKt.forEachHeading((Map)json, ProseMirrorContentParserKt::addIdsToHeadings$lambda$2);
        String string = mapper.writeValueAsString((Object)json);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    @NotNull
    public static final List<ArticleHeadingInfo> getHeadings(@NotNull String articleContent) {
        Intrinsics.checkNotNullParameter((Object)articleContent, (String)"articleContent");
        Object object = mapper.readValue(articleContent, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map json = (Map)object;
        List headings = new ArrayList();
        Ref.IntRef i = new Ref.IntRef();
        ProseMirrorContentParserKt.forEachHeading((Map)json, arg_0 -> ProseMirrorContentParserKt.getHeadings$lambda$5(headings, i, arg_0));
        return headings;
    }

    public static final void forEachHeading(@NotNull Map<String, ? extends Object> json, @NotNull Function1<? super Map<String, ? extends Object>, Unit> fn) {
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        ProseMirrorContentParserKt.forEachElement(json, fn, (Function1)((Function1)forEachHeading.1.INSTANCE));
    }

    private static final boolean isHeadingTag(Map<String, ? extends Object> json) {
        Object it = json.get("type");
        boolean bl = false;
        return Intrinsics.areEqual((Object)it, (Object)"heading");
    }

    private static final boolean isMediaTag(Map<String, ? extends Object> json) {
        Object it = json.get("type");
        boolean bl = false;
        return Intrinsics.areEqual((Object)it, (Object)"image") || Intrinsics.areEqual((Object)it, (Object)"video");
    }

    @NotNull
    public static final Set<String> driveMediaIdsFromPMContent(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Object object = mapper.readValue(input, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map json = (Map)object;
        Set id = new LinkedHashSet();
        ProseMirrorContentParserKt.forEachMediaId((Map)json, arg_0 -> ProseMirrorContentParserKt.driveMediaIdsFromPMContent$lambda$8(id, arg_0));
        return CollectionsKt.toSet((Iterable)id);
    }

    private static final void forEachMediaId(Map<String, ? extends Object> json, Function1<? super Map<String, ? extends Object>, Unit> fn) {
        ProseMirrorContentParserKt.forEachElement(json, fn, (Function1)((Function1)forEachMediaId.1.INSTANCE));
    }

    private static final void forEachElement(Map<String, ? extends Object> json, Function1<? super Map<String, ? extends Object>, Unit> fn, Function1<? super Map<String, ? extends Object>, Boolean> predicate) {
        if (json.isEmpty()) {
            return;
        }
        Object[] objectArray = new Map[]{json};
        List elementsToCheck = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)elementsToCheck).isEmpty()) {
            Map el = (Map)elementsToCheck.remove(0);
            if (((Boolean)predicate.invoke((Object)el)).booleanValue()) {
                fn.invoke((Object)el);
                continue;
            }
            Map $this$forEach$iv = el;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Object value = entry.getValue();
                if (!(value instanceof ArrayList)) continue;
                Iterable $this$forEach$iv2 = (ArrayList)value;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Map it = (Map)element$iv2;
                    boolean bl2 = false;
                    elementsToCheck.add(it);
                }
            }
        }
    }

    private static final Unit verifyAllHeadingsHaveUniqueIds$lambda$1(List $headingIds, Map it) {
        Intrinsics.checkNotNullParameter((Object)$headingIds, (String)"$headingIds");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = it.get("attrs");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        Map attrs = TypeIntrinsics.asMutableMap(v);
        if (attrs.get("id") == null) {
            throw new MissingArticleHeadingIdException();
        }
        if (CollectionsKt.contains((Iterable)$headingIds, attrs.get("id"))) {
            throw new DuplicateArticleHeadingIdException();
        }
        $headingIds.add(String.valueOf(attrs.get("id")));
        return Unit.INSTANCE;
    }

    private static final Unit addIdsToHeadings$lambda$2(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = it.get("attrs");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        Map attrs = TypeIntrinsics.asMutableMap(v);
        if (attrs.get("id") == null) {
            attrs.put("id", UUID.randomUUID().toString());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getHeadings$lambda$5(List $headings, Ref.IntRef $i, Map heading) {
        Intrinsics.checkNotNullParameter((Object)$headings, (String)"$headings");
        Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        Object v = heading.get("attrs");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        Map attrs = TypeIntrinsics.asMutableMap(v);
        UUID id = UUID.fromString(String.valueOf(attrs.get("id")));
        if (heading.get("content") != null) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Object v2 = heading.get("content");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Any>");
            ArrayList content = (ArrayList)v2;
            Iterable $this$map$iv = content;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                LinkedHashMap list;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof LinkedHashMap ? ((list = (LinkedHashMap)it).get("type") != null && Intrinsics.areEqual(list.get("type"), (Object)"text") ? String.valueOf(list.get("text")) : "") : "");
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void element;
                String $i$f$mapTo2 = (String)iterator$iv.next();
                String acc = (String)accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc + (String)element;
            }
            String text = (String)accumulator$iv;
            if (!StringsKt.isBlank((CharSequence)text)) {
                String string;
                if (text.length() > 1000) {
                    String string2 = text.substring(0, 1000);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = text;
                }
                String truncatedText = string;
                Intrinsics.checkNotNull((Object)id);
                $headings.add(new ArticleHeadingInfo(id, truncatedText, $i.element));
                int n = $i.element;
                $i.element = n + 1;
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit driveMediaIdsFromPMContent$lambda$8(Set $id, Map it) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = it.get("attrs");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map attrs = (Map)v;
        Object v2 = attrs.get("drive-id");
        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
        $id.add((String)v2);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isHeadingTag(Map json) {
        return ProseMirrorContentParserKt.isHeadingTag((Map)json);
    }

    public static final /* synthetic */ boolean access$isMediaTag(Map json) {
        return ProseMirrorContentParserKt.isMediaTag((Map)json);
    }

    static {
        ObjectMapper objectMapper;
        ObjectMapper $this$mapper_u24lambda_u240 = objectMapper = new ObjectMapper();
        boolean bl = false;
        $this$mapper_u24lambda_u240.registerModule((Module)new KotlinModule.Builder().build());
        mapper = objectMapper;
    }
}

