/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence;

import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.DeletionFlagRepository;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.persistence.model.WikiPreview;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH'J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\b\b\u0001\u0010\u0006\u001a\u00020\u0007H'J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH'J0\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH'J:\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\u0014\u001a\u00020\r2\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH'J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\b\b\u0001\u0010\u0014\u001a\u00020\r2\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH'J:\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u000e\b\u0001\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH'J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\nH'J\"\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00020\u001a2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH&J\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u0010H\u0017J\u0016\u0010!\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\nH'J&\u0010\"\u001a\u00020\u001f2\b\b\u0001\u0010#\u001a\u00020\u00032\b\b\u0001\u0010$\u001a\u00020%2\b\b\u0001\u0010&\u001a\u00020'H'J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006*\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/wikiservice/persistence/WikiRepository;", "Lde/justsoftware/wikiservice/persistence/DeletionFlagRepository;", "Lde/justsoftware/wikiservice/persistence/model/Wiki;", "Lde/justsoftware/wikiservice/model/WikiId;", "findAllByTenantId", "Lorg/springframework/data/domain/Page;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "pageable", "Lorg/springframework/data/domain/Pageable;", "", "findAllByTenantIdAndSubscriber", "subscriberId", "", "findAllByPermissionRoles", "granteeIds", "", "Lde/justsoftware/wikiservice/model/GranteeId;", "findWikiPreviewsByRolesAndTenantAndProfile", "Lde/justsoftware/wikiservice/persistence/model/WikiPreview;", "profileId", "findWikiPreviewsByProfileAndTenant", "findAllByPermissionRolesAndSubscriber", "findByDeletionIdIsNullAndIdIn", "ids", "findByIds", "", "findAllByDeletionId", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "deleteAllByDeletionIds", "", "deletionIds", "deleteAllByDeletionIdIn", "setUpdatedStatus", "wikiId", "updatedBy", "Lde/justsoftware/wikiservice/model/ProfileId;", "updatedAt", "Ljava/time/Instant;", "streamAllIds", "Ljava/util/stream/Stream;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiRepository.kt\nde/justsoftware/wikiservice/persistence/WikiRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1368#2:193\n1454#2,5:194\n1202#2,2:199\n1230#2,4:201\n1863#2,2:205\n*S KotlinDebug\n*F\n+ 1 WikiRepository.kt\nde/justsoftware/wikiservice/persistence/WikiRepository\n*L\n156#1:193\n156#1:194,5\n157#1:199,2\n157#1:201,4\n166#1:205,2\n*E\n"})
public interface WikiRepository
extends DeletionFlagRepository<Wiki, WikiId> {
    @Query(value="SELECT w FROM Wiki w WHERE w.tenantId = :tenantId AND w.deletionId is null")
    @NotNull
    public Page<Wiki> findAllByTenantId(@Param(value="tenantId") @NotNull TenantId var1, @NotNull Pageable var2);

    @Query(value="\n            SELECT w\n            FROM Wiki w\n            WHERE w.tenantId = :tenantId\n            AND w.deletionId is null\n        ")
    @NotNull
    public List<Wiki> findAllByTenantId(@Param(value="tenantId") @NotNull TenantId var1);

    @Query(value="SELECT w FROM Wiki w INNER JOIN Subscription s ON (w.id.id = s.itemId AND s.itemType = 'WIKI_WIKI') WHERE w.tenantId = :tenantId AND s.isSubscribed = true AND s.subscriber = :subscriber AND w.deletionId is null")
    @NotNull
    public Page<Wiki> findAllByTenantIdAndSubscriber(@Param(value="tenantId") @NotNull TenantId var1, @Param(value="subscriber") long var2, @NotNull Pageable var4);

    @Query(value="SELECT w FROM Wiki w WHERE EXISTS ( SELECT p FROM Permission p WHERE w.id = p.wikiId AND p.granteeId IN :granteeIds ) AND w.tenantId = :tenantId AND w.deletionId is null")
    @NotNull
    public Page<Wiki> findAllByPermissionRoles(@Param(value="granteeIds") @NotNull Set<GranteeId> var1, @Param(value="tenantId") @NotNull TenantId var2, @NotNull Pageable var3);

    @Query(value="SELECT new de.justsoftware.wikiservice.persistence.model.WikiPreview( w.id as id, w.title as title, w.updatedAt as updatedAt, COALESCE(s.isSubscribed, false) as isSubscribed ) FROM Wiki w LEFT JOIN Subscription s ON w.id.id = s.itemId AND s.subscriber = :profileId WHERE EXISTS ( SELECT p FROM Permission p WHERE w.id = p.wikiId AND p.granteeId IN :granteeIds ) AND w.tenantId = :tenantId AND w.deletionId is null")
    @NotNull
    public Page<WikiPreview> findWikiPreviewsByRolesAndTenantAndProfile(@Param(value="granteeIds") @NotNull Set<GranteeId> var1, @Param(value="profileId") long var2, @Param(value="tenantId") @NotNull TenantId var4, @NotNull Pageable var5);

    @Query(value="SELECT new de.justsoftware.wikiservice.persistence.model.WikiPreview( w.id as id, w.title as title, w.updatedAt as updatedAt, COALESCE(s.isSubscribed, false) as isSubscribed ) FROM Wiki w LEFT JOIN Subscription s ON w.id.id = s.itemId AND s.subscriber = :profileId WHERE w.tenantId = :tenantId AND w.deletionId is null")
    @NotNull
    public Page<WikiPreview> findWikiPreviewsByProfileAndTenant(@Param(value="profileId") long var1, @Param(value="tenantId") @NotNull TenantId var3, @NotNull Pageable var4);

    @Query(value="SELECT w FROM Wiki w INNER JOIN Subscription s ON (w.id.id = s.itemId AND s.itemType = 'WIKI_WIKI') WHERE EXISTS ( SELECT p FROM Permission p WHERE w.id = p.wikiId AND p.granteeId IN :granteeIds ) AND w.tenantId = :tenantId AND s.isSubscribed = true AND s.subscriber = :subscriber AND w.deletionId is null")
    @NotNull
    public Page<Wiki> findAllByPermissionRolesAndSubscriber(@Param(value="granteeIds") @NotNull Set<GranteeId> var1, @Param(value="tenantId") @NotNull TenantId var2, @Param(value="subscriber") long var3, @NotNull Pageable var5);

    @Deprecated(message="Use {@link #findByIds(Set)} instead.")
    @NotNull
    public List<Wiki> findByDeletionIdIsNullAndIdIn(@NotNull List<WikiId> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<WikiId, Wiki> findByIds(@NotNull Set<WikiId> ids) {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)ids, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List p0 = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findByDeletionIdIsNullAndIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Wiki bl = (Wiki)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl2 = false;
            map.put(it.getId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    @NotNull
    public Set<Wiki> findAllByDeletionId(@NotNull DeletionId var1);

    @Transactional
    default public void deleteAllByDeletionIds(@NotNull Set<DeletionId> deletionIds) {
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)deletionIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.deleteAllByDeletionIdIn(it);
        }
    }

    @Deprecated(message="Do not use this function directly. Use {@link #deleteAllByDeletionIds(Set)} instead.")
    public void deleteAllByDeletionIdIn(@NotNull List<DeletionId> var1);

    @Transactional
    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="\n            UPDATE Wiki w\n            SET w.updatedAt = :updatedAt,\n                w.modifiedBy = :updatedBy\n            WHERE w.id = :wikiId\n        ")
    public void setUpdatedStatus(@Param(value="wikiId") @NotNull WikiId var1, @Param(value="updatedBy") @NotNull ProfileId var2, @Param(value="updatedAt") @NotNull Instant var3);

    @Query(value="SELECT w.id FROM Wiki w")
    @NotNull
    public Stream<WikiId> streamAllIds();
}

