/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence;

import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.SubscriptionId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J@\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH'J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000eH&J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH'J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\tH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/wikiservice/persistence/model/Subscription;", "Lde/justsoftware/wikiservice/model/SubscriptionId;", "findAllByWikiPermissionRoles", "", "subscriber", "", "granteeIds", "", "Lde/justsoftware/wikiservice/model/GranteeId;", "wikiIds", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIdsRaw", "Ljava/util/UUID;", "findBySubscriberAndItemId", "itemId", "findBySubscriberAndItemIdIn", "findBySubscriberAndItems", "Lde/justsoftware/wikiservice/model/ProfileId;", "itemIds", "Lde/justsoftware/wikiservice/model/ItemId;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSubscriptionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionRepository.kt\nde/justsoftware/wikiservice/persistence/SubscriptionRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1557#2:55\n1628#2,3:56\n1368#2:59\n1454#2,5:60\n*S KotlinDebug\n*F\n+ 1 SubscriptionRepository.kt\nde/justsoftware/wikiservice/persistence/SubscriptionRepository\n*L\n50#1:55\n50#1:56,3\n52#1:59\n52#1:60,5\n*E\n"})
public interface SubscriptionRepository
extends JpaRepository<Subscription, SubscriptionId> {
    @Query(value="SELECT s FROM Subscription s WHERE EXISTS ( SELECT p FROM Permission p WHERE p.wikiId IN :wikiIds AND p.granteeId IN :granteeIds ) AND s.itemId IN :wikiIdsRaw AND s.subscriber = :subscriber")
    @NotNull
    public List<Subscription> findAllByWikiPermissionRoles(long var1, @NotNull Set<GranteeId> var3, @NotNull Set<WikiId> var4, @NotNull Set<UUID> var5);

    @Nullable
    public Subscription findBySubscriberAndItemId(long var1, @NotNull UUID var3);

    @Deprecated(message="Do not use this function directly. Use [@link #findBySubscriberAndItems(ProfileId, Set<ItemId>)} instead.")
    @NotNull
    public List<Subscription> findBySubscriberAndItemIdIn(long var1, @NotNull Set<UUID> var3);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<Subscription> findBySubscriberAndItems(@NotNull ProfileId subscriber, @NotNull Set<? extends ItemId> itemIds) {
        void $this$flatMapTo$iv$iv;
        List it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable $this$map$iv = itemIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ItemId itemId = (ItemId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findBySubscriberAndItemIdIn(subscriber.getId(), CollectionsKt.toSet((Iterable)it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

