/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.ArticleApplicationService;
import de.justsoftware.wikiservice.application.model.ArticleDto;
import de.justsoftware.wikiservice.application.model.ArticleHeadingDto;
import de.justsoftware.wikiservice.application.model.ArticleVersionDto;
import de.justsoftware.wikiservice.application.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderName;
import de.justsoftware.wikiservice.graphql.generated.MutationCreateArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationDeleteArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationDeleteArticleEditingTokenArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationMoveArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationUpdateArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationUpdateArticleEditingTokenArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryArticleVersionArgs;
import de.justsoftware.wikiservice.graphql.generated.QuerySubscribedArticlesArgs;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007H\u0017J\u001a\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t0\u0007H\u0017J\u001a\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\t0\u0007H\u0017J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0007H\u0017J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0014H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\t0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R&\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\t0\u001d0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R&\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\t0\u001d0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R&\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u001d0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R \u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u001d0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R&\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u001d0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0016\u00a8\u0006."}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/ArticleFetcher;", "", "articleApplicationService", "Lde/justsoftware/wikiservice/application/ArticleApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/application/ArticleApplicationService;)V", "childArticlesByChapterParentsDataLoaderFactory", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "Lde/justsoftware/wikiservice/model/ParentId;", "", "Lde/justsoftware/wikiservice/application/model/ArticleDto;", "articleVersionsByArticleIdsDataLoaderFactory", "Lde/justsoftware/wikiservice/model/ArticleId;", "Lde/justsoftware/wikiservice/application/model/ArticleVersionDto;", "headingsByArticleIdsDataLoaderFactory", "Lde/justsoftware/wikiservice/application/model/ArticleHeadingDto;", "articleCountForWholeWikiDataLoaderFactory", "Lde/justsoftware/wikiservice/model/WikiId;", "", "byId", "Lgraphql/schema/DataFetcher;", "getById", "()Lgraphql/schema/DataFetcher;", "byVersionId", "getByVersionId", "subscribedArticles", "Lde/justsoftware/wikiservice/application/model/ArticleWithTitleDto;", "getSubscribedArticles", "articleVersionsByArticleId", "Ljava/util/concurrent/CompletableFuture;", "getArticleVersionsByArticleId", "headingsByArticleId", "getHeadingsByArticleId", "allByWiki", "getAllByWiki", "countByWiki", "getCountByWiki", "allByChapter", "getAllByChapter", "create", "update", "move", "delete", "updateEditingToken", "", "deleteEditingToken", "wiki-service"})
public class ArticleFetcher {
    @NotNull
    private final ArticleApplicationService articleApplicationService;
    @NotNull
    private final DataFetcher<ArticleDto> byId;
    @NotNull
    private final DataFetcher<ArticleDto> byVersionId;
    @NotNull
    private final DataFetcher<List<ArticleWithTitleDto>> subscribedArticles;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ArticleVersionDto>>> articleVersionsByArticleId;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ArticleHeadingDto>>> headingsByArticleId;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ArticleDto>>> allByWiki;
    @NotNull
    private final DataFetcher<CompletableFuture<Integer>> countByWiki;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ArticleDto>>> allByChapter;

    @Autowired
    public ArticleFetcher(@NotNull ArticleApplicationService articleApplicationService) {
        Intrinsics.checkNotNullParameter((Object)articleApplicationService, (String)"articleApplicationService");
        this.articleApplicationService = articleApplicationService;
        this.byId = arg_0 -> ArticleFetcher.byId$lambda$4(this, arg_0);
        this.byVersionId = arg_0 -> ArticleFetcher.byVersionId$lambda$5(this, arg_0);
        this.subscribedArticles = arg_0 -> ArticleFetcher.subscribedArticles$lambda$6(this, arg_0);
        this.articleVersionsByArticleId = ArticleFetcher::articleVersionsByArticleId$lambda$7;
        this.headingsByArticleId = ArticleFetcher::headingsByArticleId$lambda$8;
        this.allByWiki = ArticleFetcher::allByWiki$lambda$9;
        this.countByWiki = ArticleFetcher::countByWiki$lambda$10;
        this.allByChapter = ArticleFetcher::allByChapter$lambda$11;
    }

    @Bean
    @NotNull
    public DataLoaderFactory<ParentId, List<ArticleDto>> childArticlesByChapterParentsDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.CHILD_ARTICLES_LOADER, (arg_0, arg_1) -> ArticleFetcher.childArticlesByChapterParentsDataLoaderFactory$lambda$0(this, arg_0, arg_1));
    }

    @Bean
    @NotNull
    public DataLoaderFactory<ArticleId, List<ArticleVersionDto>> articleVersionsByArticleIdsDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.ARTICLE_VERSIONS_LOADER, (arg_0, arg_1) -> ArticleFetcher.articleVersionsByArticleIdsDataLoaderFactory$lambda$1(this, arg_0, arg_1));
    }

    @Bean
    @NotNull
    public DataLoaderFactory<ArticleId, List<ArticleHeadingDto>> headingsByArticleIdsDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.ARTICLE_HEADINGS_LOADER, (arg_0, arg_1) -> ArticleFetcher.headingsByArticleIdsDataLoaderFactory$lambda$2(this, arg_0, arg_1));
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, Integer> articleCountForWholeWikiDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.WIKI_ARTICLE_COUNT_LOADER, (arg_0, arg_1) -> ArticleFetcher.articleCountForWholeWikiDataLoaderFactory$lambda$3(this, arg_0, arg_1));
    }

    @NotNull
    public DataFetcher<ArticleDto> getById() {
        return this.byId;
    }

    @NotNull
    public DataFetcher<ArticleDto> getByVersionId() {
        return this.byVersionId;
    }

    @NotNull
    public DataFetcher<List<ArticleWithTitleDto>> getSubscribedArticles() {
        return this.subscribedArticles;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ArticleVersionDto>>> getArticleVersionsByArticleId() {
        return this.articleVersionsByArticleId;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ArticleHeadingDto>>> getHeadingsByArticleId() {
        return this.headingsByArticleId;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ArticleDto>>> getAllByWiki() {
        return this.allByWiki;
    }

    @NotNull
    public DataFetcher<CompletableFuture<Integer>> getCountByWiki() {
        return this.countByWiki;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ArticleDto>>> getAllByChapter() {
        return this.allByChapter;
    }

    @NotNull
    public DataFetcher<ArticleDto> create() {
        return arg_0 -> ArticleFetcher.create$lambda$12(this, arg_0);
    }

    @NotNull
    public DataFetcher<ArticleDto> update() {
        return arg_0 -> ArticleFetcher.update$lambda$13(this, arg_0);
    }

    @NotNull
    public DataFetcher<ArticleDto> move() {
        return arg_0 -> ArticleFetcher.move$lambda$14(this, arg_0);
    }

    @NotNull
    public DataFetcher<ArticleDto> delete() {
        return arg_0 -> ArticleFetcher.delete$lambda$15(this, arg_0);
    }

    @NotNull
    public DataFetcher<Boolean> updateEditingToken() {
        return arg_0 -> ArticleFetcher.updateEditingToken$lambda$16(this, arg_0);
    }

    @NotNull
    public DataFetcher<Boolean> deleteEditingToken() {
        return arg_0 -> ArticleFetcher.deleteEditingToken$lambda$17(this, arg_0);
    }

    private static final Map childArticlesByChapterParentsDataLoaderFactory$lambda$0(ArticleFetcher this$0, List parentIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.articleApplicationService.readByParentIds(parentIds, authContext);
    }

    private static final Map articleVersionsByArticleIdsDataLoaderFactory$lambda$1(ArticleFetcher this$0, List articleIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)articleIds, (String)"articleIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.articleApplicationService.readArticleVersions(articleIds, authContext);
    }

    private static final Map headingsByArticleIdsDataLoaderFactory$lambda$2(ArticleFetcher this$0, List articleIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)articleIds, (String)"articleIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.articleApplicationService.readHeadings(articleIds, authContext);
    }

    private static final Map articleCountForWholeWikiDataLoaderFactory$lambda$3(ArticleFetcher this$0, List wikiIds, AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this$0.articleApplicationService.countArticlesForWikis(wikiIds, authContext);
    }

    private static final ArticleDto byId$lambda$4(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        QueryArticleArgs args = new QueryArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.read(args.getId(), args.getPreferDraft(), context.getAuthContext());
    }

    private static final ArticleDto byVersionId$lambda$5(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        QueryArticleVersionArgs args = new QueryArticleVersionArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.readArticleByVersionId(args.getId(), context.getAuthContext());
    }

    private static final List subscribedArticles$lambda$6(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        QuerySubscribedArticlesArgs args = new QuerySubscribedArticlesArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.readSubscribedArticles(args.getPage(), args.getSize(), context.getAuthContext());
    }

    private static final CompletableFuture articleVersionsByArticleId$lambda$7(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.ARTICLE_VERSIONS_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        ArticleDto article = (ArticleDto)object2;
        return dataLoader.load((Object)article.getId());
    }

    private static final CompletableFuture headingsByArticleId$lambda$8(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.ARTICLE_HEADINGS_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        ArticleDto article = (ArticleDto)object2;
        return dataLoader.load((Object)article.getId());
    }

    private static final CompletableFuture allByWiki$lambda$9(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.CHILD_ARTICLES_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final CompletableFuture countByWiki$lambda$10(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.WIKI_ARTICLE_COUNT_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final CompletableFuture allByChapter$lambda$11(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.CHILD_ARTICLES_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getSource(...)");
        ChapterDto chapter = (ChapterDto)object2;
        return dataLoader.load((Object)chapter.getId());
    }

    private static final ArticleDto create$lambda$12(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationCreateArticleArgs args = new MutationCreateArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.create(args.getArticle(), context.getAuthContext());
    }

    private static final ArticleDto update$lambda$13(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationUpdateArticleArgs args = new MutationUpdateArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.update(args.getId(), args.getArticle(), context.getAuthContext());
    }

    private static final ArticleDto move$lambda$14(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationMoveArticleArgs args = new MutationMoveArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.move(args.getId(), args.getToParent(), context.getAuthContext());
    }

    private static final ArticleDto delete$lambda$15(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationDeleteArticleArgs args = new MutationDeleteArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.delete(args.getId(), context.getAuthContext());
    }

    private static final Boolean updateEditingToken$lambda$16(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationUpdateArticleEditingTokenArgs args = new MutationUpdateArticleEditingTokenArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.updateEditingToken(args.getId(), context.getAuthContext());
    }

    private static final Boolean deleteEditingToken$lambda$17(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        MutationDeleteArticleEditingTokenArgs args = new MutationDeleteArticleEditingTokenArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getContext(...)");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.deleteEditingToken(args.getId(), context.getAuthContext());
    }
}

