/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql;

import graphql.analysis.FieldComplexityCalculator;
import graphql.analysis.FieldComplexityEnvironment;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0012J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0012J\b\u0010\u0011\u001a\u00020\u0010H\u0012J\b\u0010\u0012\u001a\u00020\u0010H\u0012J\b\u0010\u0013\u001a\u00020\u0010H\u0012J#\u0010\u0014\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0012\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/wikiservice/graphql/SimpleComplexityCalculator;", "Lgraphql/analysis/FieldComplexityCalculator;", "<init>", "()V", "complexities", "", "", "", "getKey", "type", "field", "calculate", "env", "Lgraphql/analysis/FieldComplexityEnvironment;", "complexity", "setupWikiComplexities", "", "setupChapterComplexities", "setupArticleComplexities", "setupArticleVersionsComplexities", "setupComplexities", "fields", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "wiki-service"})
public class SimpleComplexityCalculator
implements FieldComplexityCalculator {
    @NotNull
    private final Map<String, Integer> complexities = new LinkedHashMap();

    public SimpleComplexityCalculator() {
        this.setupWikiComplexities();
        this.setupChapterComplexities();
        this.setupArticleComplexities();
        this.setupArticleVersionsComplexities();
    }

    private String getKey(String type, String field) {
        return type + ":" + field;
    }

    public int calculate(@NotNull FieldComplexityEnvironment env, int complexity) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        String string = env.getParentType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String type = string;
        String field = env.getField().getName();
        Intrinsics.checkNotNull((Object)field);
        return complexity + ((Number)this.complexities.getOrDefault(this.getKey(type, field), 0)).intValue();
    }

    private void setupWikiComplexities() {
        String type = "Wiki";
        String[] stringArray = new String[]{"chapters", "articles", "permissions", "userInfo", "updatedBy", "contactPerson", "tableOfContents"};
        String[] fields = stringArray;
        this.setupComplexities(type, fields);
    }

    private void setupChapterComplexities() {
        String type = "Chapter";
        String[] stringArray = new String[]{"chapters", "articles", "ancestors", "updatedBy", "tableOfContents"};
        String[] fields = stringArray;
        this.setupComplexities(type, fields);
    }

    private void setupArticleComplexities() {
        String type = "Article";
        String[] stringArray = new String[]{"ancestors", "updatedBy", "contactPerson", "articleVersions"};
        String[] fields = stringArray;
        this.setupComplexities(type, fields);
    }

    private void setupArticleVersionsComplexities() {
        String type = "ArticleVersion";
        String[] stringArray = new String[]{"updatedBy"};
        String[] fields = stringArray;
        this.setupComplexities(type, fields);
    }

    private void setupComplexities(String type, String[] fields) {
        for (String field : fields) {
            this.complexities.put(this.getKey(type, field), 1);
        }
    }
}

