/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.controller;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.application.model.SubscriptionDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.ArticleApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.GlobalConfigApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.WikiApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.WikiOverviewApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleVersionDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.CreateWikiDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.GlobalConfigDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiOverviewConfigDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.controller.WikiController;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.persistence.model.WikiOverview;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001/B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ6\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010\"\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J>\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000f2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010)\u001a\u00020*2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010+\u001a\u00020,2\b\b\u0001\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lde/justsoftware/wikiservice/controller/WikiController;", "", "articleApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService;", "subscriptionApplicationService", "Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "globalConfigApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/GlobalConfigApplicationService;", "wikiOverviewApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiOverviewApplicationService;", "wikiApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService;Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/GlobalConfigApplicationService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiOverviewApplicationService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiApplicationService;)V", "getVersionHistoryForArticle", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleVersionDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "page", "", "pageSize", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "getArticleVersion", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleDto;", "articleVersionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "createOrUpdateSubscription", "Lde/justsoftware/wikiservice/application/model/SubscriptionDto;", "subscriptionInfo", "Lde/justsoftware/wikiservice/controller/WikiController$CreateOrUpdateSubscription;", "getGlobalConfig", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/GlobalConfigDto;", "changeOverviewConfig", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiOverviewConfigDto;", "configDto", "getWikiPreviews", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiPreviewDto;", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Direction;", "createWiki", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiDto;", "wiki", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/CreateWikiDto;", "CreateOrUpdateSubscription", "wiki-service"})
public class WikiController {
    @NotNull
    private final ArticleApplicationService articleApplicationService;
    @NotNull
    private final SubscriptionApplicationService subscriptionApplicationService;
    @NotNull
    private final GlobalConfigApplicationService globalConfigApplicationService;
    @NotNull
    private final WikiOverviewApplicationService wikiOverviewApplicationService;
    @NotNull
    private final WikiApplicationService wikiApplicationService;

    public WikiController(@NotNull ArticleApplicationService articleApplicationService, @NotNull SubscriptionApplicationService subscriptionApplicationService, @NotNull GlobalConfigApplicationService globalConfigApplicationService, @NotNull WikiOverviewApplicationService wikiOverviewApplicationService, @NotNull WikiApplicationService wikiApplicationService) {
        Intrinsics.checkNotNullParameter((Object)articleApplicationService, (String)"articleApplicationService");
        Intrinsics.checkNotNullParameter((Object)subscriptionApplicationService, (String)"subscriptionApplicationService");
        Intrinsics.checkNotNullParameter((Object)globalConfigApplicationService, (String)"globalConfigApplicationService");
        Intrinsics.checkNotNullParameter((Object)wikiOverviewApplicationService, (String)"wikiOverviewApplicationService");
        Intrinsics.checkNotNullParameter((Object)wikiApplicationService, (String)"wikiApplicationService");
        this.articleApplicationService = articleApplicationService;
        this.subscriptionApplicationService = subscriptionApplicationService;
        this.globalConfigApplicationService = globalConfigApplicationService;
        this.wikiOverviewApplicationService = wikiOverviewApplicationService;
        this.wikiApplicationService = wikiApplicationService;
    }

    @GetMapping(value={"/article/versionHistory/{articleId}"})
    @Nullable
    public Page<ArticleVersionDto> getVersionHistoryForArticle(@PathVariable(value="articleId") @NotNull ArticleId articleId, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.readArticleVersions(articleId, page, pageSize, authContext);
    }

    @GetMapping(value={"/article/version/{articleVersionId}"})
    @NotNull
    public ArticleDto getArticleVersion(@PathVariable(value="articleVersionId") @NotNull ArticleVersionId articleVersionId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleVersionId, (String)"articleVersionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.articleApplicationService.readArticleByVersionId(articleVersionId, authContext);
    }

    @PutMapping(value={"/subscriptions"})
    @NotNull
    public SubscriptionDto createOrUpdateSubscription(@RequestBody @NotNull CreateOrUpdateSubscription subscriptionInfo, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)subscriptionInfo, (String)"subscriptionInfo");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.subscriptionApplicationService.setSubscription(IdUtilsKt.itemIdOf((String)subscriptionInfo.getIdString()), subscriptionInfo.isSubscribed(), authContext);
    }

    @GetMapping(value={"/globalConfig"})
    @NotNull
    public GlobalConfigDto getGlobalConfig(@NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.globalConfigApplicationService.getGlobalConfig(authContext);
    }

    @PutMapping(value={"/overviewConfig"})
    @NotNull
    public WikiOverviewConfigDto changeOverviewConfig(@RequestBody @NotNull WikiOverviewConfigDto configDto, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)configDto, (String)"configDto");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiOverviewApplicationService.setWikiOverviewConfig(configDto.getKey(), configDto.getDirection(), configDto.getDisplay(), authContext);
    }

    @GetMapping(value={"/wikiPreviews"})
    @NotNull
    public Page<WikiPreviewDto> getWikiPreviews(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="30") int pageSize, @RequestParam(value="sortKey", required=false, defaultValue="TITLE") @NotNull WikiOverview.Companion.Sort sortKey, @RequestParam(value="sortDirection", required=false, defaultValue="ASCENDING") @NotNull WikiOverview.Companion.Direction sortDirection, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.getWikiList(page, pageSize, sortKey, sortDirection, authContext);
    }

    @PostMapping(value={"/wikis"})
    @NotNull
    public WikiDto createWiki(@RequestBody @NotNull CreateWikiDto wiki, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.wikiApplicationService.create(wiki, authContext);
    }
}

