/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import de.justsoftware.wikiservice.business.exceptions.NoGranteeException;
import de.justsoftware.wikiservice.business.exceptions.NotAllowedException;
import de.justsoftware.wikiservice.business.exceptions.NotFoundException;
import de.justsoftware.wikiservice.config.ExceptionHandlerConfiguration;
import de.justsoftware.wikiservice.exception.BadRequestException;
import de.justsoftware.wikiservice.exception.UnauthorizedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Configuration
@ControllerAdvice
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\bj\u0002`\u0007H\u0017\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0017J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0017J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0017J\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\bj\u0002`\u0007H\u0017\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0012H\u0017\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration;", "", "<init>", "()V", "handleAllExceptions", "", "e", "Lkotlin/Exception;", "Ljava/lang/Exception;", "(Ljava/lang/Exception;)Ljava/lang/String;", "handleBadRequestException", "Lde/justsoftware/wikiservice/exception/BadRequestException;", "handleNotFoundException", "Lde/justsoftware/wikiservice/business/exceptions/NotFoundException;", "handleNotAllowedException", "Lde/justsoftware/wikiservice/business/exceptions/NotAllowedException;", "handleBadRequestExceptions", "handleUnauthorizedException", "Lde/justsoftware/wikiservice/exception/UnauthorizedException;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nExceptionHandlerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration\n+ 2 LoggerUtils.kt\nde/justsoftware/wikiservice/util/LoggerUtilsKt\n*L\n1#1,69:1\n8#2:70\n7#2,3:71\n*S KotlinDebug\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration\n*L\n65#1:70\n65#1:71,3\n*E\n"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public String handleAllExceptions(@NotNull Exception e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String it = string = DEFAULT_ERROR;
        boolean bl = false;
        LOG.error(DEFAULT_ERROR, (Throwable)e);
        return string;
    }

    @ExceptionHandler(value={BadRequestException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @Nullable
    public String handleBadRequestException(@NotNull BadRequestException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    @Nullable
    public String handleNotFoundException(@NotNull NotFoundException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={NotAllowedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    @Nullable
    public String handleNotAllowedException(@NotNull NotAllowedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, HttpMessageConversionException.class, IllegalArgumentException.class, NoGranteeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @Nullable
    public String handleBadRequestExceptions(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @Nullable
    public String handleUnauthorizedException(@NotNull UnauthorizedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

