/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater;

import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.PermissionApplicationService;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.CreateWikiDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.WikiPreviewDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.persistence.model.Profile;
import de.justsoftware.wikiservice.persistence.model.WikiOverview;
import de.justsoftware.wikiservice.persistence.model.WikiPreview;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="WikiApplicationServiceForNewRestEndpoint")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ6\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/WikiApplicationService;", "", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "permissionApplicationService", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/PermissionApplicationService;", "<init>", "(Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/PermissionApplicationService;)V", "getWikiList", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiPreviewDto;", "page", "", "pageSize", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Direction;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "create", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/WikiDto;", "input", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/CreateWikiDto;", "wiki-service"})
public class WikiApplicationService {
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final PermissionApplicationService permissionApplicationService;

    public WikiApplicationService(@NotNull WikiService wikiService, @NotNull ProfileService profileService, @NotNull PermissionApplicationService permissionApplicationService) {
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        this.wikiService = wikiService;
        this.profileService = profileService;
        this.permissionApplicationService = permissionApplicationService;
    }

    @NotNull
    public Page<WikiPreviewDto> getWikiList(int page, int pageSize, @NotNull WikiOverview.Companion.Sort sortKey, @NotNull WikiOverview.Companion.Direction sortDirection, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Page page2 = this.wikiService.getPreviewPage(authContext.getUser(), page, pageSize, sortKey, sortDirection, authContext.getTenantId()).map(arg_0 -> WikiApplicationService.getWikiList$lambda$1(WikiApplicationService::getWikiList$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @Transactional
    @NotNull
    public WikiDto create(@NotNull CreateWikiDto input, @NotNull AuthContext authContext) {
        WikiDto wikiDto;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateWiki();
        Object v = this.profileService.readByIds(SetsKt.setOf((Object)authContext.getUser())).get(authContext.getUser());
        Intrinsics.checkNotNull(v);
        ProfileDto profile = ProfileDto.Companion.toDto((Profile)v);
        WikiDto it = wikiDto = WikiDto.Companion.toDto(this.wikiService.create(input.getTitle(), input.getDescription(), authContext.getUser(), authContext.getTenantId(), null), profile);
        boolean bl = false;
        this.permissionApplicationService.setPermissionsForWikiCreation(it.getId(), authContext.getUser().toGranteeId(), authContext);
        return wikiDto;
    }

    private static final WikiPreviewDto getWikiList$lambda$0(WikiPreview it) {
        Intrinsics.checkNotNull((Object)it);
        return WikiPreviewDto.Companion.toDto(it);
    }

    private static final WikiPreviewDto getWikiList$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (WikiPreviewDto)$tmp0.invoke(p0);
    }
}

