/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater;

import de.justsoftware.wikiservice.application.UserInfoApplicationService;
import de.justsoftware.wikiservice.application.model.ProfileDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.ArticleVersionDto;
import de.justsoftware.wikiservice.applicationForNewRestEndpointsRenameLater.model.UserInfoDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ProfileService;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.Profile;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service(value="ArticleApplicationServiceForNewRestEndpoint")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService;", "", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "profileService", "Lde/justsoftware/wikiservice/business/ProfileService;", "userInfoApplicationService", "Lde/justsoftware/wikiservice/application/UserInfoApplicationService;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "<init>", "(Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/ProfileService;Lde/justsoftware/wikiservice/application/UserInfoApplicationService;Ljava/time/Clock;J)V", "readArticleVersions", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleVersionDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "page", "", "pageSize", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "readArticleByVersionId", "Lde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/model/ArticleDto;", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n126#2:73\n153#2,3:74\n462#3:77\n412#3:78\n1246#4,4:79\n*S KotlinDebug\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/applicationForNewRestEndpointsRenameLater/ArticleApplicationService\n*L\n36#1:73\n36#1:74,3\n40#1:77\n40#1:78\n40#1:79,4\n*E\n"})
public class ArticleApplicationService {
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserInfoApplicationService userInfoApplicationService;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;

    @Autowired
    public ArticleApplicationService(@NotNull ArticleService articleService, @NotNull ProfileService profileService, @NotNull UserInfoApplicationService userInfoApplicationService, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration) {
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userInfoApplicationService, (String)"userInfoApplicationService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.articleService = articleService;
        this.profileService = profileService;
        this.userInfoApplicationService = userInfoApplicationService;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ArticleVersionDto> readArticleVersions(@NotNull ArticleId articleId, int page, int pageSize, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Map $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map $this$map$iv = this.articleService.readByIds(SetsKt.setOf((Object)articleId));
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Article)it.getValue()).getWikiId());
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkReadArticleVersionHistory(wikiIds);
        Page versions = this.articleService.readPublishedVersionPage(articleId, page, pageSize);
        Set set = versions.map(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$2(ArticleApplicationService::readArticleVersions$lambda$1, arg_0)).toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        $this$mapTo$iv$iv = this.profileService.readByIds(set);
        boolean $i$f$mapValues = false;
        void $i$f$mapTo22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl2 = false;
            ProfileDto profileDto = ProfileDto.Companion.toDto((Profile)it.getValue());
            object.put(k, profileDto);
        }
        Map profiles = destination$iv$iv2;
        Page page2 = versions.map(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$5(arg_0 -> ArticleApplicationService.readArticleVersions$lambda$4(profiles, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    @NotNull
    public ArticleDto readArticleByVersionId(@NotNull ArticleVersionId versionId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleVersion articleVersion = this.articleService.getArticleVersion(versionId);
        Article article = this.articleService.read(articleVersion.getArticleId());
        if (articleVersion.isDraft()) {
            authContext.checkWriteWiki(article.getWikiId());
        } else {
            authContext.checkReadWiki(article.getWikiId());
        }
        ArticleVersion draftVersion = this.articleService.findDraftArticleVersion(articleVersion.getArticleId());
        ProfileId[] profileIdArray = new ProfileId[]{article.getEditingStartedBy(), articleVersion.getModifiedBy()};
        Map profiles = this.profileService.readByIds(SetsKt.setOfNotNull((Object[])profileIdArray));
        profileIdArray = ArticleDto.Companion;
        ArticleVersion articleVersion2 = draftVersion;
        ArticleVersionId articleVersionId = articleVersion2 != null ? articleVersion2.getId() : null;
        Clock clock = this.clock;
        long l = this.maxEditingTokenDuration;
        Profile profile = (Profile)profiles.get(article.getEditingStartedBy());
        ProfileDto profileDto = profile != null ? ProfileDto.Companion.toDto(profile) : null;
        Object v = profiles.get(articleVersion.getModifiedBy());
        Intrinsics.checkNotNull(v);
        ProfileDto profileDto2 = ProfileDto.Companion.toDto((Profile)v);
        UserInfoDto userInfoDto = this.userInfoApplicationService.getUserInfo(article.getWikiId(), authContext);
        return profileIdArray.toDto(article, articleVersion, articleVersionId, clock, l, profileDto2, profileDto, userInfoDto);
    }

    private static final ProfileId readArticleVersions$lambda$1(ArticleVersion it) {
        return it.getModifiedBy();
    }

    private static final ProfileId readArticleVersions$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProfileId)$tmp0.invoke(p0);
    }

    private static final ArticleVersionDto readArticleVersions$lambda$4(Map $profiles, ArticleVersion it) {
        Intrinsics.checkNotNullParameter((Object)$profiles, (String)"$profiles");
        Intrinsics.checkNotNull((Object)it);
        return ArticleVersionDto.Companion.toDto(it, (ProfileDto)$profiles.get(it.getModifiedBy()));
    }

    private static final ArticleVersionDto readArticleVersions$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ArticleVersionDto)$tmp0.invoke(p0);
    }
}

