/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.model.ArticleDto;
import de.justsoftware.wikiservice.application.model.ArticleHeadingDto;
import de.justsoftware.wikiservice.application.model.ArticleVersionDto;
import de.justsoftware.wikiservice.application.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.graphql.generated.CreateArticleInput;
import de.justsoftware.wikiservice.graphql.generated.UpdateArticleInput;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleHeading;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.crossstore.ChangeSetPersister;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B=\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001d0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001d0\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001d2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010)\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\t0\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010/\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00100\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J \u00101\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010-\u001a\u0002022\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u00103\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u00104\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u00105\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J3\u00106\u001a\u0002H7\"\u0004\b\u0000\u00107*\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u0002H709H\u0012\u00a2\u0006\u0002\u0010;R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lde/justsoftware/wikiservice/application/ArticleApplicationService;", "", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "maxPageSize", "", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "<init>", "(Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/wikiservice/business/DeletionService;ILjava/time/Clock;J)V", "read", "Lde/justsoftware/wikiservice/application/model/ArticleDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "preferDraft", "", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "readArticleByVersionId", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "readArticleVersions", "", "", "Lde/justsoftware/wikiservice/application/model/ArticleVersionDto;", "articleIds", "readHeadings", "Lde/justsoftware/wikiservice/application/model/ArticleHeadingDto;", "readByParentIds", "Lde/justsoftware/wikiservice/model/ParentId;", "parentIds", "readSubscribedArticles", "Lde/justsoftware/wikiservice/application/model/ArticleWithTitleDto;", "page", "size", "countArticlesForWikis", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "create", "input", "Lde/justsoftware/wikiservice/graphql/generated/CreateArticleInput;", "move", "toParent", "update", "Lde/justsoftware/wikiservice/graphql/generated/UpdateArticleInput;", "delete", "updateEditingToken", "deleteEditingToken", "withWriteCheck", "T", "block", "Lkotlin/Function1;", "Lde/justsoftware/wikiservice/persistence/model/Article;", "(Lde/justsoftware/wikiservice/authorization/AuthContext;Lde/justsoftware/wikiservice/model/ArticleId;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/application/ArticleApplicationService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n126#2:295\n153#2,3:296\n126#2:317\n153#2,3:318\n1557#3:299\n1628#3,3:300\n1485#3:303\n1510#3,3:304\n1513#3,3:314\n1246#3,2:323\n1557#3:325\n1628#3,3:326\n1249#3:329\n1557#3:330\n1628#3,3:331\n1557#3:334\n1628#3,3:335\n1246#3,2:340\n1557#3:342\n1628#3,3:343\n1249#3:346\n1557#3:348\n1628#3,3:349\n381#4,7:307\n462#4:321\n412#4:322\n462#4:338\n412#4:339\n1#5:347\n*S KotlinDebug\n*F\n+ 1 ArticleApplicationService.kt\nde/justsoftware/wikiservice/application/ArticleApplicationService\n*L\n97#1:295\n97#1:296,3\n106#1:317\n106#1:318,3\n99#1:299\n99#1:300,3\n99#1:303\n99#1:304,3\n99#1:314,3\n109#1:323,2\n109#1:325\n109#1:326,3\n109#1:329\n121#1:330\n121#1:331,3\n122#1:334\n122#1:335,3\n126#1:340,2\n127#1:342\n127#1:343,3\n126#1:346\n148#1:348\n148#1:349,3\n99#1:307,7\n109#1:321\n109#1:322\n126#1:338\n126#1:339\n*E\n"})
public class ArticleApplicationService {
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final DeletionService deletionService;
    private final int maxPageSize;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;

    @Autowired
    public ArticleApplicationService(@NotNull ArticleService articleService, @NotNull AncestorService ancestorService, @NotNull DeletionService deletionService, @Value(value="${service.maxPageSize:200}") int maxPageSize, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration) {
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.articleService = articleService;
        this.ancestorService = ancestorService;
        this.deletionService = deletionService;
        this.maxPageSize = maxPageSize;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
    }

    @NotNull
    public ArticleDto read(@NotNull ArticleId articleId, boolean preferDraft, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        ArticleVersion draftArticleVersion = this.articleService.findDraftArticleVersion(articleId);
        ArticleVersion publishedArticleVersion = this.articleService.findLatestPublishedArticleVersion(articleId);
        if (draftArticleVersion != null && (preferDraft || publishedArticleVersion == null)) {
            authContext.checkWriteWiki(article.getWikiId());
            return ArticleDto.Companion.toDto(article, draftArticleVersion, draftArticleVersion.getId(), this.clock, this.maxEditingTokenDuration);
        }
        if (publishedArticleVersion == null) {
            throw new ChangeSetPersister.NotFoundException();
        }
        authContext.checkReadWiki(article.getWikiId());
        ArticleVersion articleVersion = draftArticleVersion;
        return ArticleDto.Companion.toDto(article, publishedArticleVersion, (ArticleVersionId)(articleVersion != null ? articleVersion.getId() : null), this.clock, this.maxEditingTokenDuration);
    }

    public static /* synthetic */ ArticleDto read$default(ArticleApplicationService articleApplicationService, ArticleId articleId, boolean bl, AuthContext authContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: read");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return articleApplicationService.read(articleId, bl, authContext);
    }

    @NotNull
    public ArticleDto readArticleByVersionId(@NotNull ArticleVersionId versionId, @NotNull AuthContext authContext) {
        ArticleVersion draftVersion;
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ArticleVersion articleVersion = this.articleService.getArticleVersion(versionId);
        Article article = this.articleService.read(articleVersion.getArticleId());
        if (articleVersion.isDraft()) {
            authContext.checkWriteWiki(article.getWikiId());
        } else {
            authContext.checkReadWiki(article.getWikiId());
        }
        ArticleVersion articleVersion2 = draftVersion = this.articleService.findDraftArticleVersion(articleVersion.getArticleId());
        return ArticleDto.Companion.toDto(article, articleVersion, (ArticleVersionId)(articleVersion2 != null ? articleVersion2.getId() : null), this.clock, this.maxEditingTokenDuration);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ArticleId, List<ArticleVersionDto>> readArticleVersions(@NotNull List<ArticleId> articleIds, @NotNull AuthContext authContext) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        ArticleVersion it;
        Collection collection;
        Map.Entry item$iv$iv;
        Object $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set ids = CollectionsKt.toSet((Iterable)articleIds);
        Object $this$map$iv = this.articleService.readByIds(ids);
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Article)it.getValue()).getWikiId());
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkReadArticleVersionHistory(wikiIds);
        $this$map$iv = this.articleService.readPublishedVersions(ids);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (ArticleVersion)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ArticleVersionDto.Companion.toDto(it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Map.Entry element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (ArticleVersionDto)element$iv$iv;
            boolean bl = false;
            ArticleId key$iv$iv = it.getArticleId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ArticleId, List<ArticleHeadingDto>> readHeadings(@NotNull List<ArticleId> articleIds, @NotNull AuthContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map $this$map$iv = this.articleService.readByIds(CollectionsKt.toSet((Iterable)articleIds));
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void it;
            Map.Entry entry = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Article)it.getValue()).getWikiId());
        }
        Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        authContext.checkReadWikis(wikiIds);
        $this$map$iv = this.articleService.readHeadings(CollectionsKt.toSet((Iterable)articleIds));
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv2;
            void headings;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object2;
            boolean bl2 = false;
            Iterable $this$map$iv2 = (Iterable)headings.getValue();
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void heading;
                ArticleHeading articleHeading = (ArticleHeading)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(ArticleHeadingDto.Companion.toDto((ArticleHeading)heading));
            }
            List list = (List)destination$iv$iv2;
            object.put(k, list);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<ArticleDto>> readByParentIds(@NotNull List<? extends ParentId> parentIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (parentIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            void $this$mapValuesTo$iv$iv;
            void $this$mapTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv2;
            Set ids = CollectionsKt.toSet((Iterable)parentIds);
            Map articles = this.articleService.readByParentIds(ids);
            Iterable $this$map$iv = CollectionsKt.flatten((Iterable)articles.values());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Article article = (Article)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getWikiId());
            }
            Set wikiIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv2 = CollectionsKt.flatten((Iterable)articles.values());
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Article bl = (Article)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(it.getId());
            }
            Set articleIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            authContext.checkReadWikis(wikiIds);
            Map articleVersions = this.articleService.findLatestPublishedArticleVersions(articleIds);
            Map draftVersions = this.articleService.findDraftArticleVersions(articleIds);
            Map $this$mapValues$iv = articles;
            boolean $i$f$mapValues = false;
            Map $i$f$mapTo22 = $this$mapValues$iv;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapTo$iv$iv3;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv3;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map2;
                boolean bl3 = false;
                List v = (List)entry2.getValue();
                Iterable $this$map$iv3 = v;
                boolean $i$f$map3 = false;
                Iterable iterable2 = $this$map$iv3;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    ArticleVersion version;
                    void it;
                    Article article = (Article)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl4 = false;
                    if ((ArticleVersion)articleVersions.get(it.getId()) == null) {
                        throw new ArticleVersionNotFoundException(null, 1, null);
                    }
                    ArticleVersion articleVersion = (ArticleVersion)draftVersions.get(it.getId());
                    ArticleVersionId draftId = articleVersion != null ? articleVersion.getId() : null;
                    collection.add(ArticleDto.Companion.toDto((Article)it, version, draftId, this.clock, this.maxEditingTokenDuration));
                }
                List list = (List)destination$iv$iv4;
                object.put(k, list);
            }
            map = destination$iv$iv3;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ArticleWithTitleDto> readSubscribedArticles(int page, int size, @NotNull AuthContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (!(page >= 0)) {
            boolean $i$a$-require-ArticleApplicationService$readSubscribedArticles$32 = false;
            String $i$a$-require-ArticleApplicationService$readSubscribedArticles$32 = "Page must not be < 0";
            throw new IllegalArgumentException($i$a$-require-ArticleApplicationService$readSubscribedArticles$32.toString());
        }
        if (!(1 <= size ? size <= this.maxPageSize : false)) {
            boolean $i$a$-require-ArticleApplicationService$readSubscribedArticles$42 = false;
            String $i$a$-require-ArticleApplicationService$readSubscribedArticles$42 = "PageSize must be between 1 and " + this.maxPageSize;
            throw new IllegalArgumentException($i$a$-require-ArticleApplicationService$readSubscribedArticles$42.toString());
        }
        List it = list = this.articleService.readBySubscriber(authContext.getUser(), page, size);
        boolean bl = false;
        Iterable iterable = it;
        AuthContext authContext2 = authContext;
        boolean $i$f$map = false;
        void var10_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void a;
            ArticleWithTitleDto articleWithTitleDto = (ArticleWithTitleDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(a.getWikiId());
        }
        authContext2.checkReadWikis(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        return list;
    }

    @NotNull
    public Map<WikiId, Integer> countArticlesForWikis(@NotNull List<WikiId> wikiIds, @NotNull AuthContext authContext) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            authContext.checkReadWikis(CollectionsKt.toSet((Iterable)wikiIds));
            map = this.articleService.countByWikiIds(CollectionsKt.toSet((Iterable)wikiIds));
        }
        return map;
    }

    @NotNull
    public ArticleDto create(@NotNull CreateArticleInput input, @NotNull AuthContext authContext) {
        ArticleDto articleDto;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ParentId parentId = input.getParentId();
        WikiId wikiId = this.ancestorService.getAncestorWikiId(parentId);
        int position = this.ancestorService.getNextPositionForParent(parentId);
        authContext.checkWriteWiki(wikiId);
        Article article = this.articleService.create(parentId, wikiId, input.getTitle(), input.getContent(), input.getTextContent(), authContext.getUser(), position, input.getDraft(), input.getContactPerson());
        if (input.getDraft()) {
            ArticleVersion draftVersion = this.articleService.getDraftArticleVersion(article.getId());
            articleDto = ArticleDto.Companion.toDto(article, draftVersion, draftVersion.getId(), this.clock, this.maxEditingTokenDuration);
        } else {
            ArticleVersion articleVersion = this.articleService.getLatestPublishedArticleVersion(article.getId());
            articleDto = ArticleDto.Companion.toDto(article, articleVersion, null, this.clock, this.maxEditingTokenDuration);
        }
        return articleDto;
    }

    @Transactional
    @NotNull
    public ArticleDto move(@NotNull ArticleId articleId, @NotNull ParentId toParent, @NotNull AuthContext authContext) {
        ArticleVersion draftVersion;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)toParent, (String)"toParent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        WikiId toWikiId = this.ancestorService.getAncestorWikiId(toParent);
        authContext.checkMoveWikiContent(article.getWikiId(), toWikiId);
        this.ancestorService.moveArticle(articleId, toParent, authContext.getUser());
        Article updatedArticle = this.articleService.read(articleId);
        ArticleVersion latestPublishedVersion = this.articleService.getLatestPublishedArticleVersion(updatedArticle.getId());
        ArticleVersion articleVersion = draftVersion = this.articleService.findDraftArticleVersion(updatedArticle.getId());
        return ArticleDto.Companion.toDto(updatedArticle, latestPublishedVersion, (ArticleVersionId)(articleVersion != null ? articleVersion.getId() : null), this.clock, this.maxEditingTokenDuration);
    }

    @Transactional
    @NotNull
    public ArticleDto update(@NotNull ArticleId articleId, @NotNull UpdateArticleInput input, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Article article = this.articleService.read(articleId);
        authContext.checkWriteWiki(article.getWikiId());
        Article updatedArticle = this.articleService.update(article.getId(), input.getTitle(), input.getContent(), input.getTextContent(), authContext.getUser(), input.getDraft(), input.getContactPerson());
        ArticleVersion draftVersion = this.articleService.findDraftArticleVersion(updatedArticle.getId());
        ArticleVersion publishedOrDraftVersion = this.articleService.getLatestPublishedOrDraftArticleVersion(updatedArticle.getId());
        ArticleVersion articleVersion = draftVersion;
        return ArticleDto.Companion.toDto(article, publishedOrDraftVersion, (ArticleVersionId)(articleVersion != null ? articleVersion.getId() : null), this.clock, this.maxEditingTokenDuration);
    }

    @Transactional
    @NotNull
    public ArticleDto delete(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (ArticleDto)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.delete$lambda$14(this, articleId, authContext, arg_0));
    }

    public boolean updateEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.updateEditingToken$lambda$15(this, authContext, arg_0));
    }

    public boolean deleteEditingToken(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return (Boolean)this.withWriteCheck(authContext, articleId, arg_0 -> ArticleApplicationService.deleteEditingToken$lambda$16(this, authContext, arg_0));
    }

    private <T> T withWriteCheck(AuthContext $this$withWriteCheck, ArticleId articleId, Function1<? super Article, ? extends T> block) {
        Article article = this.articleService.read(articleId);
        $this$withWriteCheck.checkWriteWiki(article.getWikiId());
        return (T)block.invoke((Object)article);
    }

    private static final ArticleDto delete$lambda$14(ArticleApplicationService this$0, ArticleId $articleId, AuthContext $authContext, Article it) {
        ArticleDto articleDto;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$articleId, (String)"$articleId");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ArticleVersion articleVersion = this$0.articleService.findLatestPublishedArticleVersion($articleId);
        ArticleVersion draftVersion = this$0.articleService.findDraftArticleVersion($articleId);
        if (articleVersion == null && draftVersion == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        DeletionId deletionId = DeletionService.create$default((DeletionService)this$0.deletionService, (ItemId)((ItemId)$articleId), (ProfileId)$authContext.getUser(), null, (int)4, null);
        this$0.articleService.delete($articleId, deletionId, $authContext.getUser());
        if (articleVersion != null) {
            ArticleVersion articleVersion2 = draftVersion;
            articleDto = ArticleDto.Companion.toDto(it, articleVersion, (ArticleVersionId)(articleVersion2 != null ? articleVersion2.getId() : null), this$0.clock, this$0.maxEditingTokenDuration);
        } else if (draftVersion != null) {
            articleDto = ArticleDto.Companion.toDto(it, draftVersion, draftVersion.getId(), this$0.clock, this$0.maxEditingTokenDuration);
        } else {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleDto;
    }

    private static final boolean updateEditingToken$lambda$15(ArticleApplicationService this$0, AuthContext $authContext, Article article) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullParameter((Object)article, (String)"article");
        return this$0.articleService.updateEditingToken(article.getId(), $authContext.getUser());
    }

    private static final boolean deleteEditingToken$lambda$16(ArticleApplicationService this$0, AuthContext $authContext, Article article) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullParameter((Object)article, (String)"article");
        return this$0.articleService.deleteEditingToken(article.getId(), $authContext.getUser());
    }
}

