/*
 Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
 For licensing, see LICENSE.html or http://ckeditor.com/license
 */

// Define global variables for JSLint
/*global CKEDITOR */

//'use strict'; strict mode leads to JUST-11126

CKEDITOR.plugins.add(
    'jc_image', {
        lang: 'de,en',
        icons: 'image',
        hidpi: true,
        init: function(editor) {
            var myToString = function(obj) {
                return obj ? obj.toString() : "";
            };

            var removePX = function(s) {
                var result = parseInt(s, 10);
                return "" + (isNaN(result) ? 0 : result);
            };

            var setMaxSizes = function(elem, w, h) {
                elem.setStyle('max-width', w + 'px');
                elem.setStyle('max-height', h + 'px');
            }

            var setSelectedSizes = function(elem, w, h) {
                elem.setAttribute('selectedWidth', w);
                elem.setAttribute('selectedHeight', h);
            }

            var setStylesAndAttributes = function(elem, w, h) {
                elem.setStyle('width', '100%');
                setMaxSizes(elem, w, h);
                setSelectedSizes(elem, w, h);
            }

            var openPicPopup = function(editor) {
                var selectedElement = editor.getSelection().getSelectedElement(),
                    selectedImage = selectedElement && selectedElement.getName() === "img" ? selectedElement : null,
                    selectedSrc = selectedImage ? selectedImage.getAttribute("src") : null,
                    selectedWidth = selectedImage ? selectedImage.getComputedStyle("width") : null,
                    selectedHeight = selectedImage ? selectedImage.getComputedStyle("height") : null,
                    selectedHorizontalSpace = selectedImage ? myToString(selectedImage.getAttribute("hspace")) : null,
                    selectedVerticalSpace = selectedImage ? myToString(selectedImage.getAttribute("vspace")) : null,
                    selectedBorder = selectedImage ? removePX(selectedImage.getStyle("border-width")) : "0",
                    selectedAlign = selectedImage ? selectedImage.getAttribute("align") : null,
                    selectedAlt = selectedImage ? selectedImage.getAttribute("alt") : null;

                    selectedWidth = selectedImage
                        ? selectedImage.getAttribute('selectedWidth')
                        || selectedImage.getStyle('max-width')
                        || selectedImage.getComputedStyle('width')
                        : null;
                    selectedHeight = selectedImage
                        ? selectedImage.getAttribute('selectedHeight')
                        || selectedImage.getStyle('max-height')
                        || selectedImage.getComputedStyle('height')
                        : null;

                if (editor.getSelection()) {
                    editor.getSelection().lock();
                }

                // Open the popup with a callback.
                editor.justConnect.picSelectPopup(
                    selectedSrc,
                    selectedWidth,
                    selectedHeight,
                    selectedHorizontalSpace,
                    selectedVerticalSpace,
                    selectedBorder,
                    selectedAlign,
                    selectedAlt,
                    function(attributes) { // called, to insert an image
                        var attributeList = ["hspace", "vspace", "align", "alt", "title"],
                            attr,
                            i;
                        var newImage = false;

                        if (editor.getSelection()) {
                            editor.getSelection().unlock(true);
                        }

                        if (!selectedImage) {
                            // No image was selected -> Create a new one
                            selectedImage = editor.document.createElement('img');
                            editor.insertElement(selectedImage);
                            newImage = true;
                        }

                        if (attributes.src) {
                            selectedImage.setAttribute("src", attributes.src);
                        }

                        attributes.title = attributes.alt;

                        for (i = 0; i < attributeList.length; i += 1) {
                            attr = attributeList[i];
                            if (attributes[attr]) {
                                selectedImage.setAttribute(attr, attributes[attr]);
                            } else {
                                selectedImage.removeAttribute(attr);
                            }
                        }

                        // selectedWidth/Height are set, because reading the image size set by the user
                        // produces a number of problems, if the image is responsive and you only have access
                        // to values from the image in the DOM or the CKE image object
                        if (newImage) {
                            selectedImage.on('load', function() {
                                naturalWidth = selectedImage.$.naturalWidth;
                                naturalHeight = selectedImage.$.naturalHeight;
                                setStylesAndAttributes(selectedImage, naturalWidth, naturalHeight);
                            });
                        } else {
                            if (attributes.autosize === 'true') {
                                naturalWidth = selectedImage.$.naturalWidth;
                                naturalHeight = selectedImage.$.naturalHeight;
                                setStylesAndAttributes(selectedImage, naturalWidth, naturalHeight);
                            } else {
                                setStylesAndAttributes(selectedImage, attributes.width, attributes.height);
                            }
                        }

                        attributes.border = attributes.border || "0";
                        selectedImage.setStyle("border-width", attributes.border + "px");
                        selectedImage.removeAttribute('width');
                        selectedImage.removeAttribute('height');
                        editor.fire('change');
                    },
                    function() { // called, when the user cancels
                        if (editor.getSelection()) {
                            editor.getSelection().unlock(true);
                        }
                    });
            };

            // Register the command.
            editor.addCommand('image', {
                allowedContent: 'img[alt,!src,width,height,title,hspace,vspace,align]{border-style,border-width,border-left-width,border-right-width,border-top-width,border-bottom-width,float,height,margin,margin-bottom,margin-left,margin-right,margin-top,width}',
                requiredContent: 'img[alt,src]',
                exec: function(editor) {
                    openPicPopup(editor);
                }
            });

            // Register the toolbar button.
            editor.ui.addButton && editor.ui.addButton('Image', {
                label: editor.lang.common.image,
                command: 'image'
            });

            editor.on('doubleclick', function(evt) {
                var element = evt.data.element;

                if (element.is('img') && !element.data('cke-realelement') && !element.isReadOnly()) {
                    openPicPopup(editor);
                }
            });

            // If the "menu" plugin is loaded, register the menu items.
            if (editor.addMenuItems) {
                editor.addMenuItems({
                    image: {
                        label: editor.lang.jc_image.menu,
                        command: 'image',
                        group: 'image'
                    }
                });
            }

            // If the "contextmenu" plugin is loaded, register the listeners.
            if (editor.contextMenu) {
                editor.contextMenu.addListener(function(element,
                    selection) {
                    if (!element || !element.is('img') || element.data('cke-realelement') || element.isReadOnly()) {
                        return null;
                    }

                    return {
                        image: CKEDITOR.TRISTATE_OFF
                    };
                });
            }
        }
    });
