/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.presentation.client.ui;

import com.freiheit.toro.client.event.GlobalEventBus;
import com.freiheit.toro.client.event.GlobalEventManager;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.PopupHelper;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.editor.InlineEditorView;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockHandler;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockOwner;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.logging.client.ClientLogger;
import de.justsoftware.onx.wikieditor.presentation.client.WikiEditorMediatorInterface;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiEditorComponentPresenter;
import de.justsoftware.onx.wikieditor.presentation.client.ui.WikiEditorPresenter;
import de.justsoftware.onx.wikieditor.shared.i18n.WikiEditorConstants;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersion;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class WikiEditorPresenter
implements InlineEditorView.Presenter {
    private static final int WIKI_EDIT_LINK_POS = 2;
    private static final int BACKUP_INTERVAL = 60000;
    final InlineEditorView _inlineEditor;
    final WikiEditor _wikiEditor;
    final WikiEditorMediatorInterface _mediator;
    private final List<SaveHandler> _saveHandlers = new ArrayList();
    private final BackupTimer _automaticBackupSaver;
    private final WikiEditorComponentPresenter _parentPresenter;
    private final EventManager _eventManager;
    private final LockHandler _lockHandler;
    private final PopupHelper _popupHelper;
    private final ClientLogger _clientLogger;
    private final boolean _editable;
    private final GlobalEventManager _globalEventManager;

    public WikiEditorPresenter(WikiEditorComponentPresenter parentPresenter, EditorClientFactory clientFactory, WikiEditor wikiEditor, WikiEditorMediatorInterface mediator, boolean editable, String toolbar, BackupTimer backupSaver, EventManager eventManager, PopupHelper popupHelper, ClientLogger clientLogger, HistoryManager historyManager, GlobalEventManager globalEventManager, WikiEditorConstants i18n) {
        this._editable = editable;
        this._parentPresenter = parentPresenter;
        this._inlineEditor = clientFactory.getInlineEditorView((InlineEditorView.Presenter)this, (GlobalId)wikiEditor.getId(), editable, true);
        this._inlineEditor.setContent(wikiEditor.getCurrentVersion().getText());
        this._inlineEditor.setToolbar(toolbar);
        this._inlineEditor.setFilebrowserUploadUrl(UrlUtil.generateCKEditorUploadUrl((GlobalId)wikiEditor.getParentId()));
        this._wikiEditor = wikiEditor;
        this._mediator = mediator;
        this._automaticBackupSaver = backupSaver;
        this._lockHandler = new LockHandler(clientFactory.lockManager(), LockOwner.WIKI_COMPONENT);
        this._automaticBackupSaver.setInlineEditor(this._inlineEditor);
        this._eventManager = eventManager;
        this._popupHelper = popupHelper;
        this._clientLogger = clientLogger;
        this._globalEventManager = globalEventManager;
        if (this._editable) {
            this._globalEventManager.fireRenderWikiEditLink(StaticComponentType.WIKI_EDITOR.getName(), (GlobalEventBus.Callback)new /* Unavailable Anonymous Inner Class!! */, i18n.editWiki(), 2);
            historyManager.confirmNextHistoryChange((HistoryManager.ConfirmHistoryChangeCallback)new /* Unavailable Anonymous Inner Class!! */);
            clientFactory.getEditorPreloader().preloadCKEditor();
        }
    }

    public void setLocked(boolean locked) {
        this._inlineEditor.setEditable(!locked && this._editable);
        this._globalEventManager.fireLockWikiEditLink(StaticComponentType.WIKI_EDITOR.getName(), locked);
    }

    public void addSaveHandler(SaveHandler handler) {
        this._saveHandlers.add(handler);
    }

    public void onSave(boolean sendNotificationToSubscribers) {
        this._automaticBackupSaver.cancel();
        this._inlineEditor.setWaitIndicatorVisibility(true);
        this._mediator.saveWikiVersion(this._wikiEditor.getId(), this._inlineEditor.getContent(), sendNotificationToSubscribers, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onEdit(boolean respectLock) {
        this.startEditing(respectLock, null);
    }

    public void onContentClick(boolean respectLock) {
        this.startEditing(respectLock, () -> ((InlineEditorView)this._inlineEditor).focus());
    }

    private void startEditing(boolean respectLock, Runnable callback) {
        if (!this._lockHandler.tryLock()) {
            return;
        }
        this._globalEventManager.fireDeactivateWikiEditLink();
        this._inlineEditor.setWaitIndicatorVisibility(true);
        this._mediator.preEditCheck(this._wikiEditor.getId(), this._wikiEditor.getCurrentVersion().getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void stopEditing(WikiVersion wikiVersion) {
        this._lockHandler.freeLock();
        this._inlineEditor.setSaveButtonEnabled(false);
        this._inlineEditor.setDirty(false);
        this._inlineEditor.showButtons(false);
        String restoreText = wikiVersion.getText();
        this._inlineEditor.stopInlineEditing(restoreText);
        this._globalEventManager.fireActivateWikiEditLink();
    }

    public void onCancel() {
        this._automaticBackupSaver.cancel();
        this.stopEditing(this._wikiEditor.getCurrentVersion());
        this._mediator.deleteWikiBackup(this._wikiEditor.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onChange(boolean dirty) {
        this._inlineEditor.setSaveButtonEnabled(dirty);
        this._inlineEditor.setDirty(dirty);
    }

    public void showIn(AcceptsOneWidget container) {
        container.setWidget((IsWidget)this._inlineEditor);
    }

    public void restoreBackup() {
        if (!this._lockHandler.tryLock()) {
            return;
        }
        this._inlineEditor.setWaitIndicatorVisibility(true);
        this._mediator.getWikiBackup(this._wikiEditor.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onUnload() {
        this._automaticBackupSaver.cancel();
        this._lockHandler.freeLock();
        this._globalEventManager.fireRemoveWikiEditLink(StaticComponentType.WIKI_EDITOR.getName());
    }

    public boolean clearOnUnload() {
        return true;
    }

    public boolean resetOnLoad() {
        return true;
    }
}

