/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui.presenter;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.container.presentation.client.EntityVersionClientFactory;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.ReviewsViewImpl;
import de.justsoftware.onx.container.presentation.shared.EntityVersionControllerAsync;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.person.presentation.client.ui.ReviewsView;
import de.justsoftware.onx.person.presentation.client.ui.presenter.ReviewsPresenter;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import de.justsoftware.onx.validation.shared.model.JucoValidationNode;
import de.justsoftware.onx.validation.shared.model.JucoValidationPath;
import java.util.Date;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ReviewsPresenter
implements ReviewsView.Presenter {
    @Nonnull
    protected final EntityVersionClientFactory _entityVersionClientFactory;
    @Nonnull
    protected final EntityVersionControllerAsync _controller;
    @Nonnull
    protected final ReviewsView _view;
    @Nonnull
    private final EntityVersionConstants _entityVersionConstants;
    private final AsyncCallback<EntityVersionClientModel> _validatingUpdateCallback = new /* Unavailable Anonymous Inner Class!! */;
    @Nonnull
    private final EntityVersionReviewData _reviewData;
    @CheckForNull
    private final ReviewsView.PopupClosedCallback _onActionPerformedCallback;
    @CheckForNull
    private JCDialogBox _popup = null;

    public ReviewsPresenter(@Nonnull EntityVersionClientFactory entityVersionClientFactory, @Nonnull DateFormatter dateFormatter, @Nonnull EntityVersionReviewData reviewData, @Nullable ReviewsView.PopupClosedCallback onActionPerformedCallback) {
        this._entityVersionClientFactory = entityVersionClientFactory;
        this._entityVersionConstants = entityVersionClientFactory.entityVersionConstants();
        this._controller = entityVersionClientFactory.controller();
        this._onActionPerformedCallback = onActionPerformedCallback;
        this._reviewData = reviewData;
        this._view = new ReviewsViewImpl((ReviewsView.Presenter)this, dateFormatter);
    }

    protected abstract void updateView(@Nonnull EntityVersionReviewData var1);

    public final void show() {
        this.updateView(this._reviewData);
        this.showPopup();
    }

    public final void hide() {
        if (this._onActionPerformedCallback != null) {
            this._onActionPerformedCallback.onClose(true);
        }
        this.doClose();
    }

    public final void hideWithoutAction() {
        if (this._onActionPerformedCallback != null) {
            this._onActionPerformedCallback.onClose(false);
        }
        this.doClose();
    }

    private final void doClose() {
        if (this._popup != null) {
            this._popup.hide();
        }
    }

    private void showPopup() {
        this.getPopup().center();
    }

    @Nonnull
    private final JCDialogBox getPopup() {
        if (this._popup == null) {
            2 popup = new /* Unavailable Anonymous Inner Class!! */;
            popup.setContent((IsWidget)this._view.asWidget());
            this._popup = popup;
            return popup;
        }
        return this._popup;
    }

    protected final void validateView() {
        if (this._reviewData != null) {
            this._controller.validate(this._reviewData, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private final void showValidationErrors(@Nonnull ImmutableSet<JucoConstraintViolation> violations) {
        this._view.clearValidationErrors();
        for (JucoConstraintViolation violation : violations) {
            JucoValidationNode node;
            JucoValidationPath propertyPath = violation.getPropertyPath();
            if (propertyPath == null) continue;
            Iterator pathIterator = propertyPath.iterator();
            for (boolean matched = false; !matched && pathIterator.hasNext(); matched |= this.showValidationError(violation.getMessage(), ClientStringUtil.nullToEmpty((String)node.getName()))) {
                node = (JucoValidationNode)pathIterator.next();
            }
        }
    }

    private boolean showValidationError(@Nonnull String errorMessage, @Nonnull String property) {
        if ("declineMessage".equalsIgnoreCase(property)) {
            this._view.showDeclineMessageValidationError(errorMessage);
            return true;
        }
        if ("expirationDate".equalsIgnoreCase(property)) {
            this._view.showExpirationDateValidationError(errorMessage);
            return true;
        }
        if ("releaseDate".equalsIgnoreCase(property)) {
            this._view.showReleaseDateValidationError(errorMessage);
            return true;
        }
        return false;
    }

    public final void acceptAction() {
        if (this._reviewData != null) {
            if (ClientStringUtil.hasText((String)this._reviewData.getDeclineMessage())) {
                this.showValidationError(I18nMediator.ENTITY_VERSION_CONSTANTS.declineMessageSetOnAcceptTooltip(), "declineMessage");
                return;
            }
            this._controller.acceptRelease(this._reviewData.getEntityVersionId(), this._reviewData.getReleaseDate(), this._reviewData.getExpirationDate(), this._validatingUpdateCallback);
        }
    }

    public final void declineAction() {
        if (this._reviewData != null) {
            this._controller.cancelReleaseProcess(this._reviewData.getEntityVersionId(), this._reviewData.getDeclineMessage(), this._validatingUpdateCallback);
        }
    }

    public final void openEntityTypeAction() {
        if (this._reviewData != null) {
            History.newItem((String)EntityOverviewHandler.token((EntityId)((EntityId)this._reviewData.getToReview().getId())));
            this.hideWithoutAction();
        }
    }

    public final void removeMessageAction() {
        if (this._reviewData != null) {
            this._controller.updateReadDateByEntityVersionId(this._reviewData.getEntityVersionId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void showUnexpectedNoDataView() {
        this._view.clearPopupContent();
        this._view.setHeader(this._entityVersionConstants.noReviewData());
        this._view.activateCloseAction();
        this.getPopup().setContent((IsWidget)this._view.asWidget());
        this.showPopup();
    }

    public final void updateReleaseDateAction(Date value) {
        if (this._reviewData != null) {
            this._reviewData.setReleaseDate(value == null ? null : new DateWithoutTimezone(value));
            this.validateView();
        }
    }

    public final void updateExpirationDateAction(Date value) {
        if (this._reviewData != null) {
            this._reviewData.setExpirationDate(value == null ? null : new DateWithoutTimezone(value));
            this.validateView();
        }
    }

    public final void updateDeclineMessageAction(String text) {
        if (this._reviewData != null) {
            this._reviewData.setDeclineMessage(ClientStringUtil.trimToNull((String)text));
            this.validateView();
        }
    }
}

