/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.menu.presentation.server;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.business.LanguageService;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableListIterator;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.MyContentsService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.MenuCreateEntityInfo;
import de.justsoftware.onx.menu.presentation.server.MenuRemoteServiceImpl;
import de.justsoftware.onx.menu.presentation.shared.MenuRemoteService;
import de.justsoftware.onx.menu.presentation.shared.model.FrontendMenuLinkDefinition;
import de.justsoftware.onx.menu.presentation.shared.model.ProfileMenu;
import de.justsoftware.onx.menu.server.model.MenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MyContentsMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MySubscribedPagesMenuLinkDefinition;
import de.justsoftware.onx.menu.shared.model.ExpandStatus;
import de.justsoftware.onx.menu.shared.model.MenuLinkLevel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class MenuRemoteServiceImpl
implements MenuRemoteService {
    private final Settings _settings;
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final MyContentsService _myContentsService;
    private final LanguageService _languageService;
    private final ProfileTeaserService _profileTeaserService;
    private final EntityService _entityService;
    private final Predicate<MenuLinkDefinition> _showInMenuPredicate;
    private final AppConfigService _appConfigService;

    @Autowired
    public MenuRemoteServiceImpl(Settings settings, SessionAuthorizationContextProvider authorizationContextProvider, MyContentsService myContentsService, EntityConfigService entityConfigService, LanguageService languageService, ProfileTeaserService profileTeaserService, EntityService entityService, AppConfigService appConfigService) {
        this._settings = settings;
        this._authorizationContextProvider = authorizationContextProvider;
        this._myContentsService = myContentsService;
        this._languageService = languageService;
        this._profileTeaserService = profileTeaserService;
        this._entityService = entityService;
        this._showInMenuPredicate = new ShowInMenuFunction(entityConfigService);
        this._appConfigService = appConfigService;
    }

    public ImmutableList<FrontendMenuLinkDefinition> getPageMenuLinks() {
        return this.getMenulinks(null);
    }

    public ImmutableList<FrontendMenuLinkDefinition> getPageMyEntityContentLinks(EntityType entityType) {
        return this.getMenulinks(entityType);
    }

    @Nonnull
    private ImmutableList<FrontendMenuLinkDefinition> getMenulinks(@Nullable EntityType myContentEntityType) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        ImmutableSet userRoles = ImmutableSet.of();
        FluentIterable visibleMenuLinks = FluentIterable.from((Iterable)this._settings.getPageMenuLinks()).filter(this._showInMenuPredicate);
        FluentIterable myContentMenuLinks = visibleMenuLinks.filter(MyContentsMenuLinkDefinition.class).filter(mld -> this.getNonnullMenuLinkLevel((MenuLinkDefinition)mld).getLevel() <= 0).filter(mld -> !Collections.disjoint(userRoles, mld.getRoles())).filter(mld -> myContentEntityType == null || myContentEntityType.equals((Object)mld.getEntityType()));
        ImmutableSet myContentsEntityTypes = myContentMenuLinks.transform(MyContentsMenuLinkDefinition::getEntityType).toSet();
        ImmutableListMultimap myContentTeasers = this._myContentsService.getMyContents((Set)myContentsEntityTypes, (AuthorizationCheckContextWithUserId)authCtx);
        ImmutableSet myContentMenuLinksSet = myContentMenuLinks.toSet();
        UnmodifiableListIterator menuLinkIterator = visibleMenuLinks.filter(mld -> myContentEntityType == null || mld instanceof MySubscribedPagesMenuLinkDefinition || myContentMenuLinksSet.contains(mld)).toList().listIterator();
        return this.buildChildList((ListIterator)menuLinkIterator, 0, new ToFrontendModelVisitor(this, authCtx, myContentTeasers, this._settings.showIcons()), userRoles);
    }

    @Nonnull
    private ImmutableList<FrontendMenuLinkDefinition> buildChildList(ListIterator<MenuLinkDefinition> links, int level, ToFrontendModelVisitor toFrontendModelVisitor, ImmutableSet<String> currentUserRoles) {
        if (!links.hasNext()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        FrontendMenuLinkDefinition current = null;
        while (links.hasNext()) {
            MenuLinkDefinition link = links.next();
            MenuLinkLevel linkLevel = this.getNonnullMenuLinkLevel(link);
            if (linkLevel.getLevel() < level) {
                links.previous();
                return result.build();
            }
            if (linkLevel.getLevel() > level) {
                links.previous();
                ImmutableList children = this.buildChildList(links, linkLevel.getLevel(), toFrontendModelVisitor, currentUserRoles);
                if (current == null) continue;
                current.setChildren(children);
                continue;
            }
            current = (FrontendMenuLinkDefinition)link.accept((MenuLinkDefinition.Visitor)toFrontendModelVisitor);
            if (Collections.disjoint(currentUserRoles, link.getRoles())) continue;
            result.add((Object)current);
        }
        return result.build();
    }

    @Nonnull
    private MenuLinkLevel getNonnullMenuLinkLevel(MenuLinkDefinition link) {
        MenuLinkLevel linkLevel = link.getLinkLevel();
        return linkLevel == null ? new MenuLinkLevel(0, ExpandStatus.DEFAULT) : linkLevel;
    }

    public MenuCreateEntityInfo getPageMenuCreateEntityInfo() {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._entityService.getPageMenuCreateEntityInfo((AuthorizationCheckContext)authCtx);
    }

    public ProfileMenu getProfileMenu() {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        ImmutableList languages = ImmutableList.copyOf((Collection)this._languageService.getAvailableLanguages(authCtx.getLocale()));
        PersonId userId = authCtx.getUserId();
        PersonTeaserModel person = (PersonTeaserModel)this._profileTeaserService.getPersonTeasersByIds(Set.of(userId), (AuthorizationCheckContextWithLocale)authCtx).get((Object)userId);
        ImmutableList availableAppIds = this._appConfigService.getAvailableAppIds((AuthorizationCheckContextWithUserId)authCtx);
        return new ProfileMenu(person, languages, this.getAllowedSystemActions(), availableAppIds);
    }

    @Nonnull
    public ImmutableSet<Action> getAllowedSystemActions() {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return authCtx.may(MenuRemoteService.SYSTEM_FUNCTION_ACTIONS);
    }
}

