/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.menu.presentation.client.ui;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.NavList;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.menu.presentation.client.ui.HasMenuIconLinks;
import de.justsoftware.onx.menu.presentation.client.ui.MenuIconLink;
import de.justsoftware.onx.menu.presentation.client.ui.MenuPanel;
import de.justsoftware.onx.menu.presentation.shared.model.FrontendMenuLinkDefinition;
import de.justsoftware.onx.menu.presentation.shared.model.FrontendMenuLinkKey;
import de.justsoftware.onx.menu.shared.model.ExpandStatus;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MenuPanel
extends Composite
implements HasMenuIconLinks {
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private final ClientFactory _clientFactory;
    private final NavList _menuPanel = new NavList();
    private final AsyncCallback<ImmutableList<FrontendMenuLinkDefinition>> _refreshAllTeasersResultHandler = new /* Unavailable Anonymous Inner Class!! */;
    private final AsyncCallback<ImmutableList<FrontendMenuLinkDefinition>> _refreshTeasersForEntityTypeResultHandler = new /* Unavailable Anonymous Inner Class!! */;
    private LinkedListMultimap<FrontendMenuLinkKey, MenuIconLink> _menuIconLinks = LinkedListMultimap.create();

    public MenuPanel(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this.initWidget((Widget)this._menuPanel);
    }

    @Nonnull
    private static MenuIconLink createMenuIconLinkWithCssClass(@Nonnull IconType icon, @Nonnull String title, @Nonnull String token, @Nullable String cssClass, @Nonnull ExpandStatus status, boolean hasChildren) {
        MenuIconLink iconLink = new MenuIconLink(icon, title, token, status, hasChildren);
        if (cssClass != null) {
            iconLink.addStyleName(cssClass);
        }
        return iconLink;
    }

    @Nonnull
    private ExpandStatus mergeExpandStatus(@Nonnull FrontendMenuLinkKey key, @Nonnull FrontendMenuLinkDefinition link) {
        MenuIconLink oldWidget = this.unshiftMenuLink(key);
        if (link.getExpandStatus() == ExpandStatus.ALWAYS_EXPANDED) {
            return ExpandStatus.ALWAYS_EXPANDED;
        }
        if (oldWidget == null) {
            return link.getExpandStatus();
        }
        return oldWidget.isExpanded() ? ExpandStatus.EXPANDED : ExpandStatus.COLLAPSED;
    }

    @CheckForNull
    private MenuIconLink unshiftMenuLink(@Nonnull FrontendMenuLinkKey key) {
        List menuLinks = this._menuIconLinks.get((Object)key);
        if (menuLinks.isEmpty()) {
            return null;
        }
        return (MenuIconLink)menuLinks.remove(0);
    }

    void refreshAllTeasers() {
        this._clientFactory.menuFactory().remoteService().getPageMenuLinks(this._refreshAllTeasersResultHandler);
    }

    void refreshTeasersForEntityType(@Nonnull EntityType entityType) {
        this._clientFactory.menuFactory().remoteService().getPageMyEntityContentLinks(entityType, this._refreshTeasersForEntityTypeResultHandler);
    }

    void removeEntityLinks(@Nonnull EntityId entityId) {
        ImmutableSet linkKeys = ImmutableSet.copyOf((Collection)this._menuIconLinks.keySet());
        for (FrontendMenuLinkKey linkKey : linkKeys) {
            if (!entityId.equals((Object)linkKey.getAssociatedEntityId())) continue;
            for (MenuIconLink menuIconLink : this._menuIconLinks.get((Object)linkKey)) {
                menuIconLink.removeFromParent();
            }
            this._menuIconLinks.removeAll((Object)linkKey);
        }
    }

    private void updateMenuLinks(@Nonnull ImmutableList<FrontendMenuLinkDefinition> menuLinkDefinitions) {
        for (FrontendMenuLinkDefinition menuLinkDefinition : menuLinkDefinitions) {
            FrontendMenuLinkKey parentKey = menuLinkDefinition.getKey(null);
            this._menuIconLinks.keySet().removeIf(key -> parentKey.equals((Object)key.getParentKey()));
        }
        LinkedListMultimap newMenuIconLinks = LinkedListMultimap.create();
        for (FrontendMenuLinkDefinition menuLinkDefinition : menuLinkDefinitions) {
            FrontendMenuLinkKey linkKey = menuLinkDefinition.getKey(null);
            ImmutableList oldMenuLinks = ImmutableList.copyOf((Collection)this._menuIconLinks.get((Object)linkKey));
            if (oldMenuLinks.isEmpty()) continue;
            MenuIconLink oldMenuLink = (MenuIconLink)oldMenuLinks.get(0);
            MenuIconLink newMenuLink = this.createMenuLinkWidget(menuLinkDefinition, null);
            if (newMenuLink == null) continue;
            newMenuIconLinks.put((Object)linkKey, (Object)newMenuLink);
            this.replaceMenuIconLink(oldMenuLink, newMenuLink);
            this.addLinksToPanel((HasMenuIconLinks)newMenuLink, menuLinkDefinition.getChildren(), linkKey, newMenuIconLinks);
        }
        this._menuIconLinks.putAll((Multimap)newMenuIconLinks);
    }

    @CheckForNull
    private MenuIconLink createMenuLinkWidget(@Nonnull FrontendMenuLinkDefinition link, @Nullable FrontendMenuLinkKey parentKey) {
        FrontendMenuLinkKey key = link.getKey(parentKey);
        Optional optionalWidget = (Optional)link.accept((FrontendMenuLinkDefinition.Visitor)new MenuWidgetLinkVisitor(this, LoginManagerImpl.getInstance().getPersonId(), this.mergeExpandStatus(key, link)));
        if (!optionalWidget.isPresent()) {
            return null;
        }
        MenuIconLink widget = (MenuIconLink)optionalWidget.get();
        widget.setIconVisible(link.isShowIcon());
        return widget;
    }

    private void addLinksToPanel(@Nonnull HasMenuIconLinks panel, @Nonnull Iterable<FrontendMenuLinkDefinition> list, @Nullable FrontendMenuLinkKey parentKey, @Nonnull LinkedListMultimap<FrontendMenuLinkKey, MenuIconLink> newMenuIconLinks) {
        for (FrontendMenuLinkDefinition link : list) {
            HasMenuIconLinks childParent;
            FrontendMenuLinkKey key = link.getKey(parentKey);
            MenuIconLink widget = this.createMenuLinkWidget(link, parentKey);
            if (widget != null) {
                newMenuIconLinks.put((Object)key, (Object)widget);
                panel.addMenuIconLink(widget);
                childParent = widget;
            } else {
                childParent = panel;
            }
            this.addLinksToPanel(childParent, link.getChildren(), key, newMenuIconLinks);
        }
    }

    private void applyStyleForFirstLevelLink(@Nonnull MenuIconLink menuIconLink) {
        menuIconLink.addIconWrapperStyleName("first-level");
    }

    public void addMenuIconLink(MenuIconLink menuIconLink) {
        this.applyStyleForFirstLevelLink(menuIconLink);
        this._menuPanel.add((Widget)menuIconLink);
    }

    private void replaceMenuIconLink(@Nonnull MenuIconLink currentLink, @Nonnull MenuIconLink newLink) {
        this.applyStyleForFirstLevelLink(newLink);
        int currentLinkIndex = this._menuPanel.getWidgetIndex((Widget)currentLink);
        if (currentLinkIndex < 0) {
            return;
        }
        this._menuPanel.insert((Widget)newLink, currentLinkIndex);
        this._menuPanel.remove((Widget)currentLink);
    }

    public void updateRootEntityHierarchy() {
        this._menuIconLinks.values().stream().filter(mil -> mil instanceof RootEntityHierarchyMenuIconLink).map(mil -> (RootEntityHierarchyMenuIconLink)mil).forEach(RootEntityHierarchyMenuIconLink::update);
    }
}

