/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.like.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.JucoDropdownButton;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.HasLoadingStateWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.container.shared.model.EntityDetailsPublicData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.like.presentation.client.ui.EntitySubscribeButton;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public final class EntitySubscribeButton
extends SimplePanel {
    private final ClientFactory _clientFactory;
    private final EntityId _entityId;
    private final EntityType _entityType;
    private HasLoadingStateWidget _entitySubscribeWidget;

    private EntitySubscribeButton(ClientFactory clientFactory, EntityDetailsPublicData entityDetails) {
        super((Element)DOM.createSpan());
        this._clientFactory = clientFactory;
        this._entityId = (EntityId)entityDetails.getId();
        this._entityType = (EntityType)entityDetails.getType();
        this.updateGui(entityDetails.getSubscriptionStatus());
    }

    private void updateGui(SubscriptionStatus subscriptionStatus) {
        if (EntitySubscribeButton.isButtonEnabled((SubscriptionStatus)subscriptionStatus)) {
            this.updateDropdown(subscriptionStatus);
        } else {
            this.removeFromParent();
        }
    }

    @Nonnull
    private String textForState(SubscriptionStatus subscriptionStatus) {
        switch (1.$SwitchMap$de$justsoftware$onx$like$shared$model$SubscriptionState[subscriptionStatus.getState().ordinal()]) {
            case 1: {
                return subscriptionStatus.isCanSubscribeWithNotification() ? I18nMediator.LIKE.yourAreSubscribedWithNotifications() : I18nMediator.LIKE.youAreSubscribed();
            }
            case 2: {
                return subscriptionStatus.isCanSubscribeWithNotification() ? I18nMediator.LIKE.youAreSubscribedWithoutNotifications() : I18nMediator.LIKE.youAreSubscribed();
            }
            case 3: {
                return I18nMediator.LIKE.subscribe();
            }
        }
        throw new UnsupportedOperationException("Translation missing for " + String.valueOf(subscriptionStatus.getState()));
    }

    @Nonnull
    private String linkTextForState(SubscriptionState state) {
        switch (1.$SwitchMap$de$justsoftware$onx$like$shared$model$SubscriptionState[state.ordinal()]) {
            case 1: {
                return I18nMediator.LIKE.subscribeWithMail();
            }
            case 2: {
                return I18nMediator.LIKE.subscribeWithoutMail();
            }
            case 3: {
                return I18nMediator.LIKE.unsubscribe();
            }
        }
        throw new UnsupportedOperationException("Link translation missing for " + String.valueOf(state));
    }

    private void addNavLinkFor(JucoDropdownButton dropdownButton, SubscriptionState current, SubscriptionState next) {
        if (current == next) {
            return;
        }
        NavLink navLink = new NavLink(this.linkTextForState(next));
        navLink.addClickHandler((ClickHandler)new SwitchStateClickHandler(this, next));
        dropdownButton.add((Widget)navLink);
    }

    private void updateDropdown(SubscriptionStatus subscriptionStatus) {
        SubscriptionState state = subscriptionStatus.getState();
        if (state == SubscriptionState.UNSUBSCRIBED || !subscriptionStatus.isCanSubscribeWithNotification()) {
            this.addButton(subscriptionStatus);
        } else {
            this.addDropdownButton(subscriptionStatus);
        }
    }

    private void addButton(SubscriptionStatus subscriptionStatus) {
        SubscriptionState state = subscriptionStatus.getState();
        JCButton button = new JCButton(this.textForState(subscriptionStatus), (ClickHandler)new SwitchStateClickHandler(this, state.isSubscribed() ? SubscriptionState.UNSUBSCRIBED : SubscriptionState.SUBSCRIBED));
        button.setIcon((IconType)(state.isSubscribed() ? IconType.OK : null));
        this._entitySubscribeWidget = button;
        this.setWidget((Widget)button);
    }

    private void addDropdownButton(SubscriptionStatus subscriptionStatus) {
        SubscriptionState state = subscriptionStatus.getState();
        JucoDropdownButton dropdownButton = new JucoDropdownButton(this.textForState(subscriptionStatus));
        dropdownButton.setIcon(IconType.OK);
        this.addNavLinkFor(dropdownButton, state, SubscriptionState.SUBSCRIBED);
        this.addNavLinkFor(dropdownButton, state, SubscriptionState.SUBSCRIBED_WITHOUT_MAIL);
        this.addNavLinkFor(dropdownButton, state, SubscriptionState.UNSUBSCRIBED);
        this._entitySubscribeWidget = dropdownButton;
        this.setWidget((Widget)dropdownButton);
    }

    private static boolean isButtonEnabled(SubscriptionStatus subscriptionStatus) {
        return subscriptionStatus.maySubscribe() || subscriptionStatus.mayUnsubscribe();
    }

    @CheckForNull
    public static EntitySubscribeButton create(ClientFactory clientFactory, EntityDetailsPublicData entityDetails) {
        if (!EntitySubscribeButton.isButtonEnabled((SubscriptionStatus)entityDetails.getSubscriptionStatus())) {
            return null;
        }
        return new EntitySubscribeButton(clientFactory, entityDetails);
    }
}

