/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.server;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.Person;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.presentation.shared.MultiPersonSelectionRemoteService;
import de.justsoftware.onx.container.presentation.shared.model.PersonSelectionChangeResult;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.PersonDetails;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.shared.model.PersonBadgeModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiPersonSelectionRemoteServiceImpl
implements MultiPersonSelectionRemoteService {
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private EntityMemberService _entityMemberService;

    public ListAndCount<PersonDetails> getSelectedPersonList(ImmutableSet<Person> currentSelected, int offset, int limit) {
        ListAndCount personSublist = CollectionUtil.nullSafeListAndCount((List)currentSelected.asList(), (int)offset, (int)limit);
        List convertToInviteeDetails = this.convertToPersonDetails((List)personSublist, (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser());
        ListAndCount result = new ListAndCount();
        result.setMaxCount(personSublist.getMaxCount());
        result.addAll((Collection)convertToInviteeDetails);
        return result;
    }

    public PersonSelectionChangeResult addMembersOfEntityToSelectedPersonList(ImmutableSet<Person> currentSelected, EntityId entityId, int offset, int limit, MultiPersonSelectionRemoteService.AddSelectedPersonListCheckAction checkAction) {
        ImmutableSet persons;
        AuthorizationContext context = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        context.check((ItemId)entityId, checkAction.getAction());
        if (entityId == null) {
            persons = ImmutableSet.of();
        } else {
            ImmutableList members = this._entityMemberService.getEntityMembersByEntityId(entityId);
            FluentIterable filteredMembers = FluentIterable.from((Iterable)members).filter(EntityMemberUtil.composeRoleFilterPredicate((Set)EntityMemberRoles.VISIBLE_MEMBER)).transform(EntityMember.GET_PERSON_ID);
            ImmutableSet.Builder participantsBuilder = ImmutableSet.builder();
            participantsBuilder.addAll((Iterable)filteredMembers);
            participantsBuilder.addAll((Iterable)this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_MEMBERS, (Set)ImmutableSet.of((Object)entityId)).get((Object)entityId));
            participantsBuilder.addAll((Iterable)this._entityMemberService.getInheritedMembers(InheritsRole.INHERIT_ADMINS, (Set)ImmutableSet.of((Object)entityId)).get((Object)entityId));
            persons = participantsBuilder.build();
        }
        return this.addPersonIdsToSelectedPersonList(currentSelected, (Collection)persons, offset, limit, context);
    }

    @Nonnull
    private PersonSelectionChangeResult addPersonIdsToSelectedPersonList(@Nonnull ImmutableSet<Person> currentSelected, @Nonnull Collection<PersonId> persons, int offset, int limit, @Nonnull AuthorizationContext context) {
        ImmutableSet newSelection = this.addPersonIdsToSelectedPersonList(currentSelected, persons, (AuthorizationCheckContext)context);
        return new PersonSelectionChangeResult(newSelection, this.getSelectedPersonList(newSelection, offset, limit));
    }

    @Nonnull
    private ImmutableSet<Person> addPersonIdsToSelectedPersonList(@Nonnull ImmutableSet<Person> currentSelected, @Nonnull Collection<PersonId> personIds, @Nonnull AuthorizationCheckContext authCtx) {
        ImmutableSet filteredPublicProfiles = this._personService.filterPublicProfiles(personIds, authCtx);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (PersonId pid : filteredPublicProfiles) {
            result.add((Object)new Person(pid));
        }
        result.addAll(currentSelected);
        return result.build();
    }

    private List<PersonDetails> convertToPersonDetails(List<Person> personList, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        if (personList == null) {
            return null;
        }
        ImmutableSet.Builder personIds = ImmutableSet.builder();
        for (Person person : personList) {
            PersonId personId = person.getId();
            personIds.add((Object)personId);
        }
        ImmutableMap personBadges = this._profileTeaserService.getPersonBadgesByIds((Set)personIds.build(), authorizationContext);
        ArrayList<PersonDetails> result = new ArrayList<PersonDetails>();
        for (Person person : personList) {
            PersonId personId = person.getId();
            PersonBadgeModel personBadge = (PersonBadgeModel)personBadges.get(personId);
            if (personBadge == null) continue;
            result.add(new PersonDetails(personBadge, person));
        }
        return result;
    }
}

