/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.server;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.common.clock.Clock;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.EntityVersionDetailsClientModel;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.presentation.shared.EntityVersionController;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolationException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityVersionControllerImpl
implements EntityVersionController {
    private static final Logger LOG = LoggerFactory.getLogger(EntityVersionControllerImpl.class);
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private MultiWikiService _multiWikiService;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private Clock _clock;

    public EntityVersionClientModel startReleaseProcess(EntityVersionReleaseClientModel releaseData) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this.getEntityVersionClientModel(this._entityVersionService.stageVersionForReview(releaseData, (AuthorizationCheckContextWithUserId)auth));
    }

    @Nonnull
    private EntityVersionClientModel getEntityVersionClientModel(EntityVersion version) {
        return new EntityVersionClientModel((IEntityVersion)version);
    }

    public EntityVersionClientModel getCurrentEntityVersion(EntityId entityId) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        boolean releaseProcessMandatory = this._entityConfigService.releaseProcessMandatory(entity.getType());
        if (!releaseProcessMandatory) {
            return null;
        }
        EntityVersion version = this._entityVersionService.getCurrentEntityVersionForUser(entity.getId(), (AuthorizationCheckContext)auth);
        if (version == null) {
            return null;
        }
        return this.getEntityVersionClientModel(version);
    }

    public ListAndCount<EntityVersionDetailsClientModel> getVersionDetails(EntityId entityId, int limit, int offset) throws PermissionDeniedException, NotLoggedInException {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        ListAndCount dbVersions = this._entityVersionService.getEntityVersions(entityId, offset, limit, (AuthorizationCheckContext)authCtx);
        ImmutableSet versionIds = Identifiables.toIdSet((Iterable)dbVersions);
        ImmutableSetMultimap mays = this._entityVersionService.getActionsForVersions(entityId, (Iterable)versionIds, (AuthorizationCheckContext)authCtx);
        FluentIterable authorIds = FluentIterable.from((Iterable)dbVersions).transform(IEntityVersion.TO_AUTHOR_ID);
        ImmutableSetMultimap reviewerIds = this._entityVersionService.getReviewersForVersions((Set)versionIds);
        ImmutableMap profiles = this._profileTeaserService.getPersonTeasersByIds((Set)authorIds.append((Iterable)reviewerIds.values()).toSet(), (AuthorizationCheckContextWithLocale)authCtx);
        ImmutableList.Builder versionDetails = ImmutableList.builder();
        for (EntityVersion dbVersion : dbVersions) {
            EntityVersionDetailsClientModel details = this.enrichVersionWithDetails(dbVersion, profiles, reviewerIds, mays);
            if (details == null) continue;
            versionDetails.add((Object)details);
        }
        return new ListAndCount(dbVersions.getMaxCount(), (Collection)versionDetails.build());
    }

    @CheckForNull
    private EntityVersionDetailsClientModel enrichVersionWithDetails(EntityVersion dbVersion, ImmutableMap<PersonId, PersonTeaserModel> profiles, ImmutableSetMultimap<EntityVersionId, PersonId> reviewerIds, ImmutableSetMultimap<EntityVersionId, Action> mays) {
        PersonTeaserModel author = (PersonTeaserModel)profiles.get((Object)dbVersion.getAuthorId());
        if (author == null) {
            LOG.error("No PersonTeaserModel with id {}  found for entity version {} ", (Object)dbVersion.getAuthorId(), (Object)dbVersion.getId());
            return null;
        }
        ImmutableList versionReviewer = FluentIterable.from((Iterable)reviewerIds.get((Object)dbVersion.getId())).transform(arg_0 -> profiles.get(arg_0)).filter(Predicates.notNull()).toList();
        return new EntityVersionDetailsClientModel((IEntityVersion)dbVersion, author, versionReviewer, mays.get((Object)dbVersion.getId()));
    }

    public EntityVersionReviewData getVersionReviewData(EntityVersionId entityVersionId) {
        return this._entityVersionService.getReviewForPerson((AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser(), entityVersionId);
    }

    public void updateReadDateByEntityVersionId(EntityVersionId id) {
        this._entityVersionService.updateReadDateByEntityVersionId(id, new DateWithoutTimezone(this._clock.nowMillis()));
    }

    public EntityVersionClientModel cancelReleaseProcess(EntityVersionId releaseVersionId, String declineMessage) throws PermissionDeniedException, JucoConstraintViolationException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this.getEntityVersionClientModel(this._entityVersionService.declineVersion(releaseVersionId, declineMessage, (AuthorizationCheckContextWithUserId)auth));
    }

    public EntityVersionClientModel acceptRelease(EntityVersionId releaseVersionId, DateWithoutTimezone newReleaseDate, DateWithoutTimezone newExpirationDate) throws PermissionDeniedException, JucoConstraintViolationException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this.getEntityVersionClientModel(this._entityVersionService.acceptVersion(releaseVersionId, newReleaseDate, newExpirationDate, (AuthorizationCheckContextWithUserId)auth));
    }

    public String getWikiCompareData(EntityVersionId firstVersion, EntityVersionId secondVersion) throws PermissionDeniedException, NotLoggedInException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        ImmutableMap bothVersions = this._entityVersionService.getMultiWikiVersionsForEntityVersions((Set)ImmutableSet.of((Object)firstVersion, (Object)secondVersion));
        MultiWikiVersionId firstWikiVersion = (MultiWikiVersionId)bothVersions.get((Object)firstVersion);
        MultiWikiVersionId secondWikiVersion = (MultiWikiVersionId)bothVersions.get((Object)secondVersion);
        return this._multiWikiService.getCompareData((AuthorizationCheckContextWithUserId)auth, firstWikiVersion, secondWikiVersion);
    }

    public String getWikiVersionAsHtmlString(EntityVersionId versionId) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        MultiWikiVersionId wikiVersion = (MultiWikiVersionId)this._entityVersionService.getMultiWikiVersionsForEntityVersions((Set)ImmutableSet.of((Object)versionId)).get((Object)versionId);
        if (wikiVersion == null) {
            throw new InvalidIdServiceException();
        }
        return this._multiWikiService.getMultiWikiVersionAsHtml((AuthorizationCheckContextWithUserId)auth, wikiVersion);
    }

    public EntityId deleteVersion(EntityVersionId versionId) throws PermissionDeniedException, NotLoggedInException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._entityVersionService.deleteVersion(versionId, (AuthorizationCheckContextWithUserId)auth);
    }

    public EntityVersionClientModel restoreVersion(EntityVersionId versionId) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this.getEntityVersionClientModel(this._entityVersionService.restoreVersion(versionId, (AuthorizationCheckContextWithUserId)auth));
    }

    public ListAndCount<EntityBadge> getMyDrafts(int offset, int limit) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._entityVersionService.listDraftsForAuthor(offset, limit, (AuthorizationCheckContextWithUserId)auth);
    }

    public int getMyDraftCount() {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._entityVersionService.getDraftCountForAuthor((AuthorizationCheckContextWithUserId)auth);
    }

    public ImmutableSet<JucoConstraintViolation> validate(EntityVersionReviewData data) {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._entityVersionService.validateReviewDataForDefaultGroup(data, auth);
    }

    public EntityVersionClientModel archiveVersion(EntityId entityId, EntityVersionId entityVersionId) throws PermissionDeniedException, JucoConstraintViolationException {
        AuthorizationContext auth = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this.getEntityVersionClientModel(this._entityVersionService.archiveEntity(entityId, entityVersionId, auth));
    }
}

