/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.server;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.gwt.i18n.dynamic.server.I18nMessagesFactory;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.BasePersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.i18n.I18nServiceException;
import de.justsoftware.onx.common.shared.model.Person;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityDetailsService;
import de.justsoftware.onx.container.business.EntityEventWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowService;
import de.justsoftware.onx.container.business.EntityRecommendationService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.presentation.shared.EntityRecommendationController;
import de.justsoftware.onx.container.presentation.shared.model.AddMemberOperation;
import de.justsoftware.onx.container.presentation.shared.model.EntityRecommendationPersonModel;
import de.justsoftware.onx.container.presentation.shared.util.AddMemberOperationActionVisitor;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.AddMemberResultKey;
import de.justsoftware.onx.container.shared.model.AddMemberSetupData;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInviteOrRecommendSetupData;
import de.justsoftware.onx.container.shared.model.FailedAndSuccessfulActionsDetails;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.InvitationResultKey;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityRecommendationControllerImpl
implements EntityRecommendationController {
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final EntityService _entityService;
    private final EntityDetailsService _entityDetailsService;
    private final I18nService _i18nService;
    private final EntityRecommendationService _entityRecommendationService;
    private final EntityMemberWorkflowService _entityMemberWorkflowService;
    private final EntityEventWorkflowService _entityEventWorkflowService;
    private final MultiWikiService _multiWikiService;
    private final Settings _settings;
    private final InternalLinkService _internalLinkService;
    private final ProfileTeaserService _profileTeaserService;

    @Autowired
    public EntityRecommendationControllerImpl(EntityRecommendationService entityRecommendationService, EntityService entityService, EntityDetailsService entityDetailsService, SessionAuthorizationContextProvider authorizationContextProvider, I18nService i18nService, EntityMemberWorkflowService entityMemberWorkflowService, EntityEventWorkflowService entityEventWorkflowService, MultiWikiService multiWikiService, Settings settings, InternalLinkService internalLinkService, ProfileTeaserService profileTeaserService) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._entityService = entityService;
        this._entityDetailsService = entityDetailsService;
        this._i18nService = i18nService;
        this._entityRecommendationService = entityRecommendationService;
        this._entityMemberWorkflowService = entityMemberWorkflowService;
        this._entityEventWorkflowService = entityEventWorkflowService;
        this._multiWikiService = multiWikiService;
        this._settings = settings;
        this._internalLinkService = internalLinkService;
        this._profileTeaserService = profileTeaserService;
    }

    public FailedAndSuccessfulActionsDetails<EntityId, ImmutableMap<InvitationResultKey, String>> recommendEntitiesToSelectedPersons(ImmutableSet<Person> selectedPersons, ImmutableSet<EntityId> entityIds, String recommendationMessage, ImmutableSet<ComponentType> selectedEditorTypes) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        ImmutableSet personIds = FluentIterable.from(selectedPersons).transform(Person::getId).filter(Predicates.notNull()).toSet();
        if (CollectionUtil.isEmpty((Iterable)personIds)) {
            I18nMessagesFactory factory = new I18nMessagesFactory();
            throw new I18nServiceException(factory.getMessage(((BasicConstants)factory.createProxy(BasicConstants.class)).pleaseSelectAtLeastOnePerson()));
        }
        if (recommendationMessage.length() > 4000) {
            I18nMessagesFactory factory = new I18nMessagesFactory();
            throw new I18nServiceException(factory.getMessage(((BasicConstants)factory.createProxy(BasicConstants.class)).recommendationMessageLengthExceeded()));
        }
        if (entityIds.size() > 1 && !CollectionUtil.isEmpty(selectedEditorTypes)) {
            I18nMessagesFactory factory = new I18nMessagesFactory();
            throw new I18nServiceException(factory.getMessage(((BasicConstants)factory.createProxy(BasicConstants.class)).noEntitySpecificComponentsWhenRecommendingMultipleEntities()));
        }
        FailedAndSuccessfulActionsDetails.Builder result = FailedAndSuccessfulActionsDetails.getBuilder();
        Map entities = this._entityService.getByIds(entityIds);
        ImmutableSet allowedIds = authorizationContext.filterAllowedIds(entityIds, (Action)StaticEntityAction.ENTITY_RECOMMEND);
        for (DBEntity entity : entities.values()) {
            EntityMessages entityMessages = this._i18nService.getEntityMessagesByEntityType(entity.getType(), authorizationContext.getLocale());
            if (allowedIds.contains((Object)entity.getId())) {
                ImmutableMultiset personsWithRecommendation = this._entityRecommendationService.recommendEntityToPersons(entity.getId(), (Set)personIds, (AuthorizationCheckContextWithUserId)authorizationContext, recommendationMessage, selectedEditorTypes);
                result.addDetails((ItemId)entity.getId(), (Object)this.getSuccessfulRecommendationMessages(personsWithRecommendation, entityMessages));
                continue;
            }
            if (personIds.isEmpty()) continue;
            result.addErrorMessage((ItemId)entity.getId(), entityMessages.notAllowedToSendRecommendationToUsers(personIds.size()));
        }
        return result.build();
    }

    @Nonnull
    private ImmutableMap<InvitationResultKey, String> getSuccessfulRecommendationMessages(ImmutableMultiset<InvitationResultKey> numberOfRecommendations, EntityMessages entityMessages) {
        int alreadyRecommended = numberOfRecommendations.count((Object)InvitationResultKey.ALREADY_RECOMMENDED);
        int recommended = numberOfRecommendations.count((Object)InvitationResultKey.RECOMMENDED);
        ImmutableMap.Builder messagesBuilder = ImmutableMap.builder();
        if (recommended == 1) {
            messagesBuilder.put((Object)InvitationResultKey.RECOMMENDED, (Object)entityMessages.oneRecommendationWasSent());
        } else if (recommended > 1) {
            messagesBuilder.put((Object)InvitationResultKey.RECOMMENDED, (Object)entityMessages.xRecommendationsWereSent(recommended));
        }
        if (alreadyRecommended == 1) {
            messagesBuilder.put((Object)InvitationResultKey.ALREADY_RECOMMENDED, (Object)entityMessages.oneRecommendationWasSkipped());
        } else if (alreadyRecommended > 1) {
            messagesBuilder.put((Object)InvitationResultKey.ALREADY_RECOMMENDED, (Object)entityMessages.xRecommendationsWereSkipped(alreadyRecommended));
        }
        return messagesBuilder.build();
    }

    public void removeRecommendation(EntityId entityId) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._entityRecommendationService.removeRecommendation(entityId, (AuthorizationContextWithUserId)authorizationContext);
    }

    public EntityInviteOrRecommendSetupData getInviteOrRecommendSetupData(EntityId selectedEntity) {
        AuthorizationContext authContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        EntityDetails entityDetails = null;
        boolean maySelectHtmlContent = false;
        boolean maySelectMultiWiki = false;
        if (selectedEntity != null && (maySelectHtmlContent = authContext.may((ItemId)selectedEntity, (Action)StaticEntityAction.ENTITY_SELECT_HTML_CONTENT))) {
            entityDetails = this._entityDetailsService.getDetailsById(selectedEntity, authContext);
            maySelectMultiWiki = this._multiWikiService.isFirstMultiWikiSectionVisible(selectedEntity, (AuthorizationCheckContext)authContext);
        }
        return new EntityInviteOrRecommendSetupData(false, maySelectHtmlContent, maySelectMultiWiki, entityDetails);
    }

    public AddMemberSetupData getAddMemberSetupData() {
        return new AddMemberSetupData(false);
    }

    public FailedAndSuccessfulActionsDetails<EntityId, ImmutableMap<AddMemberResultKey, String>> addMember(AddMemberOperation operation, ImmutableSet<EntityId> entityIds, ImmutableSet<Person> persons) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        ImmutableSet personIds = FluentIterable.from(persons).transform(Person::getId).filter(Predicates.notNull()).toSet();
        if (CollectionUtil.isEmpty((Iterable)personIds)) {
            I18nMessagesFactory factory = new I18nMessagesFactory();
            throw new I18nServiceException(factory.getMessage(((BasicConstants)factory.createProxy(BasicConstants.class)).pleaseSelectAtLeastOnePerson()));
        }
        FailedAndSuccessfulActionsDetails.Builder result = FailedAndSuccessfulActionsDetails.getBuilder();
        Map entities = this._entityService.getByIds(entityIds);
        Iterable allowed = authorizationContext.filterAllowedItems((Iterable)FluentIterable.from(entities.values()).transform(EntityItem.FROM_DBENTITY), (Action)operation.accept((AddMemberOperation.Visitor)AddMemberOperationActionVisitor.INSTANCE));
        ImmutableSet allowedIds = FluentIterable.from((Iterable)allowed).transform(Identifiables.toId()).toSet();
        for (DBEntity entity : entities.values()) {
            EntityMessages entityMessages = this._i18nService.getEntityMessagesByEntityType(entity.getType(), authorizationContext.getLocale());
            EntityId entityId = entity.getId();
            if (allowedIds.contains((Object)entityId)) {
                ImmutableMultiset opResult = this.executeAddMemberOperation(entityId, operation, personIds, authorizationContext);
                result.addDetails((ItemId)entityId, (Object)this.getAdMemberMessages(opResult, entityMessages));
                continue;
            }
            if (personIds.size() <= 0) continue;
            result.addErrorMessage((ItemId)entityId, entityMessages.notAllowedAddUsers(personIds.size(), entity.getName(), entity.getType()));
        }
        return result.build();
    }

    @Nonnull
    private ImmutableMultiset<AddMemberResultKey> executeAddMemberOperation(EntityId entityId, AddMemberOperation operation, ImmutableSet<PersonId> personIds, AuthorizationContext authorizationContext) {
        return (ImmutableMultiset)operation.accept((AddMemberOperation.Visitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    private ImmutableMap<AddMemberResultKey, String> getAdMemberMessages(ImmutableMultiset<AddMemberResultKey> opResult, EntityMessages entityMessages) {
        int success;
        ImmutableMap.Builder result = ImmutableMap.builder();
        int skipped = opResult.count((Object)AddMemberResultKey.ALREADY_MEMBER);
        if (skipped > 0) {
            result.put((Object)AddMemberResultKey.ALREADY_MEMBER, (Object)entityMessages.memberSkipped(skipped));
        }
        if ((success = opResult.count((Object)AddMemberResultKey.MEMBER_ADDED)) > 0) {
            result.put((Object)AddMemberResultKey.MEMBER_ADDED, (Object)entityMessages.membersSuccesfulAdded(success));
        }
        return result.build();
    }

    public ImmutableMap<PersonId, EntityRecommendationPersonModel> getPersonsAndVisiblities(EntityId entityId, Set<PersonId> personIds) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        ImmutableMap teasers = this._profileTeaserService.getPersonTeasersByIds(personIds, (AuthorizationCheckContextWithLocale)authCtx);
        BasePersonIndependentAuthorizationContext piAuthCtx = authCtx.getPersonIndependentAuthorizationContext();
        ImmutableSet allowed = piAuthCtx.groupByAllowed((ItemId)entityId, (Action)StaticEntityAction.ENTITY_READ_DETAILS, (Iterable)teasers.keySet()).get((Object)Boolean.TRUE);
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)teasers, (Function)new /* Unavailable Anonymous Inner Class!! */));
    }
}

