/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.presentation.server.EntityEditRemoteServiceImpl;
import de.justsoftware.onx.container.presentation.shared.EntityEditRemoteService;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.AbstractEntityEditModel;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityEditRemoteServiceImpl
implements EntityEditRemoteService {
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final EntityService _entityService;
    private final EntityConfigService _entityConfigService;

    @ParametersAreNonnullByDefault
    @Autowired
    public EntityEditRemoteServiceImpl(SessionAuthorizationContextProvider authorizationContextProvider, EntityService entityService, EntityConfigService entityConfigService) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._entityService = entityService;
        this._entityConfigService = entityConfigService;
    }

    public AbstractEntityEditModel getEditModel(EntityId entityId, EditEntityHistoryTokenTabName tab, EntityId currentLayoutEntityId) {
        AuthorizationContext auhtCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this.getEditModel(entityId, tab, auhtCtx);
    }

    @Nonnull
    @VisibleForTesting
    AbstractEntityEditModel getEditModel(@Nonnull EntityId entityId, @Nonnull EditEntityHistoryTokenTabName tab, @Nonnull AuthorizationContext auhtCtx) {
        DBEntity entity = this._entityService.getByIdNotNull(entityId);
        EntityItem entityItem = new EntityItem(entity);
        auhtCtx.check((Item)entityItem, (Action)StaticEntityAction.ENTITY_MODIFY);
        return (AbstractEntityEditModel)tab.accept((EditEntityHistoryTokenTabName.Visitor)new CreateEntityEditModelVisitor(this, entityItem, auhtCtx));
    }

    @Nonnull
    private ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> findPrivacyData(@Nonnull EntityItem entityItem) {
        EntityId entityId = entityItem.getId();
        DBEntity dbEntity = entityItem.getEntity();
        ImmutableList result = this._entityService.getEntityLinkedEntityPrivacies((Map)ImmutableMap.of((Object)entityId, (Object)dbEntity)).get((Object)entityId);
        ImmutableSet entityChildTypes = this._entityConfigService.getAllowedChildrenType(dbEntity.getType());
        if (CollectionUtil.isEmpty((Iterable)entityChildTypes)) {
            return ImmutableMap.of();
        }
        return FluentIterable.from((Iterable)result).filter(Predicates.compose((Predicate)new /* Unavailable Anonymous Inner Class!! */, (Function)DBEntityLinkedEntityPrivacy.GET_AVAILABLE_AUTHORITIES)).filter(Predicates.compose((Predicate)Predicates.in((Collection)entityChildTypes), (Function)DBEntityLinkedEntityPrivacy.GET_ENTITY_TYPE)).uniqueIndex(DBEntityLinkedEntityPrivacy.GET_ENTITY_TYPE);
    }
}

