/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.version;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.gwt.user.client.ui.HasOneWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.container.presentation.client.EntityVersionClientFactory;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionCompareResultInfoView;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityVersionCompareResultInfoPresenter
implements EntityVersionCompareResultInfoView.Presenter {
    private static final String EMPTY_COMPARE_LABEL = "---";
    private final EntityVersionCompareResultInfoView _view;
    private final EntityVersionClientFactory _entityVersionFactory;
    private final DateFormatter _dateFormatter;

    public EntityVersionCompareResultInfoPresenter(@Nonnull ClientFactory clientFactory) {
        this._entityVersionFactory = clientFactory.entityVersionFactory();
        this._dateFormatter = clientFactory.dateFormatter();
        this._view = this._entityVersionFactory.entityVersionCompareInfoView();
    }

    public void show(HasOneWidget parent) {
        this._view.show(parent);
    }

    public void setVersions(EntityVersionClientModel firstVersion, EntityVersionClientModel secondVersion) {
        this._view.getFirstVersionLabel().setText(firstVersion.getVersionString());
        String v1CreationDate = this.formatVersionDate(firstVersion.getCreationDate());
        this._view.getFirstVersionCreationDateLabel().setText(this.getNonEmptyLabel(v1CreationDate));
        boolean needRowForChangeMessages = this.isNeedRowForChangeMessages(firstVersion, secondVersion);
        if (needRowForChangeMessages) {
            this._view.getChangeMessageRow().setVisible(true);
            this._view.getFirstVersionChangeMessageLabel().setText(this.getNonEmptyLabel(firstVersion.getChangeMessage()));
        } else {
            this._view.getChangeMessageRow().setVisible(false);
        }
        boolean needRowForReleaseDate = this.isNeedRowForReleaseDate(firstVersion, secondVersion);
        if (needRowForReleaseDate) {
            this._view.getReleaseDateRow().setVisible(true);
            String v1ReleaseDate = this.formatReleaseDate(firstVersion);
            this._view.getFirstVersionReleaseDateLabel().setText(v1ReleaseDate);
        } else {
            this._view.getReleaseDateRow().setVisible(false);
        }
        boolean needRowForExpirationDate = this.isNeedRowForExpirationDate(firstVersion, secondVersion);
        if (needRowForExpirationDate) {
            this._view.getExpirationDateRow().setVisible(true);
            String formatExpDate = this.formatVersionDate(firstVersion.getExpirationDate());
            this._view.getFirstVersionExpirationDateLabel().setText(this.getNonEmptyLabel(formatExpDate));
        } else {
            this._view.getExpirationDateRow().setVisible(false);
        }
        if (secondVersion != null) {
            this._view.getSecondVersionLabel().setText(secondVersion.getVersionString());
            this._view.getSecondVersionCreationDateLabel().setText(this.getNonEmptyLabel(this.formatVersionDate(secondVersion.getCreationDate())));
            if (needRowForChangeMessages) {
                this._view.getSecondVersionChangeMessageLabel().setText(this.getNonEmptyLabel(secondVersion.getChangeMessage()));
            }
            if (needRowForReleaseDate) {
                this._view.getSecondVersionReleaseDateLabel().setText(this.formatReleaseDate(secondVersion));
            }
            if (needRowForExpirationDate) {
                this._view.getSecondVersionExpirationDateLabel().setText(this.getNonEmptyLabel(this.formatVersionDate(secondVersion.getExpirationDate())));
            }
        } else {
            this._view.clearSecondVersionLabels();
        }
    }

    @Nonnull
    private String formatVersionDate(@Nullable DateWithoutTimezone date) {
        return date != null ? this._dateFormatter.formatDateTime((Date)date) : "";
    }

    @Nonnull
    private String getNonEmptyLabel(@Nullable String label) {
        return ClientStringUtil.hasText((String)label) ? label : EMPTY_COMPARE_LABEL;
    }

    private boolean isNeedRowForChangeMessages(@Nonnull EntityVersionClientModel firstVersion, @Nullable EntityVersionClientModel secondVersion) {
        String v2ChangeMessage;
        boolean resultV1;
        String v1ChangeMessage = firstVersion.getChangeMessage();
        boolean bl = resultV1 = v1ChangeMessage != null && !v1ChangeMessage.isEmpty();
        if (resultV1) {
            return true;
        }
        return secondVersion != null && (v2ChangeMessage = secondVersion.getChangeMessage()) != null && !v2ChangeMessage.isEmpty();
    }

    private boolean isNeedRowForExpirationDate(@Nonnull EntityVersionClientModel firstVersion, @Nullable EntityVersionClientModel secondVersion) {
        return firstVersion.getExpirationDate() != null || secondVersion != null && secondVersion.getExpirationDate() != null;
    }

    private boolean isNeedRowForReleaseDate(@Nonnull EntityVersionClientModel firstVersion, @Nullable EntityVersionClientModel secondVersion) {
        return firstVersion.getReleaseDate() != null || secondVersion != null && secondVersion.getReleaseDate() != null;
    }

    @Nonnull
    private String formatReleaseDate(@Nonnull EntityVersionClientModel version) {
        DateWithoutTimezone releaseDate = version.getReleaseDate();
        return releaseDate != null ? this.formatVersionDate(releaseDate) : EMPTY_COMPARE_LABEL;
    }
}

