/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.jsinterop.Callback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.ui.JustEntityAppWidget;
import de.justsoftware.onx.container.presentation.client.ui.model.SelectedTab;
import de.justsoftware.onx.container.shared.model.EntityId;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsType;

@ParametersAreNonnullByDefault
@JsType(namespace="just.toro", name="EntityComponent")
public class JustEntityComponent {
    final ClientFactory _clientFactory = ClientFactoryImpl.INSTANCE;
    private JustEntityAppWidget _entityWidget;
    private final HTMLPanel _rootPanel;
    private final SimplePanel _contentPanel;

    @JsConstructor
    public JustEntityComponent(Element element) {
        this._rootPanel = HTMLPanel.wrap((Element)element);
        this._rootPanel.clear();
        this._contentPanel = new SimplePanel();
        this._rootPanel.add((Widget)this._contentPanel);
    }

    public void render(String entityIdString, @Nullable String selectedTabString, Callback<String> tabSelectCallback) {
        EntityId entityId = EntityId.parse((String)entityIdString);
        if (entityId == null) {
            return;
        }
        EntityMediator.getInstance().getDetailsById(entityId).then(entityDetails -> {
            SelectedTab selectTab;
            SelectedTab selectedTab = selectTab = selectedTabString != null ? SelectedTab.create((String)selectedTabString) : SelectedTab.create((String)entityDetails.getDefaultTab().getName());
            if (this._entityWidget == null || !((EntityId)this._entityWidget.getCurrentEntity().getId()).equals((Object)entityId)) {
                this._entityWidget = new JustEntityAppWidget((ClientFactory)ClientFactoryImpl.INSTANCE, entityDetails, selectTab, s -> {}, tabSelectCallback);
                this._contentPanel.setWidget((Widget)this._entityWidget);
            } else {
                this._entityWidget.updateEntity(entityDetails, selectTab, null, false);
            }
            return null;
        });
    }

    public void remove() {
        this._rootPanel.clear();
        this._rootPanel.removeFromParent();
    }
}

