/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.google.common.base.Enums;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.i18n.dynamic.client.LocaleInfo;
import de.justsoftware.gwt.jsinterop.Callback;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.WidgetParamUtil;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.presenter.EntityOptionsPresenter;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolder;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolderPanel;
import de.justsoftware.onx.common.presentation.client.ui.ReactBreadcrumbWidget;
import de.justsoftware.onx.common.presentation.client.ui.components.JavascriptAppWidget;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.ComponentTypes;
import de.justsoftware.onx.container.presentation.client.EntityChangedEvent;
import de.justsoftware.onx.container.presentation.client.EntityDeletedOrMemberRoleChangedEvent;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.EntityTitleChangedEvent;
import de.justsoftware.onx.container.presentation.client.EntityVersionChangedEvent;
import de.justsoftware.onx.container.presentation.client.GwtToJsEntityApi;
import de.justsoftware.onx.container.presentation.client.ui.CreateEntityChildrenMenuReactComponent;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityModifyTabContentCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityPrintPreviewAnchor;
import de.justsoftware.onx.container.presentation.client.ui.EntityTabContentCreator;
import de.justsoftware.onx.container.presentation.client.ui.model.SelectedTab;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionComparePageWidget;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDetailsPublicData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityTabVisitor;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.container.shared.model.util.EntityTabUtils;
import de.justsoftware.onx.multiwiki.presentation.client.MultiWikiVersionChangedEvent;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyCreateOrEditWidget;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.wikieditor.presentation.client.WikiEditorMediator;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class JustEntityAppWidget
extends JavascriptAppWidget {
    public static final String ENTITY_VERSION_COMPARE_WIDGET_TYPE = "COMPARE_ENTITY_VERSION";
    public static final String CREATE_SURVEY_WIDGET_TYPE = "CREATE_SURVEY";
    public static final String CONFIG_SURVEY_WIDGET_TYPE = "CONFIG_SURVEY";
    public static final String SURVEY_WIDGET_TYPE = "SURVEY";
    public static final String WIKI_VERSIONS_WIDGET_TYPE = "WIKI_VERSIONS";
    public static final String ALBUM_WIDGET_TYPE = "ALBUM";
    private static final String GWT_WIDGET_TYPE_SEPARATOR = ":";
    private static final String ENTITY_TAB = "ENTITY_TAB";
    private static final String ENTITY_TAB_HEADER = "ENTITY_TAB_HEADER";
    private static final String ENTITY_COMPONENT = "ENTITY_COMPONENT";
    private static final String ENTITY_OPTIONS = "ENTITY_OPTIONS";
    private static final String PRINT_VIEW_ANCHOR = "PRINT_VIEW_ANCHOR";
    private static long _idSequence = 0L;
    private final ClientFactory _clientFactory;
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final Callback<String> _tabSelectCallback;
    @CheckForNull
    private EntityDetails _currentEntity;
    @CheckForNull
    private EntityDetailsPublicData _currentInvisibleEntity;
    private SelectedTab _currentTab;
    private EntityTabContentCreator _tabCreator;
    private EntityModifyTabContentCreator _modifyTabCreator;
    private PageTitleCallback _currentPageTitleCallback;
    private final Map<String, SimplePanel> _gwtWidgets = new HashMap();

    private JustEntityAppWidget(ClientFactory clientFactory, @Nullable EntityDetails entity, EntityDetailsPublicData invisibleEntity, @Nullable SelectedTab selectedTab, PageTitleCallback currentPageTitleCallback, Callback<String> tabSelectCallback) {
        super(JustEntityAppWidget.getEntityApp(), null);
        this._clientFactory = clientFactory;
        this._currentEntity = entity;
        this._currentInvisibleEntity = entity != null ? null : invisibleEntity;
        this._currentTab = selectedTab;
        this._currentPageTitleCallback = currentPageTitleCallback;
        this._tabCreator = entity != null ? new EntityTabContentCreator(entity, this._clientFactory) : null;
        this._eventManagerHelper = new EventManager.EventManagerHelper(this._clientFactory.eventManager());
        this._tabSelectCallback = tabSelectCallback;
        this.setEntityOptions();
    }

    public JustEntityAppWidget(ClientFactory clientFactory, EntityDetailsPublicData entity, PageTitleCallback currentPageTitleCallback) {
        this(clientFactory, null, entity, null, currentPageTitleCallback, null);
    }

    public JustEntityAppWidget(ClientFactory clientFactory, EntityDetails entity, SelectedTab selectedTab, PageTitleCallback currentPageTitleCallback, Callback<String> tabSelectionCallback) {
        this(clientFactory, entity, (EntityDetailsPublicData)entity, selectedTab, currentPageTitleCallback, tabSelectionCallback);
    }

    private void setEntityOptions() {
        JavaScriptObject gwtConfig = JustEntityAppWidget.createGwtConfig((boolean)this._clientFactory.getHostPropertiesBean().isCopyAddressIconActivated());
        this.setOptions(JustEntityAppWidget.getEntityOptions((String)LocaleInfo.getCurrentLocaleName(), (String)((EntityId)this.getCurrentEntity().getId()).asString(), (SelectedTab)this._currentTab, (String)this.getCurrentLayoutEntity(), (JavaScriptObject)gwtConfig, (JavaScriptObject)CreateEntityChildrenMenuReactComponent.CREATE_MENU_GWT_API, (GwtToJsEntityApi)GwtToJsEntityApi.INSTANCE, (JustEntityAppWidget)this));
    }

    private void registerEntityEventListener(EventManager.EventManagerHelper eventManager) {
        eventManager.registerListener(EntityDeletedOrMemberRoleChangedEvent.class, event -> {
            if (!event.isEntityDeleted()) {
                this.refreshViewForEntityId(event.getEntityId());
            }
        });
        eventManager.registerListener(EntityChangedEvent.class, event -> this.refreshViewForEntityId(event.getEntityId()));
        eventManager.registerListener(EntityTitleChangedEvent.class, event -> this.refreshView());
        eventManager.registerListener(EntityVersionChangedEvent.class, event -> this.refreshViewForEntityId(event.getVersion().getEntityId()));
        eventManager.registerListener(MultiWikiVersionChangedEvent.class, event -> this.refreshViewForEntityId(event.getParentId()));
    }

    @Nonnull
    public EntityDetailsPublicData getCurrentEntity() {
        return (EntityDetailsPublicData)MoreObjects.firstNonNull((Object)this._currentEntity, (Object)this._currentInvisibleEntity);
    }

    @Nonnull
    private static String getNextWidgetId(@Nullable String existingId) {
        return (String)MoreObjects.firstNonNull((Object)existingId, (Object)String.valueOf(++_idSequence));
    }

    @CheckForNull
    public String replaceElementWithGWTWidget(@Nullable Element replacement, String type, @Nullable String[] widgetParams, @Nullable String existingId) {
        SimplePanel panel;
        SimplePanel simplePanel = panel = existingId != null ? this._gwtWidgets.getOrDefault(existingId, new SimplePanel()) : new SimplePanel();
        if (replacement != null) {
            this.getContainer().addAndReplaceElement((Widget)panel, replacement);
        }
        return this.setGwtWidgetToPanel(panel, type, widgetParams, existingId);
    }

    @CheckForNull
    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="no default possible or known")
    private String setGwtWidgetToPanel(SimplePanel panel, String type, @Nullable String[] widgetParams, @Nullable String existingId) {
        String id;
        String[] typeParts = type.split(":");
        if (typeParts.length == 1) {
            id = JustEntityAppWidget.getNextWidgetId((String)existingId);
            this.putWidget(id, panel);
            switch (type) {
                case "ENTITY_OPTIONS": {
                    this.handleEntityOptions(panel);
                    break;
                }
                case "PRINT_VIEW_ANCHOR": {
                    this.handlePrintViewAnchor(panel, widgetParams);
                }
            }
        } else if (typeParts.length == 2) {
            String widgetType = typeParts[0];
            id = JustEntityAppWidget.getNextWidgetId((String)existingId);
            this.putWidget(id, panel);
            switch (widgetType) {
                case "ENTITY_TAB": {
                    this.handleEntityTab(panel, typeParts[1], widgetParams);
                    break;
                }
                case "ENTITY_TAB_HEADER": {
                    this.handleEntityTabHeader(panel, typeParts[1], widgetParams);
                    break;
                }
                case "ENTITY_COMPONENT": {
                    this.handleEntityComponent(panel, typeParts[1], widgetParams);
                    break;
                }
                default: {
                    panel.setWidget((Widget)new Label("Not yet..."));
                    break;
                }
            }
        } else {
            id = null;
        }
        return id;
    }

    private void handlePrintViewAnchor(SimplePanel panel, @Nullable String[] widgetParams) {
        if (this._currentEntity == null) {
            return;
        }
        EntityPrintPreviewAnchor.ViewMode viewMode = (EntityPrintPreviewAnchor.ViewMode)WidgetParamUtil.getEnumParam((String[])widgetParams, (int)0, EntityPrintPreviewAnchor.ViewMode.class, (Enum)EntityPrintPreviewAnchor.ViewMode.ICON);
        String classnames = WidgetParamUtil.getStringParamNullable((String[])widgetParams, (int)1);
        panel.setWidget((Widget)new EntityPrintPreviewAnchor(this._currentEntity.getId(), this._clientFactory.eventManager(), viewMode, classnames));
    }

    private void handleCreateSurveyTabHeader(SimplePanel panel, EntityId parentId) {
        ReactBreadcrumbWidget.ReactBreadcrumbWidgetBuilder breadcrumb = new ReactBreadcrumbWidget.ReactBreadcrumbWidgetBuilder();
        breadcrumb.addItem(I18nMediator.SURVEY.surveyOverviewPage(), "#" + EntityOverviewHandler.token((EntityId)parentId, (EntityTab)StaticEntityTab.SURVEYS)).currentItem(I18nMediator.SURVEY.createASurvey());
        panel.setWidget((Widget)breadcrumb.build());
    }

    private void handleConfigSurveyTabHeader(SimplePanel panel, EntityId parentId, SurveyId id) {
        this._clientFactory.surveyClientFactory().controller().getRemoteBySurveyId(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleSurveyDetailsTabHeader(SimplePanel panel, SurveyId id) {
        this._clientFactory.surveyClientFactory().controller().getSurveyDetailsById(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleEntityTabHeader(SimplePanel panel, String widgetType, @Nullable String[] widgetParams) {
        switch (widgetType) {
            case "CREATE_SURVEY": {
                this.handleCreateSurveyTabHeader(panel, (EntityId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)0));
                break;
            }
            case "CONFIG_SURVEY": {
                this.handleConfigSurveyTabHeader(panel, (EntityId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)0), (SurveyId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)1));
                break;
            }
            case "SURVEY": {
                this.handleSurveyDetailsTabHeader(panel, (SurveyId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)0));
                break;
            }
            default: {
                panel.setWidget((Widget)new Label("Not yet..."));
            }
        }
    }

    private void handleEntityOptions(SimplePanel panel) {
        EntityDetails entity;
        Object object = entity = this._currentEntity != null ? this._currentEntity : this._currentInvisibleEntity;
        if (entity != null) {
            EntityVersionClientModel entityVersion = this._currentEntity != null ? this._currentEntity.getVersion() : null;
            EntityOptionsPresenter presenter = this._clientFactory.entityFactory().entityOptionsPresenter();
            panel.setWidget((IsWidget)presenter.getView());
            presenter.showOptionsForEntity((EntityDetailsPublicData)entity, entityVersion);
        }
    }

    private void handleEntityModifyTab(SimplePanel panel, EditEntityHistoryTokenTabName tab) {
        EntityId entityId = (EntityId)this.getCurrentEntity().getId();
        Callback submitCallback = tabName -> {
            String token = tabName != null ? EntityEditHandler.token((HistoryManager)this._clientFactory.historyManager(), (EntityId)entityId, (CoreApp)this._currentEntity.getApp(), (EditEntityHistoryTokenTabName)tabName) : EntityOverviewHandler.token((EntityId)entityId);
            History.newItem((String)token);
        };
        Callback cancelCallback = string -> History.newItem((String)EntityOverviewHandler.token((EntityId)entityId));
        this._clientFactory.entityFactory().entityEditRemoteService().getEditModel(entityId, tab, EntityMediator.getInstance().getCurrentLayoutEntityId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void putWidget(String key, SimplePanel panel) {
        this._gwtWidgets.put(key, panel);
    }

    private void handleEntityComponent(SimplePanel panel, String type, @Nullable String[] widgetParams) {
        if (this._currentEntity == null) {
            return;
        }
        ComponentType componentType = ComponentTypes.valueOf((String)type, widgetParams == null || widgetParams.length == 0 ? null : widgetParams[0]);
        ComponentModel component = (ComponentModel)this._currentEntity.getComponents().get((Object)componentType);
        if (component != null) {
            PlaceHolderPanel placeHolder = new PlaceHolderPanel();
            panel.setWidget((Widget)placeHolder);
            this._clientFactory.componentFactory().replacePlaceHolderWithEntityComponentWidget((PlaceHolder)placeHolder, component, this._currentEntity);
        }
    }

    private void handleEntityTab(SimplePanel panel, String widgetType, @Nullable String[] widgetParams) {
        if (this.handleEntityContentTab(panel, widgetType, widgetParams)) {
            return;
        }
        Optional tab = Enums.getIfPresent(EditEntityHistoryTokenTabName.class, (String)widgetType);
        if (tab.isPresent()) {
            this.handleEntityModifyTab(panel, (EditEntityHistoryTokenTabName)tab.get());
        } else if (this._tabCreator != null) {
            panel.setWidget((IsWidget)EntityTabUtils.fromName((String)widgetType).accept((EntityTabVisitor)this._tabCreator));
        }
    }

    private void addWikiVersionCompareWidget(SimplePanel panel, @Nullable String[] widgetParams) {
        WikiEditorId wikiEditorId = (WikiEditorId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)0);
        WikiVersionId wikiVersionId = (WikiVersionId)WidgetParamUtil.getGlobalIdParamNullable((String[])widgetParams, (int)1);
        WikiEditorMediator.getInstance().getWikiEditorById(wikiEditorId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addCreateSurveyWidget(SimplePanel panel, @Nullable String[] widgetParams) {
        EntityId parentId = (EntityId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)0);
        ClientEntityConfig entityConfig = this._clientFactory.getHostPropertiesBean().getClientEntityConfig((EntityType)this.getCurrentEntity().getType());
        boolean redirectToSurveyOnNewMemberEnabled = entityConfig != null && entityConfig.isRedirectToSurveyOnNewMemberEnabled();
        SurveyCreateOrEditWidget survey = new SurveyCreateOrEditWidget((SurveyId)WidgetParamUtil.getGlobalIdParamNullable((String[])widgetParams, (int)1), (GlobalId)parentId, WidgetParamUtil.getIntParam((String[])widgetParams, (int)2), redirectToSurveyOnNewMemberEnabled, this._currentPageTitleCallback, this._clientFactory);
        panel.setWidget((Widget)survey);
    }

    private void addConfigSurveyWidget(SimplePanel panel, @Nullable String[] widgetParams) {
        SurveyId surveyId = (SurveyId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)1);
        ClientEntityConfig entityConfig = this._clientFactory.getHostPropertiesBean().getClientEntityConfig((EntityType)this.getCurrentEntity().getType());
        boolean redirectToSurveyOnNewMemberEnabled = entityConfig != null && entityConfig.isRedirectToSurveyOnNewMemberEnabled();
        SurveyCreateOrEditWidget cfgSurvey = new SurveyCreateOrEditWidget(surveyId, null, WidgetParamUtil.getIntParam((String[])widgetParams, (int)2), redirectToSurveyOnNewMemberEnabled, this._currentPageTitleCallback, this._clientFactory);
        panel.setWidget((Widget)cfgSurvey);
    }

    private void addSurveyWidget(SimplePanel panel, @Nullable String[] widgetParams) {
        this._clientFactory.surveyClientFactory().controller().getSurveyDetailsById((SurveyId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)0), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean handleEntityContentTab(SimplePanel panel, String widgetType, @Nullable String[] widgetParams) {
        switch (widgetType) {
            case "COMPARE_ENTITY_VERSION": {
                panel.setWidget((Widget)new EntityVersionComparePageWidget(this._clientFactory, (EntityId)WidgetParamUtil.getGlobalIdParam((String[])widgetParams, (int)0), this._currentPageTitleCallback));
                return true;
            }
            case "CREATE_SURVEY": {
                this.addCreateSurveyWidget(panel, widgetParams);
                return true;
            }
            case "CONFIG_SURVEY": {
                this.addConfigSurveyWidget(panel, widgetParams);
                return true;
            }
            case "SURVEY": {
                this.addSurveyWidget(panel, widgetParams);
                return true;
            }
            case "WIKI_VERSIONS": {
                this.addWikiVersionCompareWidget(panel, widgetParams);
                return true;
            }
        }
        return false;
    }

    public void updateEntity(EntityDetailsPublicData entity) {
        EntityInfo oldEntity = (EntityInfo)MoreObjects.firstNonNull((Object)this._currentEntity, (Object)this._currentInvisibleEntity);
        EntityId oldId = (EntityId)oldEntity.getId();
        this._currentEntity = null;
        this._currentInvisibleEntity = entity;
        this.updateView((EntityId)entity.getId(), oldId, this._currentTab, true);
    }

    public void updateEntity(EntityDetails entity, @Nullable SelectedTab selectedTab, PageTitleCallback currentPageTitleCallback, boolean forceUpdate) {
        EntityInfo oldEntity = (EntityInfo)MoreObjects.firstNonNull((Object)this._currentEntity, (Object)this._currentInvisibleEntity);
        EntityId oldId = (EntityId)oldEntity.getId();
        boolean visibilityChanged = this._currentInvisibleEntity != null;
        this._currentPageTitleCallback = currentPageTitleCallback;
        this._currentEntity = entity;
        this._currentInvisibleEntity = null;
        this.updateView(entity.getId(), oldId, selectedTab, forceUpdate || visibilityChanged);
    }

    private void refreshViewForEntityId(EntityId entityId) {
        if (((EntityId)this.getCurrentEntity().getId()).equals((Object)entityId)) {
            this.refreshView();
        }
    }

    private void refreshView() {
        this._clientFactory.entityFactory().controller().getDetailsById((EntityId)this.getCurrentEntity().getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateView(EntityId newId, EntityId oldId, @Nullable SelectedTab selectedTab, boolean forceUpdate) {
        boolean entityChanged = !Objects.equal((Object)newId, (Object)oldId);
        boolean tabChanged = !SelectedTab.equal((SelectedTab)selectedTab, (SelectedTab)this._currentTab);
        this._currentTab = selectedTab;
        this.setEntityOptions();
        if (this._tabCreator == null || entityChanged) {
            this._tabCreator = this._currentEntity != null ? new EntityTabContentCreator(this._currentEntity, this._clientFactory) : null;
        } else if (this._currentEntity != null) {
            this._tabCreator.setEntity(this._currentEntity);
        }
        JavaScriptObject javascriptAppInstance = this.getJavascriptAppInstance();
        if (entityChanged || forceUpdate) {
            this.updatePageTitle();
            if (javascriptAppInstance != null) {
                JustEntityAppWidget.setEntity((JavaScriptObject)javascriptAppInstance, (String)newId.asString(), (SelectedTab)selectedTab, (String)this.getCurrentLayoutEntity());
            }
        } else if (tabChanged && javascriptAppInstance != null) {
            JustEntityAppWidget.setSelectedTab((JavaScriptObject)javascriptAppInstance, (SelectedTab)this._currentTab);
        }
    }

    private void updatePageTitle() {
        EntityType currentEntityType = (EntityType)this.getCurrentEntity().getType();
        String currentEntityName = this.getCurrentEntity().getName();
        String translatedType = this._clientFactory.entityFactory().entityConstants(currentEntityType).entity(currentEntityType);
        String pageTitle = this._clientFactory.entityFactory().entityMessages(currentEntityType).entityPageTitle(currentEntityName, translatedType);
        this._clientFactory.pageTitleService().setPageTitle(pageTitle);
    }

    protected void onLoad() {
        super.onLoad();
        this.registerEntityEventListener(this._eventManagerHelper);
    }

    protected void onUnload() {
        this.removeGwtWidgets();
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
        super.onUnload();
    }

    public void removeGwtWidgetById(String id) {
        if (this._gwtWidgets.isEmpty()) {
            return;
        }
        SimplePanel panel = (SimplePanel)this._gwtWidgets.get(id);
        if (panel != null) {
            panel.clear();
            panel.removeFromParent();
        }
        this._gwtWidgets.remove(id);
    }

    private void removeGwtWidgets() {
        if (this._gwtWidgets.isEmpty()) {
            return;
        }
        this._gwtWidgets.values().forEach(panel -> {
            if (panel != null) {
                panel.clear();
                panel.removeFromParent();
            }
        });
        this._gwtWidgets.clear();
    }

    public void gotoTab(String tab, boolean clearCache) {
        if (this._tabSelectCallback != null) {
            this._tabSelectCallback.call((Object)tab);
        }
    }

    public void gotoHistoryToken(String tokenWithParams, boolean clearCache) {
        History.newItem((String)tokenWithParams);
    }

    public void updateEntityTitle(String title, @Nullable JavaScriptObject onSuccess, @Nullable JavaScriptObject onError) {
        EntityDetailsPublicData currentEntity = this.getCurrentEntity();
        EntityTitleChangedEvent entityTitleChangedEvent = new EntityTitleChangedEvent(title, (EntityType)currentEntity.getType());
        this._clientFactory.entityFactory().controller().updateEntityTitle((EntityId)currentEntity.getId(), title, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @CheckForNull
    private String getCurrentLayoutEntity() {
        EntityId layoutEntity = this._clientFactory.entityFactory().getCurrentLayoutEntityId();
        return layoutEntity == null ? null : layoutEntity.asString();
    }

    @Nonnull
    public String getTokenForEntity(String entityId) {
        EntityId parsedChannelId = EntityId.parse((String)entityId);
        if (parsedChannelId != null) {
            return EntityOverviewHandler.token((EntityId)parsedChannelId);
        }
        return "";
    }

    public static native void callJsFunction(@Nullable JavaScriptObject var0);

    private static native void setSelectedTab(JavaScriptObject var0, SelectedTab var1);

    private static native void setEntity(JavaScriptObject var0, String var1, SelectedTab var2, String var3);

    @Nonnull
    private static native JavaScriptObject createGwtConfig(boolean var0);

    @Nonnull
    public static native JavaScriptObject getEntityApp();

    public static native void scrollElementIntoViewTopAligned(Element var0);

    @Nonnull
    private static native JavaScriptObject getEntityOptions(String var0, String var1, @Nullable SelectedTab var2, @Nullable String var3, JavaScriptObject var4, JavaScriptObject var5, GwtToJsEntityApi var6, JustEntityAppWidget var7);
}

