/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.container.presentation.client.EntityChangedEvent;
import de.justsoftware.onx.container.presentation.client.presenter.InformationTabPresenter;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityTabVisitor;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.drive.presentation.client.JustDriveFolderApp;
import de.justsoftware.onx.survey.presentation.client.ui.presenters.SurveyListPresenter;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityTabContentCreator
implements EntityTabVisitor<IsWidget> {
    private EntityDetails _entity;
    private final ClientFactory _clientFactory;
    private JustDriveFolderApp _driveApp;

    public EntityTabContentCreator(EntityDetails entity, ClientFactory clientFactory) {
        this._entity = entity;
        this._clientFactory = clientFactory;
    }

    public IsWidget visitChildEntities(EntityType entityType) {
        return new FlowPanel();
    }

    public IsWidget visitSurveys() {
        SurveyListPresenter presenter = new SurveyListPresenter(this._entity.getId(), this._clientFactory.surveyClientFactory(), this._clientFactory.surveyClientFactory().i18nConstants());
        return presenter.getView();
    }

    public IsWidget visitMember() {
        return new FlowPanel();
    }

    @Nonnull
    private IsWidget getNoResultViewEvents(EntityType entityType) {
        return new FlowPanel();
    }

    public IsWidget visitDashboard() {
        return new FlowPanel();
    }

    public IsWidget visitInformation() {
        return new InformationTabPresenter(this._clientFactory, this._entity).getView();
    }

    public IsWidget visitHierarchy() {
        return new FlowPanel();
    }

    public IsWidget visitDocuments() {
        EntityId entityId = this._entity.getId();
        if (this._driveApp == null || !this._driveApp.getRootItemId().equals((Object)entityId)) {
            CoreApp app = this._entity.getApp();
            String historyBaseName = EntityOverviewHandler.token((EntityId)entityId, (EntityTab)StaticEntityTab.DOCUMENTS);
            this._driveApp = new JustDriveFolderApp(app, (GlobalId)entityId, historyBaseName, () -> this._clientFactory.eventManager().handleEvent((ClientEvent)new EntityChangedEvent(this._entity.getId(), this._entity.getType())));
        }
        return this._driveApp;
    }

    public IsWidget visitSeparator() {
        throw new UnsupportedOperationException();
    }

    public IsWidget visitPrintPreview() {
        throw new UnsupportedOperationException();
    }

    public IsWidget visitArchivedContent() {
        throw new UnsupportedOperationException();
    }

    public void setEntity(EntityDetails entity) {
        this._entity = entity;
    }
}

