/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.HistoryItemHandler;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.client.mediator.HistoryTokenState;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.FoldUtil;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.presentation.client.ui.WidgetPartOfEntityHistoryItemHandler;
import de.justsoftware.onx.container.presentation.client.ui.model.SelectedTab;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.util.EntityTabUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public final class EntityOverviewHandler
extends WidgetPartOfEntityHistoryItemHandler {
    private static final int INDEX_ENTITY_ID = 0;
    private static final int INDEX_SELECTED_TAB_ID = 1;
    private static final int INDEX_FILTER_TYPE_ID = 2;
    private static final int INDEX_SEARCH_STRING = 3;
    private static final int INDEX_SORT_TYPE_ID = 4;
    private static final int INDEX_SUBFILTER = 5;
    private static final int INDEX_CONTEXT_ID = 6;
    private static final int INDEX_CONTEXT_HIERARCHY = 7;
    private static final int NUMBER_OF_PARAMS_FOR_SEARCH = 8;
    private static final String TYPES = "LSSSLSLS";
    private static final String CONTEXT_HIERARCHY_DELIMITER = "-";

    public EntityOverviewHandler(ClientFactory clientFactory) {
        super(clientFactory);
    }

    @Nonnull
    private static Object[] toParamArray(EntityId entityId, @Nullable EntityTab selectedTab) {
        return new Object[]{entityId, selectedTab != null ? selectedTab.getName() : null, null, null, null, null, entityId, null};
    }

    @CheckForNull
    private static EntityTab parseSelectedTab(List<?> params) {
        if (CollectionUtil.isEmpty(params) || params.size() < 2 || params.get(1) == null) {
            return null;
        }
        String tabParam = (String)params.get(1);
        return !StringUtil.isBlank((String)tabParam) ? EntityTabUtils.fromName((String)tabParam) : null;
    }

    @CheckForNull
    private ImmutableList<EntityId> parseContextHierarchy(List<?> params) {
        if (CollectionUtil.isEmpty(params) || params.size() < 7) {
            return null;
        }
        String contextHierarchyParam = (String)params.get(7);
        if (StringUtil.isEmpty((String)contextHierarchyParam)) {
            return null;
        }
        String[] paramsSplit = contextHierarchyParam.split("-");
        return FluentIterable.from(Arrays.asList(paramsSplit)).transform((Function)new /* Unavailable Anonymous Inner Class!! */).filter(Predicates.notNull()).toList();
    }

    @CheckForNull
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="its wanted here")
    public EntityTabWidgetContext getEntityTabWidgetContext(TokenUtil.TokenIdAndParams tokenIdAndParams) {
        try {
            EntityId entityId = new EntityId(tokenIdAndParams.longParam(0));
            EntityTab parsedTab = EntityOverviewHandler.parseSelectedTab((List)tokenIdAndParams.getParams());
            if (parsedTab == null) {
                return null;
            }
            ImmutableList contextHierarchy = this.parseContextHierarchy(tokenIdAndParams.getParams());
            return new EntityTabWidgetContext(entityId, parsedTab, contextHierarchy != null ? contextHierarchy : ImmutableList.of());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void createWidget(ClientFactory clientFactory, HistoryTokenState state, HistoryItemHandler.WidgetCreatedCallback callback, PageTitleCallback titleCallback) {
        new CreateWidgetAsyncCallback(this, state, titleCallback, callback).onSuccess();
    }

    private void createEntityOverview(HistoryItemHandler.WidgetCreatedCallback callback, EntityDetails entity, EntityTab selectedTab, PageTitleCallback titleCallback) {
        callback.onWidgetCreated((IsWidget)this._clientFactory.entityFactory().getJustEntityAppPage(entity, SelectedTab.create((String)selectedTab.getName()), titleCallback));
    }

    public Object[] getDefaultParams() {
        return new Object[]{null, null, null, null, null, null, null, null};
    }

    public String getParamTypes() {
        return "LSSSLSLS";
    }

    public void getItemIdOfWidget(List<?> params, AsyncCallback<GlobalId> callback) {
        callback.onSuccess((Object)new EntityId(((Long)params.get(0)).longValue()));
    }

    @Nonnull
    public static String token(EntityId id) {
        return EntityOverviewHandler.token((HistoryManager)ClientFactoryImpl.INSTANCE.historyManager(), (EntityId)id);
    }

    @Nonnull
    public static String token(HistoryManager historyManager, EntityId id) {
        return historyManager.createHistoryItem(HistoryToken.ENTITY, new Object[]{id});
    }

    @Nonnull
    public static String token(EntityId id, EntityTab selectedTab) {
        return ClientFactoryImpl.INSTANCE.historyManager().createHistoryItem(HistoryToken.ENTITY, EntityOverviewHandler.toParamArray((EntityId)id, (EntityTab)selectedTab));
    }

    public void needsReloadWhenHashChanged(HistoryTokenState state, HistoryItemHandler.NeedsReloadWhenHashChangedCallback callback) {
        String hash = state.getTokenIdAndParams().getHash();
        if (StringUtil.isBlank((String)hash)) {
            callback.reload();
        } else {
            AnchorElement anchor = null;
            NodeList nodeList = Document.get().getElementsByTagName("a");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                AnchorElement anchorElement = AnchorElement.as((Element)((Element)nodeList.getItem(i)));
                if (!hash.equals(anchorElement.getName())) continue;
                anchor = anchorElement;
            }
            if (anchor != null) {
                FoldUtil.openParents(anchor);
                callback.scrollToElement(anchor);
            } else {
                callback.reload();
            }
        }
    }
}

