/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.components.HasRows;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.presentation.client.ui.EntityBaseDataClientFactory;
import de.justsoftware.onx.container.presentation.client.ui.EntityInformationAdminData;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDynamicAttributeClientModel;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.IEntityDynamicAttribute;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityBaseDataWidgetBuilder {
    private static final String VALUE_SEPERATOR = ", ";
    private static final String MULTILINE_VALUE_SEPERATOR = ",\n";
    private final EntityConstants _entityConstants;
    private final ClientFactory _clientFactory;
    private final EntityDetails _entity;
    private final HasRows _rows;
    private final EntityBaseDataClientFactory _widgetFactory;

    public EntityBaseDataWidgetBuilder(ClientFactory clientFactory, EntityConstants entityConstants, EntityDetails entity, HasWidgets.ForIsWidget container) {
        this._entityConstants = entityConstants;
        this._entity = entity;
        this._widgetFactory = clientFactory.entityTabClientFactory().entityBaseDataClientFactory();
        this._rows = this._widgetFactory.createRows(container);
        this._clientFactory = clientFactory;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addDurationRow() {
        DateWithoutTimezone startAt = this._entity.getStartAt();
        DateWithoutTimezone endAt = this._entity.getEndAt();
        if (startAt != null && endAt != null) {
            IsWidget duration = this._widgetFactory.createLabel(Dates.formatDuration((DateFormatter)this._clientFactory.dateFormatter(), (Date)startAt, (Date)endAt, (TimeZone)this._entity.getTimeZone()));
            this._rows.addLabeledRow(this._entityConstants.duration(), new IsWidget[]{duration, this._widgetFactory.createIcsExportLink((EntityInfo)this._entity)});
        }
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addEventRow() {
        DateWithoutTimezone startAt = this._entity.getStartAt();
        DateWithoutTimezone endAt = this._entity.getEndAt();
        if (startAt != null && endAt != null) {
            ArrayList<IsWidget> widgets = new ArrayList<IsWidget>();
            widgets.add(this._widgetFactory.createEventRow(IconType.TIME, Dates.formatDuration((DateFormatter)this._clientFactory.dateFormatter(), (Date)startAt, (Date)endAt, (TimeZone)this._entity.getTimeZone()), this._entityConstants.duration()));
            widgets.add(this._widgetFactory.createIcsExportLink((EntityInfo)this._entity));
            this._rows.addRow(widgets);
            String location = this._entity.getLocation();
            if (ClientStringUtil.hasText((String)location)) {
                this._rows.addRow((Iterable)ImmutableList.of((Object)this._widgetFactory.createEventRow(IconType.MAP_MARKER, location, this._entityConstants.location())));
            }
        }
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addClosingDateRow() {
        Date closingDate = this._entity.getClosingDate();
        if (closingDate != null) {
            this._rows.addLabeledRow(this._entityConstants.closingDate(), new IsWidget[]{this._widgetFactory.createLabel(this._clientFactory.dateFormatter().formatDateTime(closingDate))});
        }
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addTagRow() {
        if (ClientStringUtil.hasText((String)this._entity.getTags()) && this.getClientEntityConfig().isTagsEnabled()) {
            this._rows.addLabeledRow(this._entityConstants.tags(), new IsWidget[]{new FlowPanel()});
        }
        return this;
    }

    @Nonnull
    private ClientEntityConfig getClientEntityConfig() {
        return this._clientFactory.entityFactory().entityConfig(this._entity.getType());
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addAssignedEntitiesRow() {
        ImmutableList linkedEntities = this._entity.getLinkedEntities();
        if (!CollectionUtil.isEmpty((Iterable)linkedEntities)) {
            this._rows.addLabeledRow(this._entityConstants.assignedToEntites(), new IsWidget[]{this._widgetFactory.createEntityNameLinksOrLables((Iterable)linkedEntities)});
        }
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addLocationRow() {
        String location = this._entity.getLocation();
        if (ClientStringUtil.hasText((String)location)) {
            this._rows.addLabeledRow(this._entityConstants.location(), new IsWidget[]{this._widgetFactory.createLabel(location)});
        }
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addDynamicAttributes() {
        ImmutableList attributes = this._entity.getDBEntity().getDynamicAttributes();
        if (!attributes.isEmpty()) {
            ImmutableMap valueMap = Maps.uniqueIndex((Iterable)attributes, (Function)IEntityDynamicAttribute.TO_ATTRIBUTE_ID);
            ImmutableList configList = this.getClientEntityConfig().getDynamicAttributesConfig();
            for (DynamicAttributeConfig config : configList) {
                EntityDynamicAttributeClientModel attribute = (EntityDynamicAttributeClientModel)valueMap.get((Object)config.getId());
                if (attribute == null || attribute.getValues().isEmpty()) continue;
                this.addDynamicAttributeRow(config, attribute);
            }
        }
        return this;
    }

    private void addDynamicAttributeRow(DynamicAttributeConfig config, EntityDynamicAttributeClientModel attribute) {
        this._clientFactory.entityFactory().withDynamicAttributeMessages(this._entity.getType(), attribute.getAttributeId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addEntityTypeRow() {
        this._rows.addLabeledRow(this._entityConstants.entityType(), new IsWidget[]{this._widgetFactory.createLabel(this._entityConstants.entity(this._entity.getType()))});
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addVisitsRow(IsWidget widget) {
        this._rows.addLabeledRow(this._entityConstants.numberOfVisits(), new IsWidget[]{widget});
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addFollowersRow(IsWidget widget) {
        this._rows.addLabeledRow(this._entityConstants.numberOfFollowers(), new IsWidget[]{widget});
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addAdmins(EntityInformationAdminData.Presenter presenter) {
        presenter.handleVisibilityOfAdminRow(this._rows.addLabeledRow(this._entityConstants.admin(), new IsWidget[]{presenter.getAdminView()}));
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addCoAdmins(EntityInformationAdminData.Presenter presenter) {
        presenter.handleVisibilityOfCoAdminRow(this._rows.addLabeledRow(this._entityConstants.coAdmins(), new IsWidget[]{presenter.getCoAdminView()}));
        return this;
    }

    @Nonnull
    public EntityBaseDataWidgetBuilder addInheritedCoAdmins(EntityInformationAdminData.Presenter presenter) {
        presenter.handleVisibilityOfInheritedCoAdminRow(this._rows.addLabeledRow(this._entityConstants.inheritedAdmins(), new IsWidget[]{presenter.getInheritedCoAdminView()}));
        return this;
    }
}

