/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client;

import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.presentation.client.model.JsPromise;
import de.justsoftware.onx.common.presentation.client.model.Promise;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.Person;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.VisibleActionSet;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.presentation.client.EntityDeletedOrMemberRoleChangedEvent;
import de.justsoftware.onx.container.presentation.client.EntityMemberClientService;
import de.justsoftware.onx.container.presentation.client.EntityMemberClientServiceImpl;
import de.justsoftware.onx.container.presentation.shared.EntityMemberController;
import de.justsoftware.onx.container.presentation.shared.EntityMemberControllerAsync;
import de.justsoftware.onx.container.presentation.shared.MemberWorkflowMigrationOption;
import de.justsoftware.onx.container.presentation.shared.model.EventMembershipChangeResult;
import de.justsoftware.onx.container.shared.model.EntityAdminTransferModel;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberConfiguratorInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberPagerParams;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMembership;
import de.justsoftware.onx.container.shared.model.EntityMembershipInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.FailedAndSuccessfulActionsDetails;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.InvitationResultKey;
import de.justsoftware.onx.container.shared.model.JoinChildEntityViewData;
import de.justsoftware.onx.container.shared.model.MakeCoAdminStatusKey;
import de.justsoftware.onx.container.shared.model.MyMemberStatus;
import de.justsoftware.onx.container.shared.model.RoleOrInheritedRole;
import de.justsoftware.onx.container.shared.model.db.EmailModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.Set;
import javax.annotation.Nullable;

public final class EntityMemberClientServiceImpl
implements EntityMemberClientService {
    private final EntityMemberControllerAsync _service = (EntityMemberControllerAsync)GWT.create(EntityMemberController.class);

    public EntityMemberClientServiceImpl() {
        UrlUtil.setRemoteServiceUrl((Object)this._service, (String)"/entityMember");
    }

    public void getRandomMembers(EntityId id, AsyncCallback<ImmutableList<PersonTeaserModel>> callback) {
        this._service.getRandomMembers(id, callback);
    }

    public void getEntityMembersByFilter(EntityId entityId, RoleOrInheritedRole role, String filter, int offset, int limit, AsyncCallback<ListAndCount<EntityMembership>> callback) {
        this._service.getEntityMembersByFilter(entityId, role, filter, offset, limit, callback);
    }

    public void getEntityMemberConfiguratorInfo(EntityId id, ImmutableMap<RoleOrInheritedRole, EntityMemberPagerParams> params, AsyncCallback<EntityMemberConfiguratorInfo> callback) {
        this._service.getEntityMemberConfiguratorInfo(id, params, callback);
    }

    public void deleteCoAdmins(EntityId entityId, EntityType entityType, ImmutableSet<PersonId> persons, AsyncCallback<Void> callback) {
        this._service.deleteCoAdmins(entityId, persons, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void removeMembersFromEntity(EntityId entityId, EntityType entityType, ImmutableSet<PersonId> persons, AsyncCallback<Void> callback) {
        this._service.removeMembersFromEntity(entityId, persons, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void makeAdmin(EntityId id, EntityType entityType, PersonId personId, AsyncCallback<Void> callback) {
        this._service.makeAdmin(id, personId, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(id, entityType, false), callback));
    }

    public void makeCoAdminWithMeAsAdminFallback(EntityId entityId, EntityType entityType, ImmutableSet<PersonId> newCoAdmins, AsyncCallback<Void> callback) {
        this._service.makeCoAdminWithMeAsAdminFallback(entityId, newCoAdmins, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void makeCoAdmins(EntityId id, EntityType entityType, Set<PersonId> personIds, AsyncCallback<FailedAndSuccessfulActionsDetails<EntityId, ImmutableMap<MakeCoAdminStatusKey, Integer>>> callback) {
        this._service.makeCoAdmins(id, personIds, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(id, entityType, false), callback));
    }

    public Promise<Void, Throwable> deleteJoinRequest(EntityId id, EntityType entityType) {
        return JsPromise.create((resolve, reject) -> this._service.deleteJoinRequest(id, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(id, entityType, false), JsPromise.createPromiseAsyncCallback((JsPromise.JsExecutorCallbackFunction)resolve, (JsPromise.JsExecutorCallbackFunction)reject))));
    }

    public void joinEntity(EntityId id, EntityType entityType, AsyncCallback<EntityInfo> callback) {
        this._service.joinEntity(id, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(id, entityType, false), callback));
    }

    public void leaveEntity(EntityId id, EntityType entityType, AsyncCallback<Void> callback) {
        this._service.leaveEntity(id, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(id, entityType, false), callback));
    }

    public void inviteAllSelectedPersonsToEntity(ImmutableSet<Person> selectedPersons, EntityId entityId, EntityType entityType, String inviteMessage, ImmutableSet<ComponentType> selectedEditorTypes, AsyncCallback<FailedAndSuccessfulActionsDetails<EntityId, ImmutableMap<InvitationResultKey, String>>> callback) {
        this._service.inviteAllSelectedPersonsToEntity(selectedPersons, entityId, inviteMessage, selectedEditorTypes, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void inviteAllSelectedPersonsToEntities(ImmutableSet<Person> selectedPersons, ImmutableSet<EntityId> entityId, String inviteMessage, @Nullable EntityType type, AsyncCallback<FailedAndSuccessfulActionsDetails<EntityId, ImmutableMap<InvitationResultKey, String>>> callback) {
        this._service.inviteAllSelectedPersonsToEntities(selectedPersons, entityId, inviteMessage, type, callback);
    }

    public void acceptInvitation(EntityId id, EntityType entityType, AsyncCallback<Void> callback) {
        this._service.acceptInvitation(id, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(id, entityType, false), callback));
    }

    public void acceptJoinRequest(PersonId memberId, EntityId entityId, EntityType entityType, AsyncCallback<Void> callback) {
        this._service.acceptJoinRequest(memberId, entityId, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void declineJoinRequest(PersonId memberId, EntityId entityId, EntityType entityType, AsyncCallback<Void> callback) {
        this._service.declineJoinRequest(memberId, entityId, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void getMyMemberStatus(EntityId entityId, AsyncCallback<MyMemberStatus> callback) {
        this._service.getMyMemberStatus(entityId, callback);
    }

    public void sendMessageToEntityMembers(EntityId entityId, ImmutableSet<EntityMemberRole> toMemberOfRoles, String subject, String message, AsyncCallback<Void> callback) {
        this._service.sendMessageToEntityMembers(entityId, toMemberOfRoles, subject, message, callback);
    }

    public void getEntityMemberSizeByStatusAndRole(EntityId id, AsyncCallback<ImmutableMultiset<EntityMemberRole>> callback) {
        this._service.getEntityMemberSizeByStatusAndRole(id, callback);
    }

    public void getJoinChildEntityViewData(EntityId entityId, EntityType entityTypeOfMembership, int offset, int limit, AsyncCallback<JoinChildEntityViewData> callback) {
        this._service.getJoinChildEntityViewData(entityId, entityTypeOfMembership, offset, limit, callback);
    }

    public void getEntityMembershipInfo(EntityId id, AsyncCallback<EntityMembershipInfo> callback) {
        this._service.getEntityMembershipInfo(id, callback);
    }

    public void joinOrDisjoinEntityAndReturnEntityMembershipInfo(EntityId id, AsyncCallback<EntityMembershipInfo> callback) {
        this._service.joinOrDisjoinEntityAndReturnEntityMembershipInfo(id, callback);
    }

    public void getAdminsByEntityId(EntityId entityId, int offset, int limit, AsyncCallback<ListAndCount<PersonTeaserModel>> callback) {
        this._service.getAdminsByEntityId(entityId, offset, limit, callback);
    }

    public void getEntityAdminTransferModel(String password, AsyncCallback<EntityAdminTransferModel> callback) {
        this._service.getEntityAdminTransferModel(password, callback);
    }

    public void getEntityAdminTransferModel(PersonId personId, AsyncCallback<EntityAdminTransferModel> callback) {
        this._service.getEntityAdminTransferModel(personId, callback);
    }

    public void getEmailModelForFeedbackEmailToAdmins(EntityId entityId, AsyncCallback<EmailModel> callback) {
        this._service.getEmailModelForFeedbackEmailToAdmins(entityId, callback);
    }

    public void getInheritPersons(EntityId entityId, InheritsRole inheritsRole, boolean activeOnly, int offset, int limit, AsyncCallback<ListAndCount<PersonTeaserModel>> callback) {
        this._service.getInheritPersons(entityId, inheritsRole, activeOnly, offset, limit, callback);
    }

    public void eventAttend(EntityId entityId, EntityType entityType, VisibleActionSet actionSet, AsyncCallback<EventMembershipChangeResult> callback) {
        this._service.eventAttend(entityId, actionSet, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void eventDontAttend(EntityId entityId, EntityType entityType, VisibleActionSet actionSet, AsyncCallback<EventMembershipChangeResult> callback) {
        this._service.eventDontAttend(entityId, actionSet, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void eventMaybeAttend(EntityId entityId, EntityType entityType, VisibleActionSet actionSet, AsyncCallback<EventMembershipChangeResult> callback) {
        this._service.eventMaybeAttend(entityId, actionSet, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void eventLeave(EntityId entityId, EntityType entityType, VisibleActionSet actionSet, AsyncCallback<EventMembershipChangeResult> callback) {
        this._service.eventLeave(entityId, actionSet, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void eventMovePersonsToList(EntityId entityId, EntityType entityType, ImmutableSet<PersonId> persons, EntityMemberRole statusToAssign, AsyncCallback<Void> callback) {
        this._service.eventMovePersonsToList(entityId, persons, statusToAssign, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void eventRemovePersonsFromEvent(EntityId entityId, EntityType entityType, Set<PersonId> personIds, AsyncCallback<Void> callback) {
        this._service.eventRemovePersonsFromEvent(entityId, personIds, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void rejectInvitation(EntityId entityId, EntityType entityType, VisibleActionSet actionSet, AsyncCallback<EventMembershipChangeResult> callback) {
        this._service.rejectInvitation(entityId, actionSet, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void moveToMemberList(EntityId entityId, EntityType entityType, Set<PersonId> persons, AsyncCallback<Void> callback) {
        this._service.moveToMemberList(entityId, persons, (AsyncCallback)new FireEventAsyncCallbackWrapper((ClientEvent)new EntityDeletedOrMemberRoleChangedEvent(entityId, entityType, false), callback));
    }

    public void migrateEntityWorkflowMemberRolesFor(ImmutableSet<EntityType> entityTypes, MemberWorkflowMigrationOption migrationOption, AsyncCallback<Void> callback) {
        this._service.migrateEntityWorkflowMemberRolesFor(entityTypes, migrationOption, callback);
    }

    public void getAllEntityAdmins(EntityId entityId, AsyncCallback<ImmutableListMultimap<RoleOrInheritedRole, EntityMembership>> callback) {
        this._service.getAllEntityAdmins(entityId, callback);
    }

    public void getAllEntityMemberIds(EntityId id, AsyncCallback<ImmutableSet<PersonId>> asyncCallback) {
        this._service.getAllEntityMemberIds(id, asyncCallback);
    }
}

