/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@ParametersAreNonnullByDefault
public class CKEditorController {
    private static final ImmutableList<String> SEARCH_PATHS = ImmutableList.of((Object)"ckeditor", (Object)"juco_ckeditor", (Object)"orig_ckeditor/ckeditor");

    @RequestMapping(value={"/ckeditor/**"})
    public void ckeditor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getServletPath();
        if (!path.startsWith("/ckeditor")) {
            response.sendError(404);
            return;
        }
        String localPath = path.substring("/ckeditor".length());
        ServletContext servletContext = request.getServletContext();
        String mimeType = (String)MoreObjects.firstNonNull((Object)servletContext.getMimeType(path), (Object)"application/octet-stream");
        response.setContentType(mimeType);
        for (String pathPrefix : SEARCH_PATHS) {
            URL resource = this.getClass().getClassLoader().getResource(pathPrefix + localPath);
            if (resource == null) continue;
            IOUtils.copy((InputStream)resource.openStream(), (OutputStream)response.getOutputStream());
            return;
        }
        response.sendError(404);
    }
}

