/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.editor;

import de.justsoftware.onx.common.presentation.client.ui.editor.LockOwner;
import de.justsoftware.onx.logging.client.ClientLogger;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class LockManager {
    private boolean _locked = false;
    private LockOwner _lockOwner;
    private final ClientLogger _logger;

    public LockManager(ClientLogger logger) {
        this._logger = logger;
    }

    public synchronized boolean requestLock(LockOwner requestingOwner) {
        if (!this._locked) {
            this._logger.info((Object)this, "lock request for " + String.valueOf(requestingOwner) + " is granted");
            this._locked = true;
            this._lockOwner = requestingOwner;
            return true;
        }
        boolean res = this._lockOwner == requestingOwner;
        this._logger.info((Object)this, "lock request for " + String.valueOf(requestingOwner) + " is" + (String)(res ? "granted" : " not granted because " + String.valueOf(this._lockOwner) + " owns the lock"));
        return res;
    }

    public synchronized void freeLock(LockOwner requestingOwner) {
        this._logger.info((Object)this, "Freeing lock for " + String.valueOf(requestingOwner));
        if (this._locked && this._lockOwner == requestingOwner) {
            this._locked = false;
            this._lockOwner = null;
        }
    }

    public synchronized boolean isAquiredByOwner(LockOwner owner) {
        return this._lockOwner == owner;
    }
}

