/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.components;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.base.InlineLabel;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Strings;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.JucoTooltip;
import de.justsoftware.onx.common.presentation.client.ui.InlineCheckBox;
import de.justsoftware.onx.common.presentation.client.ui.PopupCloseHelper;
import de.justsoftware.onx.common.presentation.client.ui.components.AbstractInlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.InlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.components.MultipleOptionsInlineEditView;
import de.justsoftware.onx.common.presentation.client.ui.impl.PopupCloseHelperImpl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CheckboxListInlineEditView
extends AbstractInlineEditView
implements MultipleOptionsInlineEditView {
    private String _currentLabel = "";
    private final InlineLabel _editorLabel = new InlineLabel();
    private final FlowPanel _optionsContainer = new FlowPanel();
    private final PopupCloseHelper _closeHelper = new PopupCloseHelperImpl();

    public CheckboxListInlineEditView(InlineEditView.Presenter presenter, boolean showInlineEditButtons) {
        super(presenter, showInlineEditButtons);
        this.addStyleName("inline-edit-checkboxes");
        this._closeHelper.ignoreElement((Element)this.asWidget().getElement());
        this._closeHelper.setHandler((PopupCloseHelper.ClosePopupClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.initEditorPanel();
    }

    public void showLabel() {
        super.showLabel();
        this._closeHelper.unregisterHandler();
    }

    public void showEditor() {
        super.showEditor();
        this._closeHelper.registerHandler();
    }

    protected void onUnload() {
        super.onUnload();
        this._closeHelper.unregisterHandler();
    }

    public void clearOptions() {
        this._optionsContainer.clear();
    }

    private void initEditorPanel() {
        this._editPanel.clear();
        this._editPanel.add((Widget)this._editorLabel);
        this._editPanel.add((Widget)this._optionsContainer);
    }

    public void addOption(String label, String value, boolean selected, boolean enabled, @Nullable String infoText, MultipleOptionsInlineEditView.SelectionChangeHandler changeHandler) {
        FlowPanel panel = new FlowPanel();
        InlineCheckBox checkbox = new InlineCheckBox(label);
        checkbox.setFormValue(value);
        checkbox.setValue(Boolean.valueOf(selected));
        checkbox.setEnabled(enabled);
        checkbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        panel.add((Widget)checkbox);
        if (!Strings.isNullOrEmpty((String)infoText)) {
            panel.add(this.createTooltip(infoText));
        }
        this._optionsContainer.add((Widget)panel);
    }

    @Nonnull
    private IsWidget createTooltip(String infoText) {
        JucoTooltip tooltip = new JucoTooltip(infoText);
        Icon icon = new Icon(IconType.INFO_SIGN);
        icon.addStyleName("info-icon");
        icon.setIconSize(IconSize.LARGE);
        tooltip.add((Widget)icon);
        return tooltip;
    }

    public void setLabel(String label) {
        this._currentLabel = label;
    }

    public void setEditorLabel(String label) {
        this._editorLabel.setText(label);
    }

    protected String getCurrentLabel() {
        return this._currentLabel;
    }
}

