/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.browsersearch;

import com.freiheit.toro.client.event.GlobalEventManager;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.browsersearch.BrowserSearchBundle;
import de.justsoftware.onx.common.presentation.client.ui.browsersearch.BrowserSearchNavigationWidget;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class BrowserSearchNavigationWidget
extends PopupPanel {
    private static volatile BrowserSearchNavigationWidget _instance;
    private static final BrowserSearchNavigationWidgetUiBinder UI_BINDER;
    @UiField
    TextBox _searchInput;

    private BrowserSearchNavigationWidget() {
        super(true, false);
        this.setWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this.addStyleName("browser-search-navigation-popup");
        this.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._searchInput.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        BrowserSearchBundle bundle = (BrowserSearchBundle)GWT.create(BrowserSearchBundle.class);
        ScriptInjector.fromString((String)bundle.jQueryHighlight().getText()).setWindow(this.rootWindow()).inject();
    }

    public static void showPopup(@Nullable String searchText, boolean stealFocus, int cursorPosition) {
        if (_instance == null) {
            _instance = new BrowserSearchNavigationWidget();
        }
        _instance.show(searchText, stealFocus, cursorPosition);
    }

    public void show(@Nullable String searchText, boolean stealFocus, int cursorPosition) {
        if (StringUtil.isBlank((String)searchText)) {
            this._searchInput.setText("");
            this.hide();
            return;
        }
        this._searchInput.setText(searchText.trim());
        this.search();
        super.show();
        if (stealFocus) {
            this._searchInput.setFocus(true);
            this._searchInput.setCursorPos(cursorPosition);
        }
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        if (this.isScrollbarClickEvent(event)) {
            this.setAutoHideEnabled(false);
        } else {
            this.setAutoHideEnabled(true);
        }
        super.onPreviewNativeEvent(event);
    }

    private boolean isScrollbarClickEvent(@Nonnull Event.NativePreviewEvent previewEvent) {
        if (previewEvent.isCanceled() || previewEvent.getNativeEvent() == null) {
            return false;
        }
        Event event = Event.as((NativeEvent)previewEvent.getNativeEvent());
        if (event.getTypeInt() != 4 && event.getTypeInt() != 1 && event.getTypeInt() != 0x100000) {
            return false;
        }
        if (!Element.is((JavaScriptObject)event.getEventTarget())) {
            return false;
        }
        Element element = Element.as((JavaScriptObject)event.getEventTarget());
        return "HTML".equals(element.getTagName());
    }

    @UiHandler(value={"_searchAnchor"})
    void onSearchClicked(@Nonnull ClickEvent e) {
        this.search();
    }

    private void search() {
        String searchFor = this._searchInput.getText();
        if (StringUtil.isBlank((String)searchFor)) {
            this.removeHighlight();
            return;
        }
        this.executeSearch(searchFor.trim());
    }

    @UiHandler(value={"_previousAnchor"})
    void onPreviousClicked(@Nonnull ClickEvent e) {
        this.executePrevious();
        GlobalEventManager.getInstance().fireAdjustEntityScrollPosition(0);
    }

    @UiHandler(value={"_nextAnchor"})
    void onNextClicked(@Nonnull ClickEvent e) {
        this.executeNext();
        GlobalEventManager.getInstance().fireAdjustEntityScrollPosition(0);
    }

    @UiHandler(value={"_closeAnchor"})
    void onCloseClicked(@Nonnull ClickEvent e) {
        this.hide();
    }

    @Nonnull
    private native JavaScriptObject rootWindow();

    private native void executeSearch(@Nonnull String var1);

    private native void removeHighlight();

    private native void executeNext();

    private native void executePrevious();

    static {
        UI_BINDER = (BrowserSearchNavigationWidgetUiBinder)GWT.create(BrowserSearchNavigationWidgetUiBinder.class);
    }
}

