/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.Mediated;
import com.freiheit.toro.common.shared.i18n.BasicConstants;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.PagingWidget;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import java.util.ArrayList;
import java.util.List;

public class PagingWidget<T>
extends FlowPanel
implements Mediated {
    private static final BasicConstants BASIC = I18nMediator.BASIC;
    private static final int DEFAULT_PAGE_RANGE = 3;
    protected int _itemsPerPage;
    protected int _currentPage = 1;
    private final HorizontalPanel _navigationPanelTop = new HorizontalPanel();
    private final HorizontalPanel _navigationPanelBottom = new HorizontalPanel();
    private final Panel _widgetListPanel;
    private final HorizontalPanel _headingPagingPanel = new HorizontalPanel();
    private final SimplePanel _subHeaderPanel = new SimplePanel();
    private final HorizontalPanel _bottomPagingPanel = new HorizontalPanel();
    private boolean _showBottomPager;
    private final PagingWidgetCreatePage<T> _createPage;
    private int _dataCount;
    private final Widget _title;
    private int _pageRange = 3;
    private int _lastPage;
    private boolean _isNavidetached;
    private Widget _noEntryWidget = new Label(BASIC.noEntries());
    private String _additionalLastStyle;
    private boolean _breakLineMiddle;
    private boolean _breakLineTop;
    private boolean _breakLineBottom;
    private boolean _showSimplePager;
    private boolean _showTopPager = true;
    private Panel _actionPanel = null;
    private boolean _showHeaderIfNoEntries = false;
    private boolean _insertClearPanel;
    private List<PageChangedListener<T>> _pageChangedListeners;
    private PageChangeRequestedCallback<T> _pageChangeRequestedCallback;
    private final BuildPagerCallback _buildPagerCallback = new BuildPagerCallback(this);

    public PagingWidget(int itemsPerPage, String title, PagingWidgetCreatePage<T> createPage) {
        this(itemsPerPage, title, (Panel)new FlowPanel(), createPage);
    }

    public PagingWidget(int itemsPerPage, String title, Panel listPanel, PagingWidgetCreatePage<T> createPage) {
        this(itemsPerPage, (Widget)(title != null ? new Label(title) : null), listPanel, createPage);
    }

    public PagingWidget(int itemsPerPage, Widget headerWidget, Panel listPanel, PagingWidgetCreatePage<T> createPage) {
        this._itemsPerPage = itemsPerPage;
        this._title = headerWidget;
        this._createPage = createPage;
        this._widgetListPanel = listPanel;
        this._additionalLastStyle = "last";
        this._headingPagingPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
        this._widgetListPanel.setStyleName("listContainer");
        this._subHeaderPanel.setVisible(false);
    }

    public void addListContainerStyleName(String stlyename) {
        this._widgetListPanel.addStyleName(stlyename);
    }

    public void setListContainerStyleName(String stlyename) {
        this._widgetListPanel.setStyleName(stlyename);
    }

    public void addPageChangedListener(PageChangedListener<T> listener) {
        if (this._pageChangedListeners == null) {
            this._pageChangedListeners = new ArrayList();
        }
        this._pageChangedListeners.add(listener);
    }

    public void removePageChangedListener(PageChangedListener<T> listener) {
        this._pageChangedListeners.remove(listener);
    }

    public int getPageRange() {
        return this._pageRange;
    }

    public void setPageRange(int pageRange) {
        this._pageRange = pageRange;
    }

    public int getDataCount() {
        return this._dataCount;
    }

    public int getCurrentPage() {
        return this._currentPage;
    }

    public void setCurrentPage(int page) {
        this._currentPage = page;
        this.updateAfterPageSet();
    }

    public void setHeadingPagingPanelVerticalAlignment(HasVerticalAlignment.VerticalAlignmentConstant vertical) {
        this._headingPagingPanel.setVerticalAlignment(vertical);
    }

    public final void update() {
        this.updatePagingWidget();
    }

    public void updatePagingWidget() {
        this.buildCurrentPage();
    }

    public void updateWithExternalData(int page, ListAndCount<T> pageData) {
        this._currentPage = page;
        this._buildPagerCallback.onSuccess(pageData);
    }

    private void buildCurrentPage() {
        int offset = this.getOffset();
        this._createPage.getListAndCount(offset, this._itemsPerPage, (AsyncCallback)this._buildPagerCallback);
    }

    public int getOffset() {
        return (this._currentPage - 1) * this._itemsPerPage;
    }

    public int getItemsPerPage() {
        return this._itemsPerPage;
    }

    public void setItemsPerPage(int perPage) {
        this._itemsPerPage = perPage;
    }

    public int getLastPage() {
        return this._lastPage;
    }

    public Panel getWidgetListPanel() {
        return this._widgetListPanel;
    }

    public boolean isShowBottomPager() {
        return this._showBottomPager;
    }

    public void setShowBottomPager(boolean bottomPager) {
        this._showBottomPager = bottomPager;
    }

    public Widget detachTopNavBar() {
        if (!this._isNavidetached) {
            this._isNavidetached = true;
            this._headingPagingPanel.removeFromParent();
        }
        return this._headingPagingPanel;
    }

    public Widget getNoEntryWidget() {
        return this._noEntryWidget;
    }

    public void setNoEntryWidget(Widget noEntryWidget) {
        this._noEntryWidget = noEntryWidget;
    }

    public void setSubheader(Widget subHeader, boolean showSubHeader) {
        this._subHeaderPanel.clear();
        this._subHeaderPanel.setVisible(showSubHeader);
        if (subHeader != null) {
            this._subHeaderPanel.add(subHeader);
        }
    }

    public void showSubheader() {
        this._headingPagingPanel.setStyleName("pagingPanelHeaderNoMargin");
        this._subHeaderPanel.setVisible(true);
    }

    public void hideSubheader() {
        this._headingPagingPanel.setStyleName("pagingPanelHeader");
        this._subHeaderPanel.setVisible(false);
    }

    public boolean isBreakLineMiddle() {
        return this._breakLineMiddle;
    }

    public void setBreakLineMiddle(boolean lineMiddle) {
        this._breakLineMiddle = lineMiddle;
    }

    public boolean isBreakLineTop() {
        return this._breakLineTop;
    }

    public void setBreakLineTop(boolean lineTop) {
        this._breakLineTop = lineTop;
    }

    public boolean isBreakLineBottom() {
        return this._breakLineBottom;
    }

    public void setBreakLineBottom(boolean lineBottom) {
        this._breakLineBottom = lineBottom;
    }

    public boolean isInsertClearPanel() {
        return this._insertClearPanel;
    }

    public void setInsertClearPanel(boolean clearPanel) {
        this._insertClearPanel = clearPanel;
    }

    public boolean isShowSimplePager() {
        return this._showSimplePager;
    }

    public void setShowSimplePager(boolean showSimplePager) {
        this._showSimplePager = showSimplePager;
    }

    public boolean isShowTopPager() {
        return this._showTopPager;
    }

    public void setShowTopPager(boolean showTopPager) {
        this._showTopPager = showTopPager;
    }

    public boolean setPagerTitle(String title) {
        if (this._title != null && this._title instanceof Label) {
            ((Label)this._title).setText(title);
            return true;
        }
        return false;
    }

    protected Widget createWidget(int index, T next, boolean last) {
        Widget w = this._createPage.createWidget(next, index);
        if (last) {
            w.addStyleName(this._additionalLastStyle);
        }
        return w;
    }

    public void setPageChangeRequestedCallback(PageChangeRequestedCallback<T> callback) {
        this._pageChangeRequestedCallback = callback;
    }

    private void updateAfterPageSet() {
        if (this._pageChangeRequestedCallback != null) {
            this._pageChangeRequestedCallback.onPageChangeRequested(this, (this._currentPage - 1) * this._itemsPerPage);
        } else {
            this.updatePagingWidget();
        }
    }

    public void setNoEntryText(String noEntryText) {
        this._noEntryWidget = new Label(noEntryText);
    }

    public void setAdditionalLastStyle(String additionalLastStyle) {
        this._additionalLastStyle = additionalLastStyle;
    }

    public String getAdditionalLastStyle() {
        return this._additionalLastStyle;
    }

    public void addActionWidget(Widget action) {
        if (this._actionPanel == null) {
            this._actionPanel = new HorizontalPanel();
            this._actionPanel.addStyleName("actions");
        }
        this._actionPanel.add(action);
    }

    public void clearActions() {
        this._actionPanel.clear();
        this._actionPanel = null;
    }

    public void setShowHeaderIfNoEntries(boolean showHeaderIfNoEntries) {
        this._showHeaderIfNoEntries = showHeaderIfNoEntries;
    }

    public boolean isShowHeaderIfNoEntries() {
        return this._showHeaderIfNoEntries;
    }
}

