/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.AbstractInPlaceEdit;
import de.justsoftware.onx.common.presentation.client.ui.GrowingTextArea;
import de.justsoftware.onx.common.presentation.client.ui.TextBoxWithDescription;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.Link;
import de.justsoftware.onx.common.shared.util.StringUtil;

public class InPlaceEditLink
extends AbstractInPlaceEdit<Link> {
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private Widget _show = new Anchor("", false);
    private final Panel _edit = new FlowPanel();
    private final GrowingTextArea _title = new GrowingTextArea();
    private final TextBoxWithDescription _href = new TextBoxWithDescription();
    private String _target = "";

    public InPlaceEditLink() {
        super((Object)new Link("", ""));
        this._edit.addStyleName("inlinePanel");
        this._edit.add((Widget)this._title);
        this._edit.add((Widget)this._href);
        this._title.setDescriptionText(BASIC.linkTitle());
        this._href.setDescriptionText(BASIC.linkHref());
        this._title.addKeyDownHandler(this.getKeyDownHandler(true));
        this._href.addKeyDownHandler(this.getKeyDownHandler(true));
        this.setShowWidget(this._show);
        this.setEditWidget((Widget)this._edit);
    }

    protected Link getEditValue() {
        return new Link(this._title.getText(), ClientStringUtil.toURL((String)this._href.getText()));
    }

    protected void setEditValue(Link value) {
        if (value == null) {
            this._title.setText("");
            this._href.setText("");
        } else {
            this._title.setText(value.getText());
            this._href.setText(value.getHrefOrEmpty());
        }
        this._title.setFocus(true);
    }

    protected void setShowValue(Link value) {
        if (value == null) {
            this.setShowValue(new Link("", ""));
            return;
        }
        String text = ClientStringUtil.hasText((String)value.getText()) ? value.getText() : value.getHref();
        this._show = StringUtil.isBlank((String)value.getHref()) ? new Label(value.getText()) : new Anchor(text, false, ClientStringUtil.toURL((String)value.getHref()), this._target);
        this.setShowWidget(this._show);
    }

    protected void setWaitValue(Link value) {
    }

    protected String validate(Link value) {
        return null;
    }

    public void setTitleMaxLength(int len) {
        this._title.setMaxLength(len);
    }

    public void setHrefMaxLength(int len) {
        this._href.setMaxLength(len);
    }

    public void setTarget(String target) {
        this._target = target;
        if (this._show instanceof Anchor) {
            ((Anchor)this._show).setTarget(target);
        }
    }

    public void setEditWidth(String width) {
        this._title.setWidth(width);
        this._href.setWidth(width);
    }
}

