/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.base.HasIcon;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Optional;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.JucoDropdownButton;
import de.justsoftware.gwt.user.client.ui.JucoTooltip;
import de.justsoftware.onx.common.presentation.client.AsyncClickHandler;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.EntityOptionsView;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.container.shared.model.EntityDetailsPublicData;
import de.justsoftware.onx.like.presentation.client.ui.EntitySubscribeButton;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityOptionsViewImpl
implements EntityOptionsView {
    private final ClientFactory _clientFactory;
    private JucoDropdownButton _membership = null;
    private final FlowPanel _actionsPanel = new FlowPanel();

    public EntityOptionsViewImpl(ClientFactory clientFactory) {
        this._actionsPanel.addStyleName("entity-header-actions-view");
        this._clientFactory = clientFactory;
    }

    public void resetButtons() {
        this._actionsPanel.clear();
    }

    private void addAction(IsWidget action) {
        int actionCount = this._actionsPanel.getWidgetCount();
        action.asWidget().addStyleName("last-action");
        action.asWidget().setStyleName("first-action", actionCount == 0);
        if (actionCount > 0) {
            this._actionsPanel.getWidget(actionCount - 1).setStyleName("last-action", false);
        }
        this._actionsPanel.add(action);
    }

    public void addButton(IsWidget button) {
        this.addAction(button);
    }

    public void addButtonGroup(IsWidget buttonGroup) {
        this.addAction(buttonGroup);
    }

    public void addEntitySubscribeButton(EntityDetailsPublicData entity) {
        EntitySubscribeButton subscribeButton = EntitySubscribeButton.create((ClientFactory)this._clientFactory, (EntityDetailsPublicData)entity);
        if (subscribeButton != null) {
            this.addAction((IsWidget)subscribeButton);
        }
    }

    public void addChangeMembershipOption(Optional<IconType> icon, String title, Optional<String> tooltip, AsyncClickHandler<Void, Throwable> asyncClickHandler) {
        if (this._membership != null) {
            this._membership.add(this.wrapWithIconTooltipAndClickhandler((UIObject)new NavLink(title), icon, title, tooltip, this.createShowLoadingClickHandler(this._membership, asyncClickHandler)));
        } else {
            JCButton button = new JCButton(title);
            this.addAction(this.wrapWithIconTooltipAndClickhandler((UIObject)button, icon, title, tooltip, this.createShowLoadingClickHandler(button, asyncClickHandler)));
        }
    }

    @Nonnull
    private ClickHandler createShowLoadingClickHandler(JCButton button, AsyncClickHandler<Void, Throwable> asyncClickHandler) {
        return e -> {
            button.setLoading(true, 200);
            asyncClickHandler.onClick(e).then(result -> {
                button.setLoading(false);
                return result;
            }, error -> {
                button.setLoading(false);
                return error;
            });
        };
    }

    private ClickHandler createShowLoadingClickHandler(JucoDropdownButton dropDownButton, AsyncClickHandler<Void, Throwable> asyncClickHandler) {
        return e -> {
            dropDownButton.setLoading(true, 200);
            asyncClickHandler.onClick(e).then(result -> {
                dropDownButton.setLoading(false);
                return result;
            }, error -> {
                dropDownButton.setLoading(false);
                return error;
            });
        };
    }

    public void setCurrentEventMembership(IconType icon, String title) {
        this._membership = new JucoDropdownButton(title);
        this._membership.setIcon(icon);
        this.addAction((IsWidget)this._membership);
    }

    @Nonnull
    private <W extends UIObject & IsWidget> IsWidget wrapWithIconTooltipAndClickhandler(W w, Optional<IconType> icon, String title, Optional<String> tooltip, ClickHandler clickHandler) {
        ((HasClickHandlers)w).addClickHandler(clickHandler);
        if (icon.isPresent()) {
            ((HasIcon)w).setIcon((IconType)icon.get());
        }
        if (tooltip.isPresent()) {
            JucoTooltip tooltipWidget = new JucoTooltip((String)tooltip.get());
            tooltipWidget.add((IsWidget)w);
            return tooltipWidget;
        }
        w.setTitle(title);
        return w;
    }

    public Widget asWidget() {
        return this._actionsPanel;
    }
}

