/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.NavList;
import com.github.gwtbootstrap.client.ui.NavWidget;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCPopupPanel;
import de.justsoftware.onx.components.presentation.client.ui.ShowPopupUtils;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreatePopup;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CreateEntityButtonWidget
extends FocusPanel {
    private final JCPopupPanel _popupMenu = new JCPopupPanel(true);
    private final ClientFactory _clientFactory;
    private final EntityId _defaultEntityId;

    public CreateEntityButtonWidget(ImmutableSet<EntityType> typesForMenuItems, @Nullable EntityId defaultEntityId, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._defaultEntityId = defaultEntityId;
        this.add((Widget)new Icon(IconType.PLUS));
        this.setTitle(clientFactory.localizedMessages().basicConstants().createItem());
        this._popupMenu.addAutoHidePartner((Element)this.getElement());
        NavList menuItems = this.createMenuItems(typesForMenuItems);
        if (typesForMenuItems.size() == 1) {
            EntityType entityType = (EntityType)typesForMenuItems.iterator().next();
            this.addClickHandler(e -> this.handleMenuItemClick(entityType));
        } else {
            this.addClickHandler(e -> ShowPopupUtils.toggleRelativeTo((PopupPanel)this._popupMenu, (Widget)menuItems, (Widget)this));
        }
    }

    private void handleMenuItemClick(EntityType type) {
        this._popupMenu.hide();
        EntityCreatePopup.show((ClientFactory)this._clientFactory, (EntityType)type, null, (String)"left_menu");
    }

    @Nonnull
    private NavList createMenuItems(ImmutableSet<EntityType> typesForMenuItems) {
        NavList contents = new NavList();
        for (EntityType type : typesForMenuItems) {
            NavWidget navWidget = new NavWidget();
            String typeName = this._clientFactory.localizedMessages().entityConstants(type).createEntityOfType(type);
            navWidget.setTitle(typeName);
            navWidget.setText(typeName);
            navWidget.addClickHandler(e -> this.handleMenuItemClick(type));
            contents.add((Widget)navWidget);
        }
        return contents;
    }
}

