/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client;

import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.base.Enums;
import de.justsoftware.onx.container.shared.model.GlobalId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public final class WidgetParamUtil {
    private WidgetParamUtil() {
    }

    @Nonnull
    public static <T extends Enum<T>> T getEnumParam(@Nullable String[] params, int paramIndex, Class<T> enumClass, T defaultValue) {
        if (params == null || params.length < paramIndex) {
            return defaultValue;
        }
        Enum result = (Enum)Enums.getIfPresent(enumClass, (String)params[paramIndex]).orNull();
        if (result == null) {
            LoggingUtil.error((Object)"WidgetParamUtil", (String)(params[paramIndex] + " is not a valid enum value of type " + enumClass.getSimpleName() + ". Use default value " + String.valueOf(defaultValue)));
            return defaultValue;
        }
        return (T)result;
    }

    @CheckForNull
    public static String getStringParamNullable(@Nullable String[] params, int paramIndex) {
        if (params == null || params.length <= paramIndex) {
            return null;
        }
        return params[paramIndex];
    }

    @Nonnull
    public static String getStringParam(@Nullable String[] widgetParams, int paramIndex) {
        if (widgetParams == null || widgetParams.length <= paramIndex) {
            LoggingUtil.log((Object)"WidgetParamUtil", (String)("Widget params index " + paramIndex + "not exists."));
            throw new IllegalArgumentException("widget params index " + paramIndex + "not exists.");
        }
        return widgetParams[paramIndex];
    }

    @Nonnull
    public static <T extends GlobalId> T getGlobalIdParam(@Nullable String[] widgetParams, int paramIndex) {
        GlobalId id = WidgetParamUtil.getGlobalIdParamNullable((String[])widgetParams, (int)paramIndex);
        if (id == null) {
            throw new IllegalArgumentException("Parsed globalId must not be null");
        }
        return (T)id;
    }

    @CheckForNull
    public static <T extends GlobalId> T getGlobalIdParamNullable(@Nullable String[] widgetParams, int paramIndex) {
        return (T)GlobalId.parse((String)WidgetParamUtil.getStringParam((String[])widgetParams, (int)paramIndex));
    }

    public static boolean getBooleanParam(@Nullable String[] widgetParams, int paramIndex) {
        return Boolean.parseBoolean(WidgetParamUtil.getStringParam((String[])widgetParams, (int)paramIndex));
    }

    public static int getIntParam(@Nullable String[] widgetParams, int paramIndex) {
        return Integer.parseInt(WidgetParamUtil.getStringParam((String[])widgetParams, (int)paramIndex));
    }

    @Nonnull
    public static Long getLongParam(@Nullable String[] widgetParams, int paramIndex) {
        return Long.parseLong(WidgetParamUtil.getStringParam((String[])widgetParams, (int)paramIndex));
    }
}

