/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.presentation.ui.SpanPanel;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.ExpandablePanel;
import de.justsoftware.onx.comments.presentation.client.ui.SingleCommentView;
import de.justsoftware.onx.comments.presentation.client.ui.SingleCommentViewImpl;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientRelativeDateUtil;
import de.justsoftware.onx.common.presentation.client.LoginPopupClickHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.like.presentation.client.ui.LikeView;
import de.justsoftware.onx.like.presentation.client.ui.LikeViewLink;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SingleCommentViewImpl
extends Composite
implements SingleCommentView {
    private static final SingleCommentWidgetUiBinder BINDER = (SingleCommentWidgetUiBinder)GWT.create(SingleCommentWidgetUiBinder.class);
    @UiField
    SimplePanel _profileImageContainer;
    @UiField
    SimplePanel _profileName;
    @UiField
    SimplePanel _text;
    @UiField
    InlineLabel _postedAt;
    @UiField
    InlineLabel _editedAt;
    @UiField
    InlineLabel _customInfo;
    @UiField
    LikeViewLink _likeView;
    @UiField
    SpanPanel _deleteLinkPanel;
    @UiField
    SpanPanel _editLinkPanel;
    @UiField
    FlowPanel _commentFooter;
    private final ClientFactory _clientFactory;
    private final SingleCommentView.Presenter _presenter;
    private final LikeView _likeViewWrapper = new /* Unavailable Anonymous Inner Class!! */;

    public SingleCommentViewImpl(ClientFactory clientFactory, SingleCommentView.Presenter presenter) {
        this._clientFactory = clientFactory;
        this._presenter = presenter;
        this.initWidget((Widget)BINDER.createAndBindUi((Object)this));
    }

    public void setText(String text, int maxDisplayLength) {
        this._text.setWidget((Widget)new ExpandablePanel(ClientStringUtil.nullToEmpty((String)text), maxDisplayLength, "loeschi", "loeschi", null, "app-color", ExpandablePanel.PanelType.INLINE));
    }

    public void setPostedAt(Date postedAt) {
        this._postedAt.setText(ClientRelativeDateUtil.INSTANCE.getRelativeTime(postedAt));
        this._postedAt.setTitle(this._clientFactory.dateFormatter().formatDateTime(postedAt));
    }

    public void setAuthor(PersonTeaserModel author) {
        PersonId authorId;
        this._profileName.setWidget(author != null ? PersonUtil.profileInlineLink((PersonTeaserModel)author, (ClientFactory)this._clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP) : null);
        Image profileImage = new Image(ImageUrlUtil.getFullXSmallUserImageUrl((String)(author != null ? author.getLogo() : null)));
        this._profileImageContainer.setWidget((Widget)profileImage);
        if (author != null && (authorId = (PersonId)author.getId()) != null && author.isVisible() && !author.isDeleted()) {
            String token = "/people/profile/" + String.valueOf(authorId);
            profileImage.addClickHandler(LoginPopupClickHandler.createWrappedClickHandler((ClickHandler)this._clientFactory.historyManager().createNewItemHandler(token)));
            profileImage.addStyleName("clickable");
            PersonUtil.createProfilePopup((PersonTeaserModel)author, (ClientFactory)this._clientFactory, (Widget)profileImage, (boolean)false);
        }
    }

    @UiHandler(value={"_deleteLink"})
    void onDelete(ClickEvent e) {
        ConfirmPopup.makeConfirmPopup((String)I18nMediator.COMMENTS.sureToDelete(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    @UiHandler(value={"_editLink"})
    void onEdit(ClickEvent e) {
        this._presenter.onEdit();
    }

    public void setCustomInfoDescription(String description) {
        boolean descriptionVisible = description != null;
        this._customInfo.setVisible(descriptionVisible);
        this._customInfo.setText(description);
        this.updateCommentFooterChildStyleNames();
    }

    public void setEditAllowed(boolean editAllowed) {
        this._editLinkPanel.setVisible(editAllowed);
        this.updateCommentFooterChildStyleNames();
    }

    public void setDeleteAllowed(boolean deleteAllowed) {
        this._deleteLinkPanel.setVisible(deleteAllowed);
        this.updateCommentFooterChildStyleNames();
    }

    public void setEditedAt(Date editedAt) {
        boolean editedAtVisible = editedAt != null;
        this._editedAt.setVisible(editedAtVisible);
        this._editedAt.setTitle(editedAtVisible ? this._clientFactory.dateFormatter().formatDateTime(editedAt) : null);
        this.updateCommentFooterChildStyleNames();
    }

    protected void onLoad() {
        super.onLoad();
        this.updateCommentFooterChildStyleNames();
    }

    private void updateCommentFooterChildStyleNames() {
        if (!this.isAttached()) {
            return;
        }
        int found = 0;
        for (Widget w : this._commentFooter) {
            if (w.isVisible() && w.isAttached()) {
                ++found;
            }
            w.setStyleName("comment-footer-element-not-first", found != 1);
        }
    }

    public LikeView likeView() {
        return this._likeViewWrapper;
    }
}

